/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.java;

import oracle.bpm.bac.core.BacConfig;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.model.BranchType;
import oracle.bpm.bac.core.model.Node;
import oracle.bpm.bac.core.model.Project;
import oracle.bpm.bac.service.PublishService;
import oracle.bpm.bac.service.impl.PublishServiceTxWrapperImpl;
import org.jetbrains.annotations.NotNull;

public class BacServiceClient {
    private PublishService service;

    private BacServiceClient(@NotNull BacConfig config) throws BacException {
        if (config == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.<init> must not be null");
        }
        this.service = new PublishServiceTxWrapperImpl(config);
    }

    public static BacServiceClient create(@NotNull BacConfig config) throws BacException {
        if (config == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.create must not be null");
        }
        return new BacServiceClient(config);
    }

    public Node getRoot() throws BacException {
        return this.service.getRoot();
    }

    public void createFolder(String folderPath) throws BacException {
        this.service.createFolder(folderPath);
    }

    public void createProject(@NotNull String location, @NotNull String name) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.createProject must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.createProject must not be null");
        }
        this.service.createProject(location, name);
    }

    public void createBranch(@NotNull Project project, @NotNull String name) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.createBranch must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.createBranch must not be null");
        }
        this.service.createBranch(project, BranchType.BRANCH, name);
    }

    public void createTag(@NotNull Project project, @NotNull String name) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.createTag must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/client/java/BacServiceClient.createTag must not be null");
        }
        this.service.createBranch(project, BranchType.TAG, name);
    }
}

