/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import oracle.bpm.bac.client.cli.Action;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextMenuOption
implements Action {
    private Action action;
    private String title;

    public TextMenuOption(@NotNull String title, @Nullable Action action) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/TextMenuOption.<init> must not be null");
        }
        this.title = title;
        this.action = action;
    }

    protected TextMenuOption(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/TextMenuOption.<init> must not be null");
        }
        this(title, null);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean getAction() {
        return this.action != null;
    }

    @Override
    public void execute() {
        if (this.action == null) {
            ConsoleUtil.println(ConsoleUtil.Color.YELLOW, "There is no action set for '" + this.getTitle() + "'");
        }
        try {
            this.action.execute();
        }
        catch (Throwable t) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "An error occurred executing the option '" + this.getTitle() + "'");
            t.printStackTrace(System.err);
        }
    }

    protected void setAction(@NotNull Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/TextMenuOption.setAction must not be null");
        }
        this.action = action;
    }
}

