/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpm.bac.client.cli.Action;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import oracle.bpm.bac.client.cli.TextMenuOption;
import org.jetbrains.annotations.NotNull;

class TextMenu
extends TextMenuOption {
    private List<TextMenuOption> options;
    private static final TextMenuOption QUIT = new TextMenuOption("Quit", new Action(){

        @Override
        public void execute() {
            System.exit(0);
        }
    });
    private static final TextMenuOption BACK = new TextMenuOption("Back");

    public TextMenu(@NotNull String title, boolean addBack, boolean addQuit, TextMenuOption ... options) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/TextMenu.<init> must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/bac/client/cli/TextMenu.<init> must not be null");
        }
        super(title);
        this.options = null;
        this.setAction(this);
        this.initialize(addBack, addQuit, options);
    }

    @Override
    public void execute() {
        try {
            TextMenuOption option = this.prompt();
            while (option.getAction()) {
                option.execute();
                option = this.prompt();
            }
        }
        catch (Throwable t) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "An error occurred execution the option '" + this.getTitle() + "'");
            t.printStackTrace(System.out);
        }
    }

    private void initialize(boolean addBack, boolean addQuit, TextMenuOption ... options) {
        if (options == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/client/cli/TextMenu.initialize must not be null");
        }
        this.options = new ArrayList<TextMenuOption>(Arrays.asList(options));
        if (addBack) {
            this.options.add(BACK);
        }
        if (addQuit) {
            this.options.add(QUIT);
        }
    }

    private void display() {
        int option = 0;
        char[] chars = new char[62];
        Arrays.fill(chars, '=');
        String border = new String(chars);
        ConsoleUtil.println();
        ConsoleUtil.println(ConsoleUtil.Color.WHITE, border);
        ConsoleUtil.println(ConsoleUtil.Color.RED, " " + this.getTitle());
        ConsoleUtil.println(ConsoleUtil.Color.WHITE, border);
        for (TextMenuOption item : this.options) {
            ConsoleUtil.println(option++ + "- " + item.getTitle());
        }
        ConsoleUtil.print("select option: ");
        System.out.flush();
    }

    private TextMenuOption prompt() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            this.display();
            String line = br.readLine();
            try {
                int option = Integer.parseInt(line);
                if (option >= 0 && option < this.options.size()) {
                    return this.options.get(option);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ConsoleUtil.println(ConsoleUtil.Color.YELLOW, "Invalid Entry!");
        }
    }
}

