/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import java.util.List;
import oracle.bpm.bac.client.cli.Action;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import oracle.bpm.bac.client.java.BacServiceClient;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.impl.svn.Types;
import oracle.bpm.bac.core.model.Node;
import org.jetbrains.annotations.NotNull;

class ShowTreeNodeAction
implements Action {
    private BacServiceClient client;

    public ShowTreeNodeAction(@NotNull BacServiceClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/ShowTreeNodeAction.<init> must not be null");
        }
        this.client = client;
    }

    @Override
    public void execute() {
        try {
            Node root = this.client.getRoot();
            int pos = 1;
            ConsoleUtil.println(ConsoleUtil.Color.CYAN, "[" + pos++ + "] " + root.getName());
            this.showChildren(root, 3, pos);
        }
        catch (BacException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "The Tree can not be displayed.");
            e.printStackTrace();
        }
    }

    private int showChildren(@NotNull Node node, int tab, Integer pos) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/ShowTreeNodeAction.showChildren must not be null");
        }
        List<Node> children = node.getChildren();
        String padding = String.format("%1$#" + tab + "s", " ");
        for (Node child : children) {
            boolean isFolder = Types.FOLDER.getCode().equals(child.getType());
            ConsoleUtil.Color color = isFolder ? ConsoleUtil.Color.CYAN : ConsoleUtil.Color.MAGENTA;
            ConsoleUtil.println(color, padding + "|__ [" + pos + "] " + child.getName());
            Integer n = pos;
            Integer n2 = pos = Integer.valueOf(pos + 1);
            if (child.getChildren() == null) continue;
            pos = this.showChildren(child, tab + 3, pos);
        }
        return pos;
    }
}

