/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import java.util.Map;
import java.util.Scanner;
import oracle.bpm.bac.client.cli.Action;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import oracle.bpm.bac.client.cli.TreeSearch;
import oracle.bpm.bac.client.java.BacServiceClient;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.model.Node;
import org.jetbrains.annotations.NotNull;

class ShowNodeDetailAction
implements Action {
    private BacServiceClient client;

    public ShowNodeDetailAction(@NotNull BacServiceClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/ShowNodeDetailAction.<init> must not be null");
        }
        this.client = client;
    }

    @Override
    public void execute() {
        try {
            Node root = this.client.getRoot();
            Scanner scan = new Scanner(System.in);
            ConsoleUtil.print(ConsoleUtil.Color.GREEN, "Enter tree node nro: ");
            int searchPos = scan.nextInt();
            Node children = new TreeSearch().findChildren(root, searchPos);
            if (children == null) {
                ConsoleUtil.print(ConsoleUtil.Color.YELLOW, "The node [" + searchPos + "] was not found.");
            } else {
                ConsoleUtil.println(ConsoleUtil.Color.GREEN, "Node details:");
                ConsoleUtil.println(ConsoleUtil.Color.GREEN, "-------------");
                Map<String, String> rawProperties = children.getRawProperties();
                for (String propName : rawProperties.keySet()) {
                    ConsoleUtil.print(ConsoleUtil.Color.WHITE, propName + ": ");
                    ConsoleUtil.println(ConsoleUtil.Color.WHITE, rawProperties.get(propName));
                }
                ConsoleUtil.println("");
            }
        }
        catch (BacException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "The Node details can not be displayed.");
            e.printStackTrace();
        }
    }
}

