/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import java.util.List;
import java.util.Scanner;
import oracle.bpm.bac.client.cli.Action;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import oracle.bpm.bac.client.cli.TreeSearch;
import oracle.bpm.bac.client.java.BacServiceClient;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.model.Node;
import oracle.bpm.bac.core.model.Project;
import org.jetbrains.annotations.NotNull;

class ShowContentAction
implements Action {
    private BacServiceClient client;
    private String type;

    public ShowContentAction(@NotNull BacServiceClient client, @NotNull String type) {
        if (client == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/ShowContentAction.<init> must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/client/cli/ShowContentAction.<init> must not be null");
        }
        this.client = client;
        this.type = type;
    }

    @Override
    public void execute() {
        try {
            Node root = this.client.getRoot();
            Scanner scan = new Scanner(System.in);
            ConsoleUtil.print(ConsoleUtil.Color.GREEN, "Enter project node nro: ");
            int searchPos = scan.nextInt();
            Node children = new TreeSearch().findChildren(root, searchPos);
            if (children == null) {
                ConsoleUtil.println(ConsoleUtil.Color.YELLOW, "The node [" + searchPos + "] was not found.");
            } else {
                List<String> items;
                if ("branches".equals(this.type)) {
                    items = ((Project)children).getBranches();
                    ConsoleUtil.println(ConsoleUtil.Color.GREEN, "Branches:");
                } else {
                    items = ((Project)children).getTags();
                    ConsoleUtil.println(ConsoleUtil.Color.GREEN, "Tags:");
                }
                ConsoleUtil.println(ConsoleUtil.Color.GREEN, "-------------");
                if (!items.isEmpty()) {
                    for (String item : items) {
                        ConsoleUtil.println(ConsoleUtil.Color.WHITE, item);
                    }
                } else {
                    ConsoleUtil.println(ConsoleUtil.Color.GREEN, "There is not " + this.type);
                }
            }
        }
        catch (BacException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "An error occurred trying to create a project");
            e.printStackTrace();
        }
    }
}

