/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import java.util.Scanner;
import oracle.bpm.bac.client.cli.Action;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import oracle.bpm.bac.client.java.BacServiceClient;
import oracle.bpm.bac.core.exception.BacException;
import org.jetbrains.annotations.NotNull;

class CreateProjectAction
implements Action {
    private BacServiceClient client;

    public CreateProjectAction(@NotNull BacServiceClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/CreateProjectAction.<init> must not be null");
        }
        this.client = client;
    }

    @Override
    public void execute() {
        Scanner scan = new Scanner(System.in);
        ConsoleUtil.print(ConsoleUtil.Color.GREEN, "New Project Name");
        String projectName = scan.next();
        ConsoleUtil.print(ConsoleUtil.Color.GREEN, "Project folder location [Tree node nro]");
        String location = scan.next();
        try {
            this.client.createProject(location, projectName);
        }
        catch (BacException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "An error occurred trying to create a project");
            e.printStackTrace();
        }
    }
}

