/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import java.util.Scanner;
import oracle.bpm.bac.client.cli.Action;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import oracle.bpm.bac.client.cli.TreeSearch;
import oracle.bpm.bac.client.java.BacServiceClient;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.model.Node;
import oracle.bpm.bac.core.model.Project;
import org.jetbrains.annotations.NotNull;

class CreateBranchAction
implements Action {
    private BacServiceClient client;

    public CreateBranchAction(@NotNull BacServiceClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/CreateBranchAction.<init> must not be null");
        }
        this.client = client;
    }

    @Override
    public void execute() {
        Scanner scan = new Scanner(System.in);
        ConsoleUtil.print(ConsoleUtil.Color.GREEN, "New branch name: ");
        String branchName = scan.next();
        ConsoleUtil.print(ConsoleUtil.Color.GREEN, "Select the project [Tree node nro]: ");
        int parentLocation = scan.nextInt();
        try {
            Node root = this.client.getRoot();
            Node children = new TreeSearch().findChildren(root, parentLocation);
            if (children == null) {
                ConsoleUtil.println(ConsoleUtil.Color.YELLOW, "The node [" + parentLocation + "] was not found.");
            } else {
                this.client.createBranch((Project)children, branchName);
            }
        }
        catch (BacException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "An error occurred trying to create a folder");
            e.printStackTrace();
        }
    }
}

