/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.client.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;
import oracle.bpm.bac.client.cli.ConsoleUtil;
import oracle.bpm.bac.client.cli.CreateBranchAction;
import oracle.bpm.bac.client.cli.CreateFolderAction;
import oracle.bpm.bac.client.cli.ShowContentAction;
import oracle.bpm.bac.client.cli.ShowNodeDetailAction;
import oracle.bpm.bac.client.cli.ShowTreeNodeAction;
import oracle.bpm.bac.client.cli.TextMenu;
import oracle.bpm.bac.client.cli.TextMenuOption;
import oracle.bpm.bac.client.java.BacServiceClient;
import oracle.bpm.bac.core.BacConfig;
import oracle.bpm.bac.core.BacConnectionType;
import oracle.bpm.bac.core.exception.BacException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jetbrains.annotations.NotNull;

public final class Console {
    public static void main(String[] args) {
        Options opt = Console.createOptions();
        PosixParser parser = new PosixParser();
        ConsoleUtil.color(true);
        try {
            CommandLine commandLine = parser.parse(opt, args);
            ConsoleUtil.cls();
            if (commandLine.hasOption("help")) {
                Console.printHelp(System.out, opt);
                System.exit(0);
            } else if (!commandLine.hasOption("configFile")) {
                Console.printHelp(System.out, opt);
            } else {
                Properties prop = new Properties();
                prop.load(new FileInputStream(new File(commandLine.getOptionValue("configFile"))));
                BacConfig bacConfig = Console.createBacConfig(prop);
                ConsoleUtil.println(ConsoleUtil.Color.MAGENTA, "Connecting...");
                BacServiceClient client = BacServiceClient.create(bacConfig);
                ConsoleUtil.println(ConsoleUtil.Color.GREEN, "Connected.");
                Console.createMenus(client).execute();
            }
        }
        catch (BacException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "Failing to connect to SVN");
            e.printStackTrace();
            System.exit(1);
        }
        catch (ParseException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "Parsing parameter error.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (FileNotFoundException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "I/O error.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            ConsoleUtil.println(ConsoleUtil.Color.RED, "I/O error.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static TextMenu createMenus(@NotNull BacServiceClient client) {
        if (client == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/Console.createMenus must not be null");
        }
        TextMenuOption showTreeOpt = new TextMenuOption("Show Tree Node", new ShowTreeNodeAction(client));
        TextMenuOption showPropertiesOpt = new TextMenuOption("Show Properties", new ShowNodeDetailAction(client));
        TextMenuOption showBranchesOpt = new TextMenuOption("Show branches", new ShowContentAction(client, "branches"));
        TextMenuOption showTagsOpt = new TextMenuOption("Show tags", new ShowContentAction(client, "tags"));
        TextMenuOption createFolderOpt = new TextMenuOption("Create folder", new CreateFolderAction(client));
        TextMenuOption createBranchOpt = new TextMenuOption("Create branch", new CreateBranchAction(client));
        TextMenuOption createTagOpt = new TextMenuOption("Create Tag", new CreateBranchAction(client));
        TextMenu createMenu = new TextMenu("Create", true, false, createFolderOpt, createBranchOpt, createTagOpt);
        TextMenu viewDetailsMenu = new TextMenu("View Node Details", true, false, showPropertiesOpt, showBranchesOpt, showTagsOpt);
        return new TextMenu("Business Asset Catalog Console", false, true, showTreeOpt, viewDetailsMenu, createMenu);
    }

    private static BacConfig createBacConfig(@NotNull Properties prop) {
        if (prop == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/Console.createBacConfig must not be null");
        }
        String name = prop.getProperty("name");
        String connectionString = prop.getProperty("connectionString");
        String connectionType = prop.getProperty("connectionType");
        BacConnectionType type = "local".equals(connectionType) ? BacConnectionType.LOCAL : BacConnectionType.REMOTE;
        return BacConfig.create(name, connectionString, "", type);
    }

    private static Options createOptions() {
        Options opt = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)"configFile");
        OptionBuilder.withDescription((String)"Bac Config File");
        opt.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Print help for this application");
        opt.addOption(OptionBuilder.create((String)"h"));
        return opt;
    }

    private static void printHelp(@NotNull PrintStream out, @NotNull Options options) {
        if (out == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/client/cli/Console.printHelp must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/client/cli/Console.printHelp must not be null");
        }
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(out);
        formatter.printHelp(pw, 80, "bac_console [options]", "options:", options, 2, 4, null, false);
        pw.flush();
    }
}

