/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.handlers.http;

import org.apache.mina.proxy.ProxyAuthException;
import org.apache.mina.proxy.handlers.http.AbstractAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.basic.HttpBasicAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.basic.HttpNoAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.digest.HttpDigestAuthLogicHandler;
import org.apache.mina.proxy.handlers.http.ntlm.HttpNTLMAuthLogicHandler;
import org.apache.mina.proxy.session.ProxyIoSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpAuthenticationMethods {
    NO_AUTH(1),
    BASIC(2),
    NTLM(3),
    DIGEST(4);

    private final int id;

    private HttpAuthenticationMethods(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public AbstractAuthLogicHandler getNewHandler(ProxyIoSession proxyIoSession) throws ProxyAuthException {
        switch (this) {
            case BASIC: {
                return new HttpBasicAuthLogicHandler(proxyIoSession);
            }
            case DIGEST: {
                HttpDigestAuthLogicHandler authHandler = new HttpDigestAuthLogicHandler(proxyIoSession);
                return authHandler;
            }
            case NTLM: {
                return new HttpNTLMAuthLogicHandler(proxyIoSession);
            }
            case NO_AUTH: {
                return new HttpNoAuthLogicHandler(proxyIoSession);
            }
        }
        return null;
    }
}

