/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.logging;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.logging.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingFilter
extends IoFilterAdapter {
    private final String name;
    private final Logger logger;
    private LogLevel exceptionCaughtLevel = LogLevel.WARN;
    private LogLevel messageSentLevel = LogLevel.INFO;
    private LogLevel messageReceivedLevel = LogLevel.INFO;
    private LogLevel sessionCreatedLevel = LogLevel.INFO;
    private LogLevel sessionOpenedLevel = LogLevel.INFO;
    private LogLevel sessionIdleLevel = LogLevel.INFO;
    private LogLevel sessionClosedLevel = LogLevel.INFO;

    public LoggingFilter() {
        this(LoggingFilter.class.getName());
    }

    public LoggingFilter(Class<?> clazz) {
        this(clazz.getName());
    }

    public LoggingFilter(String name) {
        this.name = name == null ? LoggingFilter.class.getName() : name;
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public String getName() {
        return this.name;
    }

    private void log(LogLevel eventLevel, String message, Throwable cause) {
        if (eventLevel == LogLevel.TRACE) {
            this.logger.trace(message, cause);
        } else if (eventLevel.getLevel() > LogLevel.INFO.getLevel()) {
            this.logger.info(message, cause);
        } else if (eventLevel.getLevel() > LogLevel.WARN.getLevel()) {
            this.logger.warn(message, cause);
        } else if (eventLevel.getLevel() > LogLevel.ERROR.getLevel()) {
            this.logger.error(message, cause);
        }
    }

    private void log(LogLevel eventLevel, String message, Object param) {
        if (eventLevel == LogLevel.TRACE) {
            this.logger.trace(message, param);
        } else if (eventLevel.getLevel() > LogLevel.INFO.getLevel()) {
            this.logger.info(message, param);
        } else if (eventLevel.getLevel() > LogLevel.WARN.getLevel()) {
            this.logger.warn(message, param);
        } else if (eventLevel.getLevel() > LogLevel.ERROR.getLevel()) {
            this.logger.error(message, param);
        }
    }

    private void log(LogLevel eventLevel, String message) {
        if (eventLevel == LogLevel.TRACE) {
            this.logger.trace(message);
        } else if (eventLevel.getLevel() > LogLevel.INFO.getLevel()) {
            this.logger.info(message);
        } else if (eventLevel.getLevel() > LogLevel.WARN.getLevel()) {
            this.logger.warn(message);
        } else if (eventLevel.getLevel() > LogLevel.ERROR.getLevel()) {
            this.logger.error(message);
        }
    }

    @Override
    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        this.log(this.exceptionCaughtLevel, "EXCEPTION :", cause);
        nextFilter.exceptionCaught(session, cause);
    }

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.log(this.messageReceivedLevel, "RECEIVED: {}", message);
        nextFilter.messageReceived(session, message);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        this.log(this.messageSentLevel, "SENT: {}", writeRequest.getMessage());
        nextFilter.messageSent(session, writeRequest);
    }

    @Override
    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.log(this.sessionCreatedLevel, "CREATED");
        nextFilter.sessionCreated(session);
    }

    @Override
    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.log(this.sessionOpenedLevel, "OPENED");
        nextFilter.sessionOpened(session);
    }

    @Override
    public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
        this.log(this.sessionIdleLevel, "IDLE");
        nextFilter.sessionIdle(session, status);
    }

    @Override
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        this.log(this.sessionClosedLevel, "CLOSED");
        nextFilter.sessionClosed(session);
    }

    public void setExceptionCaughtLoglevel(LogLevel level) {
        this.exceptionCaughtLevel = level;
    }

    public LogLevel getExceptionCaughtLoglevel() {
        return this.exceptionCaughtLevel;
    }

    public void setMessageReceivedLoglevel(LogLevel level) {
        this.messageReceivedLevel = level;
    }

    public LogLevel getMessageReceivedLoglevel() {
        return this.messageReceivedLevel;
    }

    public void setMessageSentLoglevel(LogLevel level) {
        this.messageSentLevel = level;
    }

    public LogLevel getMessageSentLoglevel() {
        return this.messageSentLevel;
    }

    public void setSessionCreatedLoglevel(LogLevel level) {
        this.sessionCreatedLevel = level;
    }

    public LogLevel getSessionCreatedLoglevel() {
        return this.sessionCreatedLevel;
    }

    public void setSessionOpenedLoglevel(LogLevel level) {
        this.sessionOpenedLevel = level;
    }

    public LogLevel getSessionOpenedLoglevel() {
        return this.sessionOpenedLevel;
    }

    public void setSessionIdleLoglevel(LogLevel level) {
        this.sessionIdleLevel = level;
    }

    public LogLevel getSessionIdleLoglevel() {
        return this.sessionIdleLevel;
    }

    public void setSessionClosedLoglevel(LogLevel level) {
        this.sessionClosedLevel = level;
    }

    public LogLevel getSessionClosedLoglevel() {
        return this.sessionClosedLevel;
    }
}

