/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.DummySession;
import org.apache.mina.core.session.IoEvent;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.executor.IoEventQueueHandler;
import org.apache.mina.util.CircularQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final IoSession EXIT_SIGNAL = new DummySession();
    private final AttributeKey BUFFER = new AttributeKey(this.getClass(), "buffer");
    private final BlockingQueue<IoSession> waitingSessions = new LinkedBlockingQueue<IoSession>();
    private final Set<Worker> workers = new HashSet<Worker>();
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int largestPoolSize;
    private final AtomicInteger idleWorkers = new AtomicInteger();
    private long completedTaskCount;
    private volatile boolean shutdown;
    private final IoEventQueueHandler queueHandler;

    public OrderedThreadPoolExecutor() {
        this(16);
    }

    public OrderedThreadPoolExecutor(int maximumPoolSize) {
        this(0, maximumPoolSize);
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize) {
        this(corePoolSize, maximumPoolSize, 30L, TimeUnit.SECONDS);
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory());
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, IoEventQueueHandler queueHandler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, Executors.defaultThreadFactory(), queueHandler);
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadFactory, null);
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory, IoEventQueueHandler queueHandler) {
        super(0, 1, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("corePoolSize: " + corePoolSize);
        }
        if (maximumPoolSize == 0 || maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        if (queueHandler == null) {
            queueHandler = IoEventQueueHandler.NOOP;
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.queueHandler = queueHandler;
    }

    public IoEventQueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() >= this.maximumPoolSize) {
                return;
            }
            Worker worker = new Worker();
            Thread thread = this.getThreadFactory().newThread(worker);
            this.idleWorkers.incrementAndGet();
            thread.start();
            this.workers.add(worker);
            if (this.workers.size() > this.largestPoolSize) {
                this.largestPoolSize = this.workers.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkerIfNecessary() {
        if (this.idleWorkers.get() == 0) {
            Set<Worker> set = this.workers;
            synchronized (set) {
                if (this.workers.isEmpty() || this.idleWorkers.get() == 0) {
                    this.addWorker();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWorker() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() <= this.corePoolSize) {
                return;
            }
            this.waitingSessions.offer(EXIT_SIGNAL);
        }
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException("maximumPoolSize: " + maximumPoolSize);
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            this.maximumPoolSize = maximumPoolSize;
            for (int difference = this.workers.size() - maximumPoolSize; difference > 0; --difference) {
                this.removeWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        Set<Worker> set = this.workers;
        synchronized (set) {
            long waitTime;
            while (!this.isTerminated() && (waitTime = deadline - System.currentTimeMillis()) > 0L) {
                this.workers.wait(waitTime);
            }
        }
        return this.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        if (!this.shutdown) {
            return false;
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (int i = this.workers.size(); i > 0; --i) {
                this.waitingSessions.offer(EXIT_SIGNAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        IoSession session;
        this.shutdown();
        ArrayList<Runnable> answer = new ArrayList<Runnable>();
        while ((session = (IoSession)this.waitingSessions.poll()) != null) {
            if (session == EXIT_SIGNAL) {
                this.waitingSessions.offer(EXIT_SIGNAL);
                Thread.yield();
                continue;
            }
            SessionBuffer buf = (SessionBuffer)session.getAttribute(this.BUFFER);
            Queue queue = buf.queue;
            synchronized (queue) {
                for (Runnable task : buf.queue) {
                    this.getQueueHandler().polled(this, (IoEvent)task);
                    answer.add(task);
                }
                buf.queue.clear();
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        boolean offerSession;
        if (this.shutdown) {
            this.rejectTask(task);
        }
        this.checkTaskType(task);
        IoEvent e = (IoEvent)task;
        IoSession s = e.getSession();
        SessionBuffer buf = this.getSessionBuffer(s);
        Queue queue = buf.queue;
        boolean offerEvent = this.queueHandler.accept(this, e);
        if (offerEvent) {
            Queue queue2 = queue;
            synchronized (queue2) {
                queue.offer(e);
                if (buf.processingCompleted) {
                    buf.processingCompleted = false;
                    offerSession = true;
                } else {
                    offerSession = false;
                }
            }
        } else {
            offerSession = false;
        }
        if (offerSession) {
            this.waitingSessions.offer(s);
        }
        this.addWorkerIfNecessary();
        if (offerEvent) {
            this.queueHandler.offered(this, e);
        }
    }

    private void rejectTask(Runnable task) {
        this.getRejectedExecutionHandler().rejectedExecution(task, this);
    }

    private void checkTaskType(Runnable task) {
        if (!(task instanceof IoEvent)) {
            throw new IllegalArgumentException("task must be an IoEvent or its subclass.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size() - this.idleWorkers.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompletedTaskCount() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            long answer = this.completedTaskCount;
            for (Worker w : this.workers) {
                answer += w.completedTaskCount;
            }
            return answer;
        }
    }

    @Override
    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.workers.size();
        }
    }

    @Override
    public long getTaskCount() {
        return this.getCompletedTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminating() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            return this.isShutdown() && !this.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prestartAllCoreThreads() {
        int answer = 0;
        Set<Worker> set = this.workers;
        synchronized (set) {
            for (int i = this.corePoolSize - this.workers.size(); i > 0; --i) {
                this.addWorker();
                ++answer;
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prestartCoreThread() {
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.workers.size() < this.corePoolSize) {
                this.addWorker();
                return true;
            }
            return false;
        }
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void purge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Runnable task) {
        boolean removed;
        this.checkTaskType(task);
        IoEvent e = (IoEvent)task;
        IoSession s = e.getSession();
        SessionBuffer buffer = (SessionBuffer)s.getAttribute(this.BUFFER);
        if (buffer == null) {
            return false;
        }
        Queue queue = buffer.queue;
        synchronized (queue) {
            removed = buffer.queue.remove(task);
        }
        if (removed) {
            this.getQueueHandler().polled(this, e);
        }
        return removed;
    }

    @Override
    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException("corePoolSize: " + corePoolSize);
        }
        if (corePoolSize > this.maximumPoolSize) {
            throw new IllegalArgumentException("corePoolSize exceeds maximumPoolSize");
        }
        Set<Worker> set = this.workers;
        synchronized (set) {
            if (this.corePoolSize > corePoolSize) {
                for (int i = this.corePoolSize - corePoolSize; i > 0; --i) {
                    this.removeWorker();
                }
            }
            this.corePoolSize = corePoolSize;
        }
    }

    private SessionBuffer getSessionBuffer(IoSession session) {
        SessionBuffer oldBuffer;
        SessionBuffer buffer = (SessionBuffer)session.getAttribute(this.BUFFER);
        if (buffer == null && (oldBuffer = (SessionBuffer)session.setAttributeIfAbsent(this.BUFFER, buffer = new SessionBuffer())) != null) {
            buffer = oldBuffer;
        }
        return buffer;
    }

    static /* synthetic */ AtomicInteger access$500(OrderedThreadPoolExecutor x0) {
        return x0.idleWorkers;
    }

    static /* synthetic */ Set access$600(OrderedThreadPoolExecutor x0) {
        return x0.workers;
    }

    static /* synthetic */ int access$700(OrderedThreadPoolExecutor x0) {
        return x0.corePoolSize;
    }

    static /* synthetic */ IoSession access$800() {
        return EXIT_SIGNAL;
    }

    static /* synthetic */ SessionBuffer access$900(OrderedThreadPoolExecutor x0, IoSession x1) {
        return x0.getSessionBuffer(x1);
    }

    static /* synthetic */ long access$1014(OrderedThreadPoolExecutor x0, long x1) {
        return x0.completedTaskCount += x1;
    }

    private class Worker
    implements Runnable {
        private volatile long completedTaskCount;
        private Thread thread;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block19: {
                this.thread = Thread.currentThread();
                while (true) lbl-1000:
                // 4 sources

                {
                    session = this.fetchSession();
                    OrderedThreadPoolExecutor.access$500(OrderedThreadPoolExecutor.this).decrementAndGet();
                    if (session == null) {
                        var2_2 = OrderedThreadPoolExecutor.access$600(OrderedThreadPoolExecutor.this);
                        synchronized (var2_2) {
                            if (OrderedThreadPoolExecutor.access$600(OrderedThreadPoolExecutor.this).size() > OrderedThreadPoolExecutor.access$700(OrderedThreadPoolExecutor.this)) {
                                OrderedThreadPoolExecutor.access$600(OrderedThreadPoolExecutor.this).remove(this);
                                break block19;
                            }
                        }
                    }
                    if (session == OrderedThreadPoolExecutor.access$800()) {
                        break block19;
                    }
                    try {
                        if (session == null) ** GOTO lbl-1000
                        this.runTasks(OrderedThreadPoolExecutor.access$900(OrderedThreadPoolExecutor.this, session));
                    }
                    finally {
                        OrderedThreadPoolExecutor.access$500(OrderedThreadPoolExecutor.this).incrementAndGet();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    var1_1 = OrderedThreadPoolExecutor.access$600(OrderedThreadPoolExecutor.this);
                    synchronized (var1_1) {
                        OrderedThreadPoolExecutor.access$600(OrderedThreadPoolExecutor.this).remove(this);
                        OrderedThreadPoolExecutor.access$1014(OrderedThreadPoolExecutor.this, this.completedTaskCount);
                        OrderedThreadPoolExecutor.access$600(OrderedThreadPoolExecutor.this).notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IoSession fetchSession() {
            IoSession session = null;
            long currentTime = System.currentTimeMillis();
            long deadline = currentTime + OrderedThreadPoolExecutor.this.getKeepAliveTime(TimeUnit.MILLISECONDS);
            while (true) {
                try {
                    long waitTime = deadline - currentTime;
                    if (waitTime <= 0L) break;
                    try {
                        session = (IoSession)OrderedThreadPoolExecutor.this.waitingSessions.poll(waitTime, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        if (session == null) {
                            currentTime = System.currentTimeMillis();
                        }
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTasks(SessionBuffer buf) {
            while (true) {
                Runnable task;
                Queue queue = buf.queue;
                synchronized (queue) {
                    task = (Runnable)buf.queue.poll();
                    if (task == null) {
                        buf.processingCompleted = true;
                        break;
                    }
                }
                OrderedThreadPoolExecutor.this.queueHandler.polled(OrderedThreadPoolExecutor.this, (IoEvent)task);
                this.runTask(task);
            }
        }

        private void runTask(Runnable task) {
            OrderedThreadPoolExecutor.this.beforeExecute(this.thread, task);
            boolean ran = false;
            try {
                task.run();
                ran = true;
                OrderedThreadPoolExecutor.this.afterExecute(task, null);
                ++this.completedTaskCount;
            }
            catch (RuntimeException e) {
                if (!ran) {
                    OrderedThreadPoolExecutor.this.afterExecute(task, e);
                }
                throw e;
            }
        }
    }

    private static class SessionBuffer {
        private final Queue<Runnable> queue = new CircularQueue<Runnable>();
        private boolean processingCompleted = true;

        private SessionBuffer() {
        }
    }
}

