/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.polling;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.service.AbstractIoAcceptor;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.core.session.AbstractIoSession;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.util.ExceptionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPollingIoAcceptor<T extends AbstractIoSession, H>
extends AbstractIoAcceptor {
    private final IoProcessor<T> processor;
    private final boolean createdProcessor;
    private final Object lock = new Object();
    private final Queue<AbstractIoAcceptor.AcceptorOperationFuture> registerQueue = new ConcurrentLinkedQueue<AbstractIoAcceptor.AcceptorOperationFuture>();
    private final Queue<AbstractIoAcceptor.AcceptorOperationFuture> cancelQueue = new ConcurrentLinkedQueue<AbstractIoAcceptor.AcceptorOperationFuture>();
    private final Map<SocketAddress, H> boundHandles = Collections.synchronizedMap(new HashMap());
    private final AbstractIoService.ServiceOperationFuture disposalFuture = new AbstractIoService.ServiceOperationFuture();
    private volatile boolean selectable;
    private Acceptor acceptor;

    protected AbstractPollingIoAcceptor(IoSessionConfig sessionConfig, Class<? extends IoProcessor<T>> processorClass) {
        this(sessionConfig, null, new SimpleIoProcessorPool(processorClass), true);
    }

    protected AbstractPollingIoAcceptor(IoSessionConfig sessionConfig, Class<? extends IoProcessor<T>> processorClass, int processorCount) {
        this(sessionConfig, null, new SimpleIoProcessorPool(processorClass, processorCount), true);
    }

    protected AbstractPollingIoAcceptor(IoSessionConfig sessionConfig, IoProcessor<T> processor) {
        this(sessionConfig, null, processor, false);
    }

    protected AbstractPollingIoAcceptor(IoSessionConfig sessionConfig, Executor executor, IoProcessor<T> processor) {
        this(sessionConfig, executor, processor, false);
    }

    private AbstractPollingIoAcceptor(IoSessionConfig sessionConfig, Executor executor, IoProcessor<T> processor, boolean createdProcessor) {
        super(sessionConfig, executor);
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        this.processor = processor;
        this.createdProcessor = createdProcessor;
        try {
            this.init();
            this.selectable = true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeIoException("Failed to initialize.", e);
        }
        finally {
            if (!this.selectable) {
                try {
                    this.destroy();
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    protected abstract void init() throws Exception;

    protected abstract void destroy() throws Exception;

    protected abstract int select() throws Exception;

    protected abstract void wakeup();

    protected abstract Iterator<H> selectedHandles();

    protected abstract H open(SocketAddress var1) throws Exception;

    protected abstract SocketAddress localAddress(H var1) throws Exception;

    protected abstract T accept(IoProcessor<T> var1, H var2) throws Exception;

    protected abstract void close(H var1) throws Exception;

    @Override
    protected IoFuture dispose0() throws Exception {
        this.unbind();
        if (!this.disposalFuture.isDone()) {
            this.startupAcceptor();
            this.wakeup();
        }
        return this.disposalFuture;
    }

    @Override
    protected final Set<SocketAddress> bind0(List<? extends SocketAddress> localAddresses) throws Exception {
        AbstractIoAcceptor.AcceptorOperationFuture request = new AbstractIoAcceptor.AcceptorOperationFuture(localAddresses);
        this.registerQueue.add(request);
        this.startupAcceptor();
        this.wakeup();
        request.awaitUninterruptibly();
        if (request.getException() != null) {
            throw request.getException();
        }
        HashSet<SocketAddress> newLocalAddresses = new HashSet<SocketAddress>();
        for (H handle : this.boundHandles.values()) {
            newLocalAddresses.add(this.localAddress(handle));
        }
        return newLocalAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupAcceptor() {
        if (!this.selectable) {
            this.registerQueue.clear();
            this.cancelQueue.clear();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.acceptor == null) {
                this.acceptor = new Acceptor();
                this.executeWorker(this.acceptor);
            }
        }
    }

    @Override
    protected final void unbind0(List<? extends SocketAddress> localAddresses) throws Exception {
        AbstractIoAcceptor.AcceptorOperationFuture future = new AbstractIoAcceptor.AcceptorOperationFuture(localAddresses);
        this.cancelQueue.add(future);
        this.startupAcceptor();
        this.wakeup();
        future.awaitUninterruptibly();
        if (future.getException() != null) {
            throw future.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerHandles() {
        AbstractIoAcceptor.AcceptorOperationFuture future;
        while ((future = this.registerQueue.poll()) != null) {
            HashMap<SocketAddress, H> newHandles = new HashMap<SocketAddress, H>();
            List<SocketAddress> localAddresses = future.getLocalAddresses();
            try {
                for (SocketAddress a : localAddresses) {
                    Object handle = this.open(a);
                    newHandles.put(this.localAddress(handle), handle);
                }
                this.boundHandles.putAll(newHandles);
                future.setDone();
                int i$ = newHandles.size();
                return i$;
            }
            catch (Exception e) {
                future.setException(e);
                continue;
            }
            finally {
                if (future.getException() == null) continue;
                for (SocketAddress handle : newHandles.values()) {
                    try {
                        this.close(handle);
                    }
                    catch (Exception e) {
                        ExceptionMonitor.getInstance().exceptionCaught(e);
                    }
                }
                this.wakeup();
                continue;
            }
            break;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unregisterHandles() {
        AbstractIoAcceptor.AcceptorOperationFuture future;
        int cancelledHandles = 0;
        while ((future = this.cancelQueue.poll()) != null) {
            for (SocketAddress a : future.getLocalAddresses()) {
                H handle = this.boundHandles.remove(a);
                if (handle == null) continue;
                try {
                    this.close(handle);
                    this.wakeup();
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    ++cancelledHandles;
                }
            }
            future.setDone();
        }
        return cancelledHandles;
    }

    @Override
    public final IoSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int nHandles = 0;
            while (AbstractPollingIoAcceptor.this.selectable) {
                try {
                    int selected = AbstractPollingIoAcceptor.this.select();
                    nHandles += AbstractPollingIoAcceptor.this.registerHandles();
                    if (selected > 0) {
                        this.processHandles(AbstractPollingIoAcceptor.this.selectedHandles());
                    }
                    if ((nHandles -= AbstractPollingIoAcceptor.this.unregisterHandles()) != 0) continue;
                    Object object = AbstractPollingIoAcceptor.this.lock;
                    synchronized (object) {
                        if (AbstractPollingIoAcceptor.this.registerQueue.isEmpty() && AbstractPollingIoAcceptor.this.cancelQueue.isEmpty()) {
                            AbstractPollingIoAcceptor.this.acceptor = null;
                            break;
                        }
                    }
                }
                catch (Throwable e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                }
            }
            if (!AbstractPollingIoAcceptor.this.selectable) return;
            if (!AbstractPollingIoAcceptor.this.isDisposing()) return;
            AbstractPollingIoAcceptor.this.selectable = false;
            try {
                if (!AbstractPollingIoAcceptor.this.createdProcessor) return;
                AbstractPollingIoAcceptor.this.processor.dispose();
                return;
            }
            finally {
                try {
                    Object e = AbstractPollingIoAcceptor.this.disposalLock;
                    synchronized (e) {
                        if (AbstractPollingIoAcceptor.this.isDisposing()) {
                            AbstractPollingIoAcceptor.this.destroy();
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                finally {
                    AbstractPollingIoAcceptor.this.disposalFuture.setDone();
                }
            }
        }

        private void processHandles(Iterator<H> handles) throws Exception {
            while (handles.hasNext()) {
                Object handle = handles.next();
                handles.remove();
                Object session = AbstractPollingIoAcceptor.this.accept(AbstractPollingIoAcceptor.this.processor, handle);
                if (session == null) break;
                AbstractPollingIoAcceptor.this.finishSessionInitialization(session, null, null);
                ((AbstractIoSession)session).getProcessor().add(session);
            }
        }
    }
}

