/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.swing;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Insets;
import oracle.bpm.log.Log;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.border.Border;
import oracle.bpm.xobject.runtime.swing.XObjectBorderFactory;

public class DottedBorder
extends Border
implements XObjectBorderFactory.MaskableBorder {
    protected Color dottedColor;
    protected int lineLength;
    protected boolean roundedCorners;
    protected int spaceLength;
    protected int thickness;
    private int shown = 15;
    private static Border blackDotted;
    private static Border grayDotted;
    private static Border darkGrayLine;
    private static Border blackLine;
    public static final int THICK_LINE_WIDTH = 3;
    public static final int LINE_WIDTH = 1;

    public DottedBorder(Color color) {
        this(color, 1, false);
    }

    public DottedBorder(Color color, int thickness) {
        this(color, thickness, false);
    }

    public DottedBorder(Color color, int thickness, boolean roundedCorners, int lineLength, int spaceLength) {
        super(null);
        this.dottedColor = color;
        this.thickness = thickness;
        this.roundedCorners = roundedCorners;
        this.lineLength = lineLength;
        this.spaceLength = spaceLength;
    }

    DottedBorder(Color color, int thickness, boolean roundedCorners) {
        this(color, thickness, roundedCorners, thickness, thickness / 2);
    }

    public static Border createBlackDottedBorder() {
        if (blackDotted == null) {
            blackDotted = new DottedBorder(Color.BLACK, 1);
        }
        return blackDotted;
    }

    public static Border createBlackThickLineBorder() {
        if (blackLine == null) {
            blackLine = new DottedBorder(Color.BLACK, 3, false, 6, 3);
        }
        return blackLine;
    }

    public static Border createDarkGrayLineBorder() {
        if (darkGrayLine == null) {
            darkGrayLine = new DottedBorder(Color.DARK_GRAY, 1, false, 4, 2);
        }
        return darkGrayLine;
    }

    public static DottedBorder createDashedBorder(Color color, int borderWidth) {
        return new DottedBorder(color, borderWidth, false, 2 * borderWidth, 2 * borderWidth);
    }

    public static Border createGrayDottedBorder() {
        if (grayDotted == null) {
            grayDotted = new DottedBorder(Color.GRAY, 1);
        }
        return grayDotted;
    }

    public static Border createThickLineBorder(Color color) {
        return new DottedBorder(color, 3, false, 6, 3);
    }

    public Insets getBorderInsets(UiComponent c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(UiComponent c, Insets insets) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public Color getDottedColor() {
        return this.dottedColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void paintBorder(UiComponent c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getForeground();
        g.setForeground(this.dottedColor);
        if (this.thickness > 0) {
            try {
                if (!this.roundedCorners) {
                    this.paintDashedBorder(width, g, x, y, height);
                } else {
                    this.paintDottedBorder(width, g, x, y, height);
                }
            }
            catch (ArithmeticException ae) {
                Log.logWarning(ae);
            }
        }
        g.setForeground(oldColor);
    }

    @Override
    public void show(int wich) {
        this.shown = wich;
    }

    private void paintDashedBorder(int width, Graphics g, int x, int y, int height) {
        boolean paintHorizontal = true;
        boolean paintVertical = true;
        double hSpace = 0.0;
        double vSpace = 0.0;
        int minSpace = this.spaceLength;
        int count = (width - this.lineLength) / (this.lineLength + minSpace);
        if (count == 0) {
            paintHorizontal = false;
        } else {
            hSpace = (double)(width - this.lineLength) / (double)count - (double)this.lineLength;
        }
        count = (height - this.lineLength) / (this.lineLength + minSpace);
        if (count == 0) {
            paintVertical = false;
        } else {
            vSpace = (double)(height - this.lineLength) / (double)count - (double)this.lineLength;
        }
        if (paintHorizontal) {
            for (double i = 0.0; i <= (double)(width - this.thickness); i += hSpace + (double)this.lineLength) {
                if ((this.shown & 1) != 0) {
                    g.fillRect((int)((double)x + i), y, this.lineLength, this.thickness);
                }
                if ((this.shown & 2) == 0) continue;
                g.fillRect((int)((double)x + i), y + height - this.thickness, this.lineLength, this.thickness);
            }
        }
        if (paintVertical) {
            for (double j = 0.0; j < (double)height; j += vSpace + (double)this.lineLength) {
                if ((this.shown & 4) != 0) {
                    g.fillRect(x, (int)((double)y + j), this.thickness, this.lineLength);
                }
                if ((this.shown & 8) == 0) continue;
                g.fillRect(x + width - this.thickness, (int)((double)y + j), this.thickness, this.lineLength);
            }
        }
    }

    private void paintDottedBorder(int width, Graphics g, int x, int y, int height) {
        boolean paintHorizontal = true;
        boolean paintVertical = true;
        double hSpace = 0.0;
        double vSpace = 0.0;
        int minSpace = this.thickness / 2;
        int count = (width - this.thickness) / (this.thickness + minSpace);
        if (count == 0) {
            paintHorizontal = false;
        } else {
            hSpace = (double)(width - this.thickness) / (double)count - (double)this.thickness;
        }
        count = (height - this.thickness) / (this.thickness + minSpace);
        if (count == 0) {
            paintVertical = false;
        } else {
            vSpace = (double)(height - this.thickness) / (double)count - (double)this.thickness;
        }
        if (paintHorizontal && paintVertical) {
            for (double i = 0.0; i <= (double)(width - this.thickness); i += hSpace + (double)this.thickness) {
                if ((this.shown & 1) != 0) {
                    g.fillOval((int)((double)x + i), y, this.thickness, this.thickness);
                }
                if ((this.shown & 2) == 0) continue;
                g.fillOval((int)((double)x + i), y + height - this.thickness, this.thickness, this.thickness);
            }
            for (double j = 0.0; j < (double)height; j += vSpace + (double)this.thickness) {
                if ((this.shown & 4) != 0) {
                    g.fillOval(x, (int)((double)y + j), this.thickness, this.thickness);
                }
                if ((this.shown & 8) == 0) continue;
                g.fillOval(x + width - this.thickness, (int)((double)y + j), this.thickness, this.thickness);
            }
        }
    }
}

