/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution.impl;

import fuego.papi.OperationException;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.bpm.log.Log;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExecutionManagerFactory;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.InteractiveExecution;
import oracle.bpm.web.execution.authentication.RuntimePrincipal;
import oracle.bpm.web.execution.exception.ExecutionRuntimeException;
import oracle.bpm.web.execution.exception.InteractiveComponentNotSupportedException;
import oracle.bpm.web.execution.exception.InternalForwardException;
import oracle.bpm.web.execution.impl.WebExecutionIdentifier;
import oracle.bpm.web.execution.impl.WebExecutionManager;
import oracle.bpm.web.execution.servlet.ServletExternalContext;
import oracle.bpm.webexecution.msg.WebExecutionMsg;

public final class WebUtils {
    private static final ThreadLocal<ProcessServiceSession> currentPapiSession = new ThreadLocal();

    private WebUtils() {
    }

    public static void setCurrentPapiSession(ProcessServiceSession session) {
        currentPapiSession.set(session);
    }

    public static ProcessServiceSession getCurrentPapiSession() {
        return currentPapiSession.get();
    }

    public static String getFooterPage() {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return manager.getFooterPage();
    }

    public static String getHeaderPage() {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return manager.getHeaderPage();
    }

    public static String urlForStaticImage(String component, String image, ExternalContext externalContext) throws InteractiveComponentNotSupportedException {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        String imageUrl = manager.findImageUrl(component, image, externalContext);
        if (imageUrl == null) {
            Log.logDebug((String)("Could not load the image '" + image + "' from the component " + component));
        }
        return imageUrl;
    }

    public static String getStyleSheet(ExternalContext context) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return "../css/" + manager.getStyleSheet(context);
    }

    public static String getHelpUrl(ExternalContext context, String component, String helpKey) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return manager.getHelpUrl(context, component, helpKey);
    }

    public static String getTitle(ExternalContext context) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return manager.getTitle(context);
    }

    public static String getJSPIncludeURL(String component, String jsp) throws InteractiveComponentNotSupportedException {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        String jspIncludeUrl = manager.findJSPIncludeUrl(component, jsp);
        assert (jspIncludeUrl != null) : "Could not load the jsp '" + jsp + "' from the component " + component;
        return jspIncludeUrl;
    }

    public static ComponentContext findComponentContext(ExternalContext context) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        ExecutionIdentifier execId = manager.retrieveExecutionIdentifier(context);
        InteractiveExecution webExecution = manager.find(execId, context);
        return webExecution.componentContext(execId);
    }

    public static ExecutionIdentifier findExecutionIdentifier(ExternalContext context) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return manager.retrieveExecutionIdentifier(context);
    }

    public static WebExecutionManager getWebExecutionManager() {
        return (WebExecutionManager)ExecutionManagerFactory.getDefault();
    }

    public static String urlForAction(String component, String action, ExternalContext context) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return manager.urlForPostAction(component, action, context);
    }

    public static String urlForDynamicImage(String component, String action, ExternalContext context) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        if (!(context instanceof ServletExternalContext)) {
            component = component + ".DynamicImageRender";
        }
        return manager.urlForPostAction(component, action, context);
    }

    public static ExternalContext createExternalContext(HttpServletRequest request, HttpServletResponse response) {
        WebExecutionManager manager = WebUtils.getWebExecutionManager();
        return manager.createExternalContext(request, response);
    }

    public static String getCustomJspURLFolder(ExternalContext context, ComponentContext ctx) {
        try {
            RuntimePrincipal principal = WebUtils.getWebPrincipal(context);
            ProcessServiceSession papiSession = principal.getProcessServiceSession();
            Process process = papiSession.processGet(ctx.getProcessId());
            return principal.getProcessServiceSession().getProcessService().getCustomJspURLFolder(process);
        }
        catch (OperationException e) {
            throw new ExecutionRuntimeException(WebExecutionMsg.CUSTOM_JSP_URL_ERROR, e);
        }
    }

    public static String getWebResourcesURLFolder(ExternalContext context, ComponentContext ctx) {
        RuntimePrincipal principal = WebUtils.getWebPrincipal(context);
        if (principal == null) {
            return null;
        }
        ProcessServiceSession papiSession = principal.getProcessServiceSession();
        try {
            Process process = papiSession.processGet(ctx.getProcessId());
            return principal.getProcessServiceSession().getProcessService().getWebResourcesURLFolder(process);
        }
        catch (OperationException e) {
            throw new ExecutionRuntimeException(WebExecutionMsg.WEB_RESOURCE_URL_ERROR, e);
        }
    }

    public static String prepareUrlForPostAction(String url, ExternalContext context) {
        try {
            WebExecutionManager manager = WebUtils.getWebExecutionManager();
            WebExecutionIdentifier execId = (WebExecutionIdentifier)manager.retrieveExecutionIdentifier(context);
            url = execId.addExecutionParameters(url);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalForwardException(e);
        }
        return url;
    }

    private static RuntimePrincipal getWebPrincipal(ExternalContext context) {
        return (RuntimePrincipal)context.getSession(true).getAttribute("fuego.web.principal");
    }
}

