/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution;

import fuego.papi.Execution;
import java.util.Map;
import oracle.bpm.log.Log;
import oracle.bpm.web.execution.ComponentContext;
import oracle.bpm.web.execution.InteractiveInvocation;
import oracle.bpm.web.execution.InvocationContext;

public abstract class ExecutionData
implements ComponentContext {
    private boolean aborted = false;
    private final Execution execution;
    private String executionUUID;
    private boolean externalExecution = false;
    private boolean finished = false;
    private int head;
    private String id;
    private InteractiveInvocation[] invocations;
    private InteractiveInvocation pending;
    private int stackCount;
    private int tail;
    private static final int MAX_BACK_STACK;

    protected ExecutionData(String id, Execution execution) {
        if (execution == null) {
            throw new IllegalArgumentException("Execution cannot be null");
        }
        this.execution = execution;
        this.id = id;
        this.invocations = new InteractiveInvocation[MAX_BACK_STACK + 1];
    }

    public boolean isExternalExecution() {
        return this.externalExecution;
    }

    public void setExternalExecution(boolean externalExecution) {
        this.externalExecution = externalExecution;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.pending.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.pending.getAttribute(name);
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setExecutionUUID(String executionUUID) {
        this.executionUUID = executionUUID;
    }

    public String getExecutionUUID() {
        return this.executionUUID;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getId() {
        return this.id;
    }

    public InvocationContext getInvocationContext() {
        return this.pending;
    }

    public InteractiveInvocation getPending() {
        return this.pending;
    }

    public int backSize() {
        return this.stackCount;
    }

    @Override
    public Object removeAttribute(String name) {
        return this.pending.removeAttribute(name);
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.pending.getAttributeMap();
    }

    @Override
    public void beforeService() {
        this.getExecution().beforeService();
    }

    protected void setId(String itemKey) {
        this.id = itemKey;
    }

    void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    boolean isAborted() {
        return this.aborted;
    }

    void setCurrentInvocation(int index) {
        assert (index <= this.stackCount) : "index is out of bounds - index: " + index + ", stackCount: " + this.stackCount;
        if (index < this.stackCount) {
            int inQ;
            if (Log.isDebugging()) {
                Log.logDebug((String)"InteractiveExecutionStatus.setCurrentInvocation->refresh pending");
            }
            int backing = this.stackCount - index;
            int n = inQ = this.tail <= this.head ? this.head - this.tail : this.head + (this.invocations.length - this.tail);
            if (backing > inQ) {
                throw new IllegalStateException("back stack limit exceeded");
            }
            int absOff = index % this.invocations.length;
            this.pending = this.invocations[absOff];
        }
    }

    void setFinished(boolean finished) {
        this.finished = finished;
    }

    void setPending(InteractiveInvocation pending) {
        if (Log.isDebugging()) {
            Log.logDebug((String)"ExecutionData.setPending()");
        }
        this.pending = pending;
    }

    InteractiveInvocation pop() {
        if (this.head == this.tail) {
            throw new IllegalStateException("invocation queue is empty");
        }
        --this.stackCount;
        this.head = (this.head + this.invocations.length - 1) % this.invocations.length;
        InteractiveInvocation result = this.invocations[this.head];
        this.invocations[this.head] = null;
        return result;
    }

    void push(InteractiveInvocation invocation) {
        if (Log.isDebugging()) {
            Log.logDebug((String)"InteractiveExecutionStatus.push()");
        }
        this.pending = invocation;
        if (this.tail == 0 && this.head == this.invocations.length - 1 || this.tail != 0 && this.head == this.tail - 1) {
            this.invocations[this.tail] = null;
            this.tail = (this.tail + 1) % this.invocations.length;
        }
        this.invocations[this.head] = invocation;
        this.head = (this.head + 1) % this.invocations.length;
        ++this.stackCount;
    }

    static {
        int maxBackStack = Integer.getInteger("fuego.portal.wapi.maxBackStack", 100);
        if (maxBackStack < 5) {
            maxBackStack = 5;
        } else if (maxBackStack > 65536) {
            maxBackStack = 65536;
        }
        MAX_BACK_STACK = maxBackStack;
    }
}

