/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.web.execution;

import fuego.papi.Execution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.web.execution.DefaultExecutionData;
import oracle.bpm.web.execution.ExecutionData;
import oracle.bpm.web.execution.ExecutionIdentifier;
import oracle.bpm.web.execution.ExternalContext;
import oracle.bpm.web.execution.InteractiveExecution;
import oracle.bpm.web.execution.InteractiveExecutionManager;
import oracle.bpm.web.execution.Session;

public abstract class DefaultExecutionManager
implements InteractiveExecutionManager {
    private static final String EXEC_DATA_TABLE = "oracle.bpm.execution.execDataTable";

    @Override
    public InteractiveExecution createExecution(ExecutionIdentifier execId, Execution execution, ExternalContext externalContext) {
        ExecutionMap currentExecutions = DefaultExecutionManager.getCurrentExecutions(externalContext);
        ExecutionData execData = currentExecutions.get(execId);
        if (execData != null) {
            throw new IllegalStateException("This execution is already in process " + execId.toString());
        }
        execData = this.createExecutionData(execId, execution);
        execData.setExecutionUUID(execId.getExecutionUUID());
        currentExecutions.put(execId, execData);
        InteractiveExecution interactiveExecution = this.createInteractiveExecution(externalContext, execData);
        interactiveExecution.initialize(execId, externalContext);
        return interactiveExecution;
    }

    @Override
    public InteractiveExecution find(ExecutionIdentifier execId, ExternalContext externalContext) {
        ExecutionMap currentExecutions = DefaultExecutionManager.getCurrentExecutions(externalContext);
        ExecutionData execData = currentExecutions.get(execId);
        if (execData == null) {
            return null;
        }
        InteractiveExecution interactiveExecution = this.createInteractiveExecution(externalContext, execData);
        interactiveExecution.initialize(execId, externalContext);
        return interactiveExecution;
    }

    @Override
    public InteractiveExecution[] findAll(ExternalContext externalContext) {
        ArrayList<InteractiveExecution> list = new ArrayList<InteractiveExecution>();
        ExecutionMap currentExecutions = DefaultExecutionManager.getCurrentExecutions(externalContext);
        Collection<ExecutionData> execIdentifierSet = currentExecutions.getValues();
        for (ExecutionData executionData : execIdentifierSet) {
            InteractiveExecution execution = this.createInteractiveExecution(externalContext, executionData);
            ExecutionIdentifier execId = execution.buildExecutionIdentifier();
            execution.initialize(execId, externalContext);
            list.add(execution);
        }
        return list.toArray(new InteractiveExecution[0]);
    }

    @Override
    public void remove(ExecutionIdentifier execId, ExternalContext externalContext) {
        ExecutionMap currentExecutions = DefaultExecutionManager.getCurrentExecutions(externalContext);
        currentExecutions.remove(execId);
    }

    public void remove(InteractiveExecution execution, ExternalContext extContext) {
        ExecutionMap currentExecutions = DefaultExecutionManager.getCurrentExecutions(extContext);
        currentExecutions.remove(execution.getExecutionData());
    }

    public InteractiveExecution find(String executionUUID, ExternalContext context) {
        assert (executionUUID != null) : "executionUUID can not be null";
        ExecutionMap currentExecutions = DefaultExecutionManager.getCurrentExecutions(context);
        Collection<ExecutionData> execIdentifierSet = currentExecutions.getValues();
        InteractiveExecution intExec = null;
        for (ExecutionData anExecIdentifierSet : execIdentifierSet) {
            DefaultExecutionData executionData = (DefaultExecutionData)anExecIdentifierSet;
            if (!executionUUID.equals(executionData.getExecutionUUID())) continue;
            intExec = this.createInteractiveExecution(context, executionData);
            ExecutionIdentifier execId = intExec.buildExecutionIdentifier();
            intExec.initialize(execId, context);
        }
        return intExec;
    }

    protected abstract ExecutionData createExecutionData(ExecutionIdentifier var1, Execution var2);

    protected abstract InteractiveExecution createInteractiveExecution(ExternalContext var1, ExecutionData var2);

    protected static ExecutionMap getCurrentExecutions(ExternalContext externalContext) {
        Session session = externalContext.getSession(true);
        ExecutionMap executionMap = (ExecutionMap)session.getAttribute(EXEC_DATA_TABLE);
        if (executionMap == null) {
            executionMap = new ExecutionMap();
            session.setAttribute(EXEC_DATA_TABLE, executionMap);
        }
        return executionMap;
    }

    public static class ExecutionMap {
        final Map<Integer, ExecutionData> table = Collections.synchronizedMap(new HashMap());

        ExecutionMap() {
        }

        public Collection<ExecutionData> getValues() {
            return this.table.values();
        }

        public ExecutionData get(ExecutionIdentifier execId) {
            return this.table.get(execId.getTaskKey());
        }

        public void put(ExecutionIdentifier execId, ExecutionData data) {
            this.table.put(execId.getTaskKey(), data);
        }

        public void remove(ExecutionIdentifier execId) {
            this.table.remove(execId.getTaskKey());
        }

        public void remove(ExecutionData execData) {
            this.table.remove(new Integer(execData.getId()));
        }
    }
}

