/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement.util;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.analytics.measurement.util.BIMetric;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.integration.platform.blocks.deploy.monitorexp.ComponentTypeEnum;
import oracle.integration.platform.blocks.deploy.monitorexp.IBIDimension;
import oracle.integration.platform.blocks.deploy.monitorexp.IBIMetric;
import oracle.integration.platform.blocks.deploy.monitorexp.IComponentBAMDeploymentInfo;
import oracle.integration.platform.blocks.deploy.monitorexp.MetricTypeEnum;

public class ComponentBAMDeploymentInfo
implements IComponentBAMDeploymentInfo {
    final String logClassName = "oracle.bpm.analytics.measurement.util.ComponentBAMDeploymentInfo";
    List<IBIDimension> m_biDimensions = new ArrayList<IBIDimension>();
    List<IBIMetric> m_biMetrics = new ArrayList<IBIMetric>();
    String m_componentName = null;
    boolean m_isEnabled;

    public ComponentBAMDeploymentInfo(String componentName, boolean isEnabled, IAuditVariableMetadata auditVariableMetadata) {
        String type;
        BIMetric biMetric;
        this.m_componentName = componentName;
        this.m_isEnabled = isEnabled;
        if (auditVariableMetadata == null) {
            return;
        }
        List stringNames = auditVariableMetadata.getStringNames();
        for (String name : stringNames) {
            if (name == null || name.startsWith("#")) continue;
            List ranges = auditVariableMetadata.getRanges(name);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)"oracle.bpm.analytics.measurement.util.ComponentBAMDeploymentInfo", (String)"deployBAMDataObjects()", (String)(auditVariableMetadata.getStringType(auditVariableMetadata.getSlot(name)) + " string " + name + (ranges == null || ranges.size() == 0 ? " has no ranges" : "has ranges")));
            String dataType = auditVariableMetadata.getStringModelType(auditVariableMetadata.getSlot(name));
            BIMetric biMetric2 = new BIMetric(name, this.mapToBAMType(dataType), ranges != null && ranges.size() != 0);
            String type2 = auditVariableMetadata.getStringType(auditVariableMetadata.getSlot(name)).toUpperCase();
            if ("D".equals(type2) || "A".equals(type2)) {
                this.m_biDimensions.add(biMetric2);
                continue;
            }
            if (!"M".equals(type2)) continue;
            this.m_biMetrics.add(biMetric2);
        }
        List numberNames = auditVariableMetadata.getNumberNames();
        for (String name : numberNames) {
            if (name == null || name.startsWith("#")) continue;
            List ranges = auditVariableMetadata.getRanges(name);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)"oracle.bpm.analytics.measurement.util.ComponentBAMDeploymentInfo", (String)"deployBAMDataObjects()", (String)(auditVariableMetadata.getNumberType(auditVariableMetadata.getSlot(name)) + " number " + name + (ranges == null || ranges.size() == 0 ? " has no ranges" : "has ranges")));
            String dataType = auditVariableMetadata.getNumberModelType(auditVariableMetadata.getSlot(name));
            biMetric = new BIMetric(name, this.mapToBAMType(dataType), ranges != null && ranges.size() != 0);
            type = auditVariableMetadata.getNumberType(auditVariableMetadata.getSlot(name)).toUpperCase();
            if ("D".equals(type) || "A".equals(type)) {
                this.m_biDimensions.add(biMetric);
                continue;
            }
            if (!"M".equals(type)) continue;
            this.m_biMetrics.add(biMetric);
        }
        List dateNames = auditVariableMetadata.getDateNames();
        for (String name : dateNames) {
            if (name == null || name.startsWith("#")) continue;
            List ranges = auditVariableMetadata.getRanges(name);
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)"oracle.bpm.analytics.measurement.util.ComponentBAMDeploymentInfo", (String)"deployBAMDataObjects()", (String)(auditVariableMetadata.getDateType(auditVariableMetadata.getSlot(name)) + " number " + name + (ranges == null || ranges.size() == 0 ? " has no ranges" : "has ranges")));
            biMetric = new BIMetric(name, MetricTypeEnum.TYPE_DATE_TIME, ranges != null && ranges.size() != 0);
            type = auditVariableMetadata.getDateType(auditVariableMetadata.getSlot(name)).toUpperCase();
            if ("D".equals(type) || "A".equals(type)) {
                this.m_biDimensions.add(biMetric);
                continue;
            }
            if (!"M".equals(type)) continue;
            this.m_biMetrics.add(biMetric);
        }
    }

    public ComponentTypeEnum getComponentType() {
        return ComponentTypeEnum.BPM;
    }

    public String getComponentName() {
        return this.m_componentName;
    }

    public List<IBIMetric> getBIMetrics() {
        return this.m_biMetrics;
    }

    public List<IBIDimension> getBIDimensions() {
        return this.m_biDimensions;
    }

    public boolean isEnabled() {
        return this.m_isEnabled;
    }

    private MetricTypeEnum mapToBAMType(String dataType) {
        if ("Int".equals(dataType)) {
            return MetricTypeEnum.TYPE_INTEGER;
        }
        if ("Decimal".equals(dataType)) {
            return MetricTypeEnum.TYPE_DECIMAL;
        }
        if ("Real".equals(dataType)) {
            return MetricTypeEnum.TYPE_DOUBLE;
        }
        if ("Bool".equals(dataType)) {
            return MetricTypeEnum.TYPE_BOOLEAN;
        }
        if ("String".equals(dataType)) {
            return MetricTypeEnum.TYPE_STRING;
        }
        if ("Time".equals(dataType)) {
            return MetricTypeEnum.TYPE_DATE_TIME;
        }
        return MetricTypeEnum.TYPE_STRING;
    }
}

