/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement.metadata.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.naming.NameNotFoundException;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import oracle.bpm.analytics.measurement.IElementContext;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.MeasurementCacheInitializationException;
import oracle.bpm.analytics.measurement.MeasurementUtil;
import oracle.bpm.analytics.measurement.impl.Measure;
import oracle.bpm.analytics.measurement.impl.MeasurementPublisher;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataService;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceLocal;
import oracle.bpm.analytics.measurement.metadata.IMeasurementMetadataServiceRemote;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementActionCacheElement;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementCacheElement;
import oracle.bpm.analytics.measurement.metadata.impl.MeasurementMetadataCache;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.analytics.measurement.metadata.model.TProperties;
import oracle.bpm.analytics.measurement.metadata.model.TPropertyType;
import oracle.bpm.analytics.measurement.util.CompositeBAMDeploymentInfo;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.exception.BPMExceptionContext;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IAuditVariableMetadata;
import oracle.bpm.services.instancequery.impl.AuditInstance;
import oracle.fabric.MonitorExpDeployUtil;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.CompositeModel;
import oracle.integration.platform.blocks.deploy.monitorexp.IBAMConnectionInfo;
import oracle.integration.platform.blocks.deploy.monitorexp.ICompositeBAMDeploymentInfo;
import oracle.integration.platform.blocks.deploy.monitorexp.impl.bpm.BPMDeployer;
import oracle.integration.platform.blocks.deploy.monitorexp.impl.common.BAMConnectionInfo;

@Stateless(name="MeasurementMetadataService", mappedName="BPMAnalytics")
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class MeasurementMetadataService
implements IMeasurementMetadataService,
IMeasurementMetadataServiceLocal,
IMeasurementMetadataServiceRemote {
    private List<TAction> actionList = null;
    private static final String logClassName = MeasurementMetadataService.class.getName();

    public MeasurementMetadataService() {
        MeasurementMetadataCache metadataCache = null;
        String logMethodName = "MeasurementMetadataService Constructor ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"MeasurementMetadataService Constructor ", (String)"BEGIN:");
        try {
            metadataCache = MeasurementMetadataCache.getCacheInstance();
        }
        catch (MeasurementCacheInitializationException ex) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "MeasurementMetadataService Constructor ");
            exCtx.setErrorCode(50101);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)ex);
            BPMException exBpm = new BPMException(exCtx);
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "MeasurementMetadataService Constructor ");
            exCtx.setErrorCode(50101);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            BPMException exBpm = new BPMException(exCtx);
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"MeasurementMetadataService Constructor ", (String)"END:");
    }

    @Override
    public IMeasure isElementRegistered(IAuditInstance auditInstance) {
        String logMethodName = "isElementRegisteredAI";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredAI", (String)"BEGIN:");
        IMeasure measure = null;
        IElementContext ctx = MeasurementUtil.getElementContext(auditInstance);
        measure = this.isElementRegistered(ctx);
        if (measure == null) {
            measure = new Measure();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredAI", (String)"END:");
        return measure;
    }

    @Override
    public IMeasure isElementRegistered(IElementContext context) {
        String logMethodName = "isElementRegisteredEC";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)"BEGIN:");
        Measure measure = new Measure();
        boolean measurementEnable = false;
        this.actionList = new ArrayList<TAction>();
        try {
            List<MeasurementCacheElement> measurement;
            if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)this.getContextInformation(context).toString());
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)MeasurementMetadataCache.getCacheInstance().printCacheData().toString());
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)MeasurementMetadataCache.getCacheInstance().printActionCacheData().toString());
            }
            boolean checkProcessLevel = true;
            boolean checkCompositeLevel = true;
            boolean checkActivityLevel = true;
            if (AuditInstanceOperation.MEASUREMENT_COUNTER.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.MEASUREMENT_START_STOP.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.MEASUREMENT_START.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.MEASUREMENT_STOP.toString().equalsIgnoreCase(context.getElementState())) {
                checkActivityLevel = false;
                checkProcessLevel = false;
            }
            if (!measurementEnable && checkActivityLevel && context.getElementId() != null && context.getElementId().trim().length() != 0) {
                measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim() + context.getComponentName().trim() + context.getElementId().trim());
                if (measurement != null) {
                    checkProcessLevel = false;
                    checkCompositeLevel = false;
                }
                measurementEnable = this.getMeasurementEnabled(measurement, context.getCompositeDN(), context.getElementName(), context.getElementType(), context.getElementState(), true);
            }
            if (!measurementEnable && checkProcessLevel) {
                measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim() + context.getComponentName().trim());
                if (measurement != null) {
                    checkCompositeLevel = false;
                }
                measurementEnable = this.getMeasurementEnabled(measurement, context.getCompositeDN(), context.getElementName(), context.getElementType(), context.getElementState(), false);
            }
            if (!measurementEnable && checkCompositeLevel) {
                measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim());
                measurementEnable = this.getMeasurementEnabled(measurement, context.getCompositeDN(), context.getElementName(), context.getElementType(), context.getElementState(), false);
            }
            if ((!measurementEnable || measurementEnable && this.actionList.size() <= 0) && (AuditInstanceOperation.INSTANCE_ABORTED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_CREATED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_TERMINATED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_FAULT.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.STALE_COMPLETED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_SUSPENDED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_RESUMED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.INSTANCE_UPDATED.toString().equalsIgnoreCase(context.getElementState()) || AuditInstanceOperation.FLOW_NODE_MOVED.toString().equalsIgnoreCase(context.getElementState())) && (measurement = MeasurementMetadataCache.getCacheInstance().getMeasurement(context.getCompositeDN().trim() + context.getComponentName().trim() + "_DUMMY_TEMP_ACTIVITY_")) != null && measurement.size() > 0) {
                measurementEnable = true;
                for (MeasurementCacheElement cacheData : measurement) {
                    this.updateCacheList(context.getCompositeDN(), cacheData);
                }
            }
        }
        catch (MeasurementCacheInitializationException ex) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "isElementRegisteredEC");
            exCtx.setErrorCode(50100);
            exCtx.setSeverity(Severity.ERRORS);
            BPMException exBpm = new BPMException(exCtx);
        }
        catch (Exception e) {
            BPMExceptionContext exCtx = new BPMExceptionContext(LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, logClassName, "isElementRegisteredEC");
            exCtx.setErrorCode(50103);
            exCtx.setSeverity(Severity.ERRORS);
            exCtx.setThrowable((Throwable)e);
            BPMException exBpm = new BPMException(exCtx);
        }
        measure.setMeasurementEnabled(measurementEnable);
        ArrayList<TAction> tempActionList = new ArrayList<TAction>();
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)("ActionList size before clearing the data 1)" + this.actionList.size() + " 2)" + tempActionList.size()));
        if (this.actionList.size() <= 0) {
            measure.setMeasurementEnabled(false);
        } else {
            for (TAction action : this.actionList) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)("Measurement Action==>" + action.getName()));
                tempActionList.add(action);
            }
        }
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)("ActionList size after clearing the data 1)" + this.actionList.size() + " 2)" + tempActionList.size()));
        }
        measure.setActions(tempActionList);
        if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
            StringBuffer strBuffer = new StringBuffer("\n");
            strBuffer.append("****************** RESULT FOR IS ELEMENT REGISTER CALL  ********************");
            strBuffer.append("\n");
            strBuffer.append("Result : " + measure.isMeasurementEnabled());
            strBuffer.append("\n");
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)strBuffer.toString());
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"isElementRegisteredEC", (String)"End:");
        }
        return measure;
    }

    @Override
    public HashMap<IElementContext, IMeasure> areElementsRegistered(List<IElementContext> mContextList) {
        HashMap<IElementContext, IMeasure> measureMap = new HashMap<IElementContext, IMeasure>();
        for (IElementContext context : mContextList) {
            IMeasure measure = this.isElementRegistered(context);
            measureMap.put(context, measure);
        }
        return measureMap;
    }

    @Override
    public TAction getAction(IElementContext ctx, String actionName) {
        TAction action = null;
        String logMethodName = "getAction ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)"BEGIN:");
        ArrayList<MeasurementCacheElement> measurementList = new ArrayList<MeasurementCacheElement>();
        try {
            List<MeasurementCacheElement> componentMeasurementList;
            List<MeasurementCacheElement> compositeMeasurementList = MeasurementMetadataCache.getCacheInstance().getMeasurement(ctx.getCompositeDN());
            if (compositeMeasurementList != null && compositeMeasurementList.size() > 0) {
                measurementList.addAll(compositeMeasurementList);
            }
            if ((componentMeasurementList = MeasurementMetadataCache.getCacheInstance().getMeasurement(ctx.getCompositeDN() + ctx.getComponentName())) != null && componentMeasurementList.size() > 0) {
                measurementList.addAll(componentMeasurementList);
            }
            if (measurementList.size() > 0) {
                for (MeasurementCacheElement mCacheData : measurementList) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)("Action key is:" + ctx.getCompositeDN() + mCacheData.getMeasurementElementName()));
                    List<MeasurementActionCacheElement> elemList = MeasurementMetadataCache.getCacheInstance().getAction(ctx.getCompositeDN() + mCacheData.getMeasurementElementName());
                    if (elemList != null) {
                        for (MeasurementActionCacheElement element : elemList) {
                            if (!element.getActionName().equals(actionName)) continue;
                            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)"Action exist for above key");
                            return element.getAction();
                        }
                        return action;
                    }
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)("Action does not exist for Key ===>" + ctx.getCompositeDN() + mCacheData.getMeasurementElementName() + actionName));
                }
            }
        }
        catch (MeasurementCacheInitializationException ex) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)logClassName, (String)"getAction ", (String)("Cache instance creation exception:" + ex.getMessage()));
        }
        catch (Exception e) {
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.ERRORS, (String)logClassName, (String)"getAction ", (String)("Exception in constructor: " + e.getMessage()));
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getAction ", (String)"END:");
        return action;
    }

    @Override
    public void load(ComponentModel componentModel) {
        String logMethodName = "load ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"load ", (String)"BEGIN:");
        try {
            MeasurementMetadataCache.getCacheInstance().addToCache(componentModel);
        }
        catch (MeasurementCacheInitializationException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"load ", (String)"END:");
    }

    @Override
    public void unload(ComponentModel componentModel) {
        String logMethodName = "unload ";
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"unload ", (String)"BEGIN: unload");
        try {
            MeasurementMetadataCache.getCacheInstance().removeFromCache(componentModel);
        }
        catch (MeasurementCacheInitializationException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"unload ", (String)"END:");
    }

    @Override
    public void deployBAMDataObjects(ComponentModel componentModel, IAuditVariableMetadata auditVariableMetadata) {
        block20: {
            String logMethodName = "deployBAMDataObjects ";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"deployBAMDataObjects ", (String)"BEGIN: deployBAMDataObjects");
            this.load(componentModel);
            CompositeModel composite = componentModel.getComposite();
            String dn = composite.getDN();
            String[] elems = composite.getDN().split("\\/");
            String partitionName = elems[0].trim();
            IElementContext elementContext = MeasurementUtil.getElementContext(composite.getDN(), componentModel.getName(), null, null, null, null);
            TAction action = this.getAction(elementContext, "BAMCommand");
            if (action == null || !action.isEnabled()) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"deployBAMDataObjects ", (String)"BAMCommand not enabled.  Skipping BAM Data Object deployment.");
                return;
            }
            TProperties props = action.getProperties();
            String jndiName = null;
            String dataObjectPath = null;
            String deploymentProtocol = "http";
            if (props != null) {
                List<TPropertyType> propList = props.getProperty();
                StringBuilder propertiesDebug = new StringBuilder();
                for (TPropertyType prop : propList) {
                    propertiesDebug.append(prop.getName()).append(" = ").append(prop.getValue()).append("\n");
                    if ("BAMAdapterJNDIName".equals(prop.getName()) && prop.getValue() != null && prop.getValue().length() > 0) {
                        jndiName = prop.getValue();
                    }
                    if ("DataObjectPath".equals(prop.getName()) && prop.getValue() != null && prop.getValue().length() > 0) {
                        dataObjectPath = prop.getValue();
                    }
                    if (!"BAMDeploymentUseHTTPS".equals(prop.getName()) || prop.getValue() == null || prop.getValue().length() <= 0 || !"TRUE".equals(prop.getValue().toUpperCase())) continue;
                    deploymentProtocol = "https";
                }
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"deployBAMDataObjects()", (String)("BAMAdapterJNDIName=" + jndiName + ", DataObjectPath=" + dataObjectPath + ", deploymentProtocol=" + deploymentProtocol));
                }
            } else {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING, (String)logClassName, (String)"deployBAMDataObjects()", (String)"MeasurementMetaDataService returned null properties.  Cannot deploy Data Objects to BAM.");
                }
                return;
            }
            try {
                CompositeBAMDeploymentInfo compositeBAMDeploymentInfo = new CompositeBAMDeploymentInfo(deploymentProtocol, jndiName, dataObjectPath, partitionName, composite.getName(), componentModel.getName(), false, true, auditVariableMetadata);
                BAMConnectionInfo connection = MonitorExpDeployUtil.getConnectionInfo((ICompositeBAMDeploymentInfo)compositeBAMDeploymentInfo);
                BPMDeployer deployer = new BPMDeployer((ICompositeBAMDeploymentInfo)compositeBAMDeploymentInfo, (IBAMConnectionInfo)connection);
                deployer.deploy();
            }
            catch (NameNotFoundException nnfe) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"deployBAMDataObjects()", (Throwable)nnfe);
                }
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING, (String)logClassName, (String)"deployBAMDataObjects()", (String)"Error in BAM Data Object deployment. Please make sure that OracleBamAdapter was installed in the server and verify the settings of outbound connection properties");
                }
            }
            catch (WebServiceException wse) {
                Throwable th;
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"deployBAMDataObjects()", (Throwable)wse);
                }
                if ((th = wse.getCause()) != null && th instanceof SOAPException) {
                    SOAPException se = (SOAPException)th;
                    Throwable rootCause = se.getCause();
                    if (rootCause != null && rootCause instanceof SOAPException && rootCause.getMessage() != null && rootCause.getMessage().indexOf("404") >= 0 && BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING)) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING, (String)logClassName, (String)"deployBAMDataObjects()", (String)"Error in BAM Data Object deployment.  Connection made. But the valid url was not found.  Please examine the host name, user name and password in the outbound connection properties.");
                    }
                } else if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING, (String)logClassName, (String)"deployBAMDataObjects()", (String)"Error in BAM Data Object deployment.Please examine the BAM server host name and port number in the outbound connection properties and make sure the server is up and running ");
                }
            }
            catch (Exception ex) {
                if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"deployBAMDataObjects()", (Throwable)ex);
                }
                if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING)) break block20;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING, (String)logClassName, (String)"deployBAMDataObjects()", (String)"Error in BAM Data Object deployment.");
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"deployBAMDataObjects ", (String)"END:");
    }

    @Override
    public void updateBAMComponentStatus(ComponentModel componentModel, AuditInstanceOperation component_status) {
        block5: {
            String logMethodName = "updateBAMComponentStatus ";
            BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"updateBAMComponentStatus ", (String)"BEGIN: deployBAMDataObjects");
            this.load(componentModel);
            CompositeModel composite = componentModel.getComposite();
            String dn = composite.getDN();
            String[] elems = composite.getDN().split("\\/");
            String partitionName = elems[0].trim();
            IElementContext elementContext = MeasurementUtil.getElementContext(composite.getDN(), componentModel.getName(), null, null, null, null);
            TAction action = this.getAction(elementContext, "BAMCommand");
            if (action == null || !action.isEnabled()) {
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"updateBAMComponentStatus ", (String)"BAMCommand not enabled.  Skipping BAM Data Object undeployment update.");
                return;
            }
            try {
                AuditInstance auditInstance = new AuditInstance();
                TProperties props = action.getProperties();
                if (props != null) {
                    List<TPropertyType> propList = props.getProperty();
                    for (TPropertyType prop : propList) {
                        auditInstance.setVariableValue(prop.getName(), (Object)prop.getValue());
                    }
                }
                MeasurementPublisher publisher = new MeasurementPublisher();
                Measure measure = new Measure();
                measure.setMeasurementEnabled(true);
                ArrayList<TAction> actionList = new ArrayList<TAction>();
                actionList.add(action);
                measure.setActions(actionList);
                auditInstance.setOperation(component_status);
                auditInstance.setCompositeDn(dn);
                auditInstance.setComponentName(componentModel.getName());
                auditInstance.setQueryId(new Long(-1L));
                auditInstance.setCreateTime((Calendar)new GregorianCalendar(0, 0, 0));
                auditInstance.setPartitionDate((Calendar)new GregorianCalendar(0, 0, 0));
                publisher.publish((IAuditInstance)auditInstance, measure);
            }
            catch (Exception e) {
                if (!BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING)) break block5;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING, (String)logClassName, (String)"undeployUpdateBAMDataObjects()", (String)"Error in BAM Data Object undeployment.");
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.WARNING, (String)logClassName, (String)"undeployUpdateBAMDataObjects()", (Throwable)e);
            }
        }
        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"updateBAMComponentStatus ", (String)"END:");
    }

    private boolean getMeasurementEnabled(List<MeasurementCacheElement> measurement, String compositeDN, String elementName, String elementType, String elementState, boolean activityLevel) {
        String logMethodName = "getMeasurementEnabled ";
        boolean measurementEnabled = false;
        if (measurement != null && measurement.size() > 0) {
            for (MeasurementCacheElement cacheData : measurement) {
                if (!cacheData.isEnable()) continue;
                if (AuditInstanceOperation.INSTANCE_ABORTED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_CREATED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_TERMINATED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_FAULT.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_SYSTEM_FAULT.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.STALE_COMPLETED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_SUSPENDED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_RESUMED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.INSTANCE_UPDATED.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.FLOW_NODE_MOVED.toString().equalsIgnoreCase(elementState)) {
                    measurementEnabled = true;
                    this.updateCacheList(compositeDN, cacheData);
                    continue;
                }
                if (AuditInstanceOperation.MEASUREMENT_COUNTER.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.MEASUREMENT_START_STOP.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.MEASUREMENT_START.toString().equalsIgnoreCase(elementState) || AuditInstanceOperation.MEASUREMENT_STOP.toString().equalsIgnoreCase(elementState)) {
                    if (BPMLogger.canLog((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG)) {
                        BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)("User Defined Measurement with element Type=" + elementType + "and Element state==" + elementState));
                    }
                    if (!cacheData.getElementType().contains(elementType) && !cacheData.getElementType().contains("ALL") && !"ALL".equals(cacheData.getElementSelection()) || !cacheData.getElementState().contains(elementState)) continue;
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)"Measurement Enabled");
                    measurementEnabled = true;
                    this.updateCacheList(compositeDN, cacheData);
                    continue;
                }
                if (!cacheData.getElementState().contains("ALL") && !cacheData.getElementState().contains(elementState) && !AuditInstanceOperation.STALE_ABORTED.toString().equalsIgnoreCase(elementState)) continue;
                BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)" Element State Match found");
                if (!activityLevel) {
                    if (!cacheData.getElementType().contains("ALL") && !cacheData.getElementType().contains(elementType) && !"ALL".equals(cacheData.getElementSelection()) && (!BpmnType.USER_TASK.toString().toUpperCase().equals(elementName.toUpperCase()) || !"INTERACTIVE".equals(cacheData.getElementSelection()))) continue;
                    BPMLogger.log((LoggerComponent)LoggerComponent.COMPONENT_ANALYTICS_DASHBOARD_MEASUREMENT, (Severity)Severity.DEBUG, (String)logClassName, (String)"getMeasurementEnabled ", (String)"Element Type or Element Name match found.");
                    measurementEnabled = true;
                    this.updateCacheList(compositeDN, cacheData);
                    continue;
                }
                if ("NONE".equals(cacheData.getElementSelection())) continue;
                measurementEnabled = true;
                this.updateCacheList(compositeDN, cacheData);
            }
        }
        return measurementEnabled;
    }

    private void updateCacheList(String compositeDn, MeasurementCacheElement element) {
        try {
            List<MeasurementActionCacheElement> actionList1 = MeasurementMetadataCache.getCacheInstance().getAction(compositeDn + element.getMeasurementElementName());
            for (MeasurementActionCacheElement elem : actionList1) {
                if (!elem.getAction().isEnabled()) continue;
                this.actionList.add(elem.getAction());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCompositeDNWithoutLabel(String compositeDn) {
        int index = compositeDn.indexOf("*");
        if (index != -1) {
            return compositeDn.substring(0, index);
        }
        return compositeDn;
    }

    private StringBuffer getContextInformation(IElementContext context) {
        StringBuffer strBuffer = new StringBuffer("\n");
        strBuffer.append("*************************  Received Context is  ****************** ");
        strBuffer.append("\n");
        strBuffer.append("1. Composite DN is   == > " + context.getCompositeDN());
        strBuffer.append("\n");
        strBuffer.append("2. Element State is  == > " + context.getElementState());
        strBuffer.append("\n");
        strBuffer.append("3. Element Type is   == > " + context.getElementType());
        strBuffer.append("\n");
        strBuffer.append("4. Element Id is     == > " + context.getElementId());
        strBuffer.append("\n");
        strBuffer.append("5. Element Name is   == > " + context.getElementName());
        strBuffer.append("\n");
        strBuffer.append("6. Component Name is == > " + context.getComponentName());
        strBuffer.append("\n");
        strBuffer.append("*************************  MEASUREMENT CACHE DATA  ****************** ");
        strBuffer.append("\n");
        return strBuffer;
    }
}

