/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement.metadata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import oracle.bpm.analytics.measurement.metadata.model.Actions;
import oracle.bpm.analytics.measurement.metadata.model.Measurements;

public class MeasurementMetadataUtil {
    public static List getMeasurementElements(String measurementXmlasString) {
        Unmarshaller unmarshaller = MeasurementMetadataUtil.getUnmarshaller();
        ArrayList<Object> mElement = null;
        if (unmarshaller != null) {
            try {
                byte[] bytes = measurementXmlasString.getBytes();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                Measurements measure = (Measurements)unmarshaller.unmarshal((InputStream)is);
                mElement = new ArrayList<Object>();
                mElement.add(measure.getCompositeDN());
                mElement.add(measure.getMeasurementElements().getMeasurementElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mElement;
    }

    public static List getMeasurementElements(InputStream in) {
        Unmarshaller unmarshaller = MeasurementMetadataUtil.getUnmarshaller();
        ArrayList<Object> mElement = null;
        if (unmarshaller != null) {
            try {
                Measurements measure = (Measurements)unmarshaller.unmarshal(in);
                mElement = new ArrayList<Object>();
                mElement.add(measure.getCompositeDN());
                mElement.add(measure.getMeasurementElements().getMeasurementElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mElement;
    }

    public static List getActionElements(String measurementActionXmlasString) {
        Unmarshaller unmarshaller = MeasurementMetadataUtil.getUnmarshaller();
        ArrayList<Object> actionList = null;
        if (unmarshaller != null) {
            try {
                byte[] bytes = measurementActionXmlasString.getBytes();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                Actions actions = (Actions)unmarshaller.unmarshal((InputStream)is);
                actionList = new ArrayList<Object>();
                actionList.add(actions.getCompositeDN());
                actionList.add(actions.getAction());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return actionList;
    }

    public static List getActionElements(InputStream in) {
        Unmarshaller unmarshaller = MeasurementMetadataUtil.getUnmarshaller();
        ArrayList<Object> actionList = null;
        if (unmarshaller != null) {
            try {
                Actions actions = (Actions)unmarshaller.unmarshal(in);
                actionList = new ArrayList<Object>();
                actionList.add(actions.getCompositeDN());
                actionList.add(actions.getAction());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return actionList;
    }

    private static Unmarshaller getUnmarshaller() {
        Unmarshaller unmarshaller = null;
        try {
            JAXBContext jaxbCtx = JAXBContext.newInstance((String)"oracle.bpm.analytics.measurement.metadata.model");
            unmarshaller = jaxbCtx.createUnmarshaller();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unmarshaller;
    }
}

