/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.analytics.measurement.impl;

import java.util.List;
import oracle.bpm.analytics.measurement.IMeasure;
import oracle.bpm.analytics.measurement.IMeasurementPublisher;
import oracle.bpm.analytics.measurement.MeasurementPublisherException;
import oracle.bpm.analytics.measurement.impl.Util;
import oracle.bpm.services.instancequery.IAuditInstance;

public class MeasurementPublisher
implements IMeasurementPublisher {
    private boolean bpmEnabled = false;
    private Util util = null;

    public MeasurementPublisher() {
        String bpmFlag = System.getProperty("bpm.enabled");
        if (bpmFlag != null && bpmFlag.equalsIgnoreCase("true")) {
            this.bpmEnabled = true;
        }
        this.util = new Util();
    }

    @Override
    public void publish(IAuditInstance ai, IMeasure measure) throws MeasurementPublisherException {
        try {
            if (!this.bpmEnabled) {
                return;
            }
            this.util.initializeJMSResources();
            this.util.publishObjectMessage(ai, measure);
        }
        catch (Exception e) {
            throw new MeasurementPublisherException(this.getClass().getName(), e.getMessage(), e);
        }
        finally {
            this.util.cleanup("publish");
        }
    }

    public void publishBatchAsList(List<IAuditInstance> aiList, List<IMeasure> measures) throws MeasurementPublisherException {
        try {
            if (!this.bpmEnabled) {
                return;
            }
            if (aiList.size() != measures.size()) {
                throw new MeasurementPublisherException("Number of auditInstances must match number of measures.");
            }
            this.util.initializeJMSResources();
            this.util.publishMessageList(aiList, measures);
        }
        catch (Exception e) {
            throw new MeasurementPublisherException(this.getClass().getName(), e.getMessage(), e);
        }
        finally {
            this.util.cleanup("publishBatch");
        }
    }

    public void publishBatch(List<IAuditInstance> aiList, List<IMeasure> measures) throws MeasurementPublisherException {
        try {
            if (!this.bpmEnabled) {
                return;
            }
            if (aiList.size() != measures.size()) {
                throw new MeasurementPublisherException("Number of auditInstances must match number of measures.");
            }
            this.util.initializeJMSResources();
            for (IAuditInstance ai : aiList) {
                this.util.publishObjectMessage(ai, measures.get(aiList.indexOf(ai)));
            }
        }
        catch (Exception e) {
            throw new MeasurementPublisherException(this.getClass().getName(), e.getMessage(), e);
        }
        finally {
            this.util.cleanup("publishBatch");
        }
    }
}

