/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Operation;
import oracle.tutor.bpmn.Pool;

public class Task
extends Activity
implements Cloneable {
    private TaskType _taskType = TaskType.NONE;
    private Task _taskReference;
    private String _implementation = "##unspecified";
    private Operation _operationRef;

    public Task() {
    }

    public Task(String id, String name) {
        super(id, name);
    }

    public Task(String id, String name, Lane lane) {
        super(id, name, lane);
    }

    public Task(String id, String name, Pool pool) {
        super(id, name, pool);
    }

    @Override
    public Task clone() throws CloneNotSupportedException {
        return (Task)super.clone();
    }

    @Override
    public Task clone(String newID) throws CloneNotSupportedException {
        return (Task)super.clone(newID);
    }

    public void setTaskType(TaskType taskType) {
        this._taskType = taskType;
    }

    public TaskType getTaskType() {
        if (this._taskType == null) {
            this._taskType = TaskType.NONE;
        }
        return this._taskType;
    }

    public void setTaskReference(Task taskReference) {
        if (taskReference == null) {
            if (this._taskReference != null) {
                this.setTaskType(this._taskReference.getTaskType());
            } else {
                this.setTaskType(TaskType.NONE);
            }
        } else {
            this.setTaskType(TaskType.REFERENCE);
        }
        this._taskReference = taskReference;
    }

    public Task getTaskReference() {
        return this._taskReference;
    }

    public void setImplementation(String implementation) {
        if (this.getTaskType().equals((Object)TaskType.REFERENCE) && this.getTaskReference() != null) {
            this.getTaskReference().setImplementation(implementation);
        } else {
            this._implementation = implementation;
        }
    }

    public String getImplementation() {
        if (this.getTaskType().equals((Object)TaskType.REFERENCE) && this.getTaskReference() != null) {
            return this.getTaskReference().getImplementation();
        }
        return this._implementation;
    }

    public void setOperationRef(Operation operationRef) {
        this._operationRef = operationRef;
    }

    public Operation getOperationRef() {
        return this._operationRef;
    }

    @Override
    public void setLoopType(Activity.LoopType loopType) {
        if (this.getTaskType().equals((Object)TaskType.REFERENCE) && this.getTaskReference() != null) {
            this.getTaskReference().setLoopType(loopType);
        } else {
            super.setLoopType(loopType);
        }
    }

    @Override
    public Activity.LoopType getLoopType() {
        if (this.getTaskType().equals((Object)TaskType.REFERENCE) && this.getTaskReference() != null) {
            return this.getTaskReference().getLoopType();
        }
        return super.getLoopType();
    }

    @Override
    public void setDocumentation(String documentation) {
        if (this.getTaskType().equals((Object)TaskType.REFERENCE) && this.getTaskReference() != null) {
            this.getTaskReference().setDocumentation(documentation);
        } else {
            super.setDocumentation(documentation);
        }
    }

    @Override
    public String getDocumentation() {
        if (this.getTaskType().equals((Object)TaskType.REFERENCE) && this.getTaskReference() != null) {
            return this.getTaskReference().getDocumentation();
        }
        return super.getDocumentation();
    }

    public static enum TaskType {
        NONE,
        USER,
        MANUAL,
        SERVICE,
        SEND,
        RECEIVE,
        SCRIPT,
        REFERENCE,
        BUSINESS_RULE;

    }
}

