/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Swimlane;

public class Pool
extends Swimlane
implements Cloneable {
    protected Map<String, Lane> mLanes = new HashMap<String, Lane>();

    public Pool() {
    }

    public Pool(String id, String name) {
        super(id, name);
    }

    public Pool(String id, String name, BusinessProcessDiagram bpd) {
        super(id, name, bpd);
        bpd.getPools().put(id, this);
    }

    @Override
    public Pool clone() throws CloneNotSupportedException {
        Pool copy = (Pool)super.clone();
        copy.setLanes(new HashMap<String, Lane>());
        return copy;
    }

    @Override
    public Pool clone(String newID) throws CloneNotSupportedException {
        return (Pool)super.clone(newID);
    }

    public void setLanes(Map<String, Lane> lanes) {
        this.mLanes = lanes;
    }

    public Map<String, Lane> getLanes() {
        if (this.mLanes == null) {
            this.mLanes = new HashMap<String, Lane>();
        }
        return this.mLanes;
    }

    public Lane getLane(Object key) {
        return this.getLanes().get(key);
    }

    @Override
    public void setModel(BusinessProcessDiagram bpd) {
        super.setModel(bpd);
        if (bpd != null) {
            bpd.getPools().put(this.getID(), this);
        }
    }

    @Override
    public void remove() {
        this.getModel().getPools().remove(this.getID());
        LinkedList<Lane> tmpLanes = new LinkedList<Lane>(this.getLanes().values());
        for (Lane lane : tmpLanes) {
            lane.setPool(null);
        }
        super.remove();
    }
}

