/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Gateway;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Swimlane;

public class Layout {
    private double _topMargin = 0.0;
    private double _leftMargin = 0.0;
    private double _poolSpacing = 0.0;
    private double _laneSpacing = 0.0;
    private double _laneOffset = 0.0;
    private double _verticalNodeSpacing = 0.0;
    private double _horizontalNodeSpacing = 0.0;
    private double _flowElbowOffset = 0.0;
    private double _defTaskWidth;
    private double _defTaskHeight;
    private boolean _flowsOnly = false;
    private boolean _flowsConnectToCenter = false;
    private LinkedList<GridPool> _gridPools = new LinkedList();

    public Layout() {
    }

    public Layout(double nodeWidth, double nodeHeight, boolean flowsOnly) {
        this._topMargin = nodeHeight;
        this._leftMargin = nodeWidth;
        this._poolSpacing = nodeHeight * 0.75;
        this._laneSpacing = 0.0;
        this._laneOffset = nodeWidth * 1.5;
        this._verticalNodeSpacing = nodeHeight * 1.75;
        this._horizontalNodeSpacing = nodeWidth * 1.5;
        this._flowElbowOffset = nodeWidth * 0.25;
        this._defTaskWidth = nodeWidth;
        this._defTaskHeight = nodeHeight;
        this._flowsOnly = flowsOnly;
    }

    public Layout(double nodeWidth, double nodeHeight) {
        this(nodeWidth, nodeHeight, false);
    }

    public void setTopMargin(double topMargin) {
        this._topMargin = topMargin;
    }

    public double getTopMargin() {
        return this._topMargin;
    }

    public void setLeftMargin(double leftMargin) {
        this._leftMargin = leftMargin;
    }

    public double getLeftMargin() {
        return this._leftMargin;
    }

    public void setPoolSpacing(double poolSpacing) {
        this._poolSpacing = poolSpacing;
    }

    public double getPoolSpacing() {
        return this._poolSpacing;
    }

    public void setLaneSpacing(double laneSpacing) {
        this._laneSpacing = laneSpacing;
    }

    public double getLaneSpacing() {
        return this._laneSpacing;
    }

    public void setLaneOffset(double laneOffset) {
        this._laneOffset = laneOffset;
    }

    public double getLaneOffset() {
        return this._laneOffset;
    }

    public void setVerticalNodeSpacing(double verticalNodeSpacing) {
        this._verticalNodeSpacing = verticalNodeSpacing;
    }

    public double getVerticalNodeSpacing() {
        return this._verticalNodeSpacing;
    }

    public void setHorizontalNodeSpacing(double horizontalNodeSpacing) {
        this._horizontalNodeSpacing = horizontalNodeSpacing;
    }

    public double getHorizontalNodeSpacing() {
        return this._horizontalNodeSpacing;
    }

    public void setFlowElbowOffset(double flowElbowOffset) {
        this._flowElbowOffset = flowElbowOffset;
    }

    public double getFlowElbowOffset() {
        return this._flowElbowOffset;
    }

    public void setDefTaskWidth(double defTaskWidth) {
        this._defTaskWidth = defTaskWidth;
    }

    public double getDefTaskWidth() {
        return this._defTaskWidth;
    }

    public void setDefTaskHeight(double defTaskHeight) {
        this._defTaskHeight = defTaskHeight;
    }

    public double getDefTaskHeight() {
        return this._defTaskHeight;
    }

    public void setFlowsOnly(boolean flowsOnly) {
        this._flowsOnly = flowsOnly;
    }

    public boolean isFlowsOnly() {
        return this._flowsOnly;
    }

    public void setGridPools(LinkedList<GridPool> gridPools) {
        this._gridPools = gridPools;
    }

    public LinkedList<GridPool> getGridPools() {
        return this._gridPools;
    }

    public void addGridPool(GridPool gPool) {
        this.getGridPools().add(gPool);
    }

    public GridPool addGridPool(Pool pool) {
        GridPool gPool = new GridPool(pool);
        this.addGridPool(gPool);
        return gPool;
    }

    public GridPool getGridPool(int i) {
        return this.getGridPools().get(i);
    }

    public GridPool getGridPool(Pool pool) {
        GridPool foundPool = null;
        for (GridPool gPool : this.getGridPools()) {
            if (gPool.getPool() != pool) continue;
            foundPool = gPool;
            break;
        }
        return foundPool;
    }

    public void doLayout(BusinessProcessDiagram bpd) {
        bpd.cleanUp(true, null);
        for (ConnectingObject flow : bpd.getAllFlows().values()) {
            flow.getPath().clear();
        }
        if (!this.isFlowsOnly()) {
            boolean atLeastOneNodeMoved;
            bpd.clearVisited();
            for (FlowObject node : bpd.getAllNodes().values()) {
                node.setPosition(0.0f, 0.0f);
            }
            for (FlowObject node : bpd.getStartNodes()) {
                this._addNodeToGrid(node, 0);
                this._traverseBreadth(node, 1);
            }
            bpd.clearVisited();
            for (FlowObject node : bpd.getStartNodes()) {
                this._traverseDepth(node, false);
            }
            bpd.clearVisited();
            for (FlowObject node : bpd.getStartNodes()) {
                this._traverseDepth(node, true);
            }
            int iterations = 0;
            do {
                atLeastOneNodeMoved = false;
                for (GridPool gPool : this.getGridPools()) {
                    for (GridLane gLane : gPool.getGridLanes()) {
                        for (GridRow gRow : gLane.getGridRows()) {
                            for (FlowObject node : gRow.getGridNodes()) {
                                if (node == null || !this._compressSpace(node)) continue;
                                atLeastOneNodeMoved = true;
                            }
                        }
                    }
                }
                System.out.println("\nCOMPRESS ITERATION " + ++iterations);
            } while (atLeastOneNodeMoved && iterations <= 100);
            for (Pool pool : bpd.getPools().values()) {
                GridPool gPool = this.getGridPool(pool);
                if (gPool == null) {
                    gPool = this.addGridPool(pool);
                }
                for (Lane lane : pool.getLanes().values()) {
                    if (gPool.getGridLane(lane) != null) continue;
                    gPool.addGridLane(lane);
                }
            }
            double poolX = this.getLeftMargin();
            double poolTop = this.getTopMargin();
            double maxX = Double.MIN_VALUE;
            for (GridPool gPool : this.getGridPools()) {
                gPool.getPool().setPosition(poolX, poolTop);
                double laneTop = poolTop;
                double laneHeight = 0.0;
                for (GridLane gLane : gPool.getGridLanes()) {
                    Swimlane lane = gLane.getLane();
                    laneHeight = this.getVerticalNodeSpacing() * (double)gLane.getGridRows().size();
                    if (lane != gPool.getPool()) {
                        lane.setPosition(poolX + this.getLaneOffset(), laneTop);
                        lane.setHeight(laneHeight);
                    }
                    int rowIndex = 0;
                    for (GridRow row : gLane.getGridRows()) {
                        double nodeY = laneTop + this.getVerticalNodeSpacing() / 2.0 + (double)rowIndex * this.getVerticalNodeSpacing();
                        double colIndex = 0.0;
                        for (FlowObject node : row.getGridNodes()) {
                            if (node != null) {
                                double nodeX = poolX + this.getLaneOffset() + this.getHorizontalNodeSpacing() / 2.0 + colIndex * this.getHorizontalNodeSpacing();
                                node.setPosition(nodeX, nodeY);
                                node.setHeight(this.getDefTaskHeight());
                                if (node instanceof Activity) {
                                    node.setWidth(this.getDefTaskWidth());
                                } else {
                                    node.setWidth(this.getDefTaskHeight());
                                }
                                node.setObjectPin(GraphicalElement.ObjectPin.MIDDLE);
                                maxX = Math.max(nodeX, maxX);
                            }
                            colIndex += 1.0;
                        }
                        ++rowIndex;
                    }
                    laneTop += laneHeight + this.getLaneSpacing();
                }
                double poolHeight = laneTop - poolTop;
                if (poolHeight == 0.0) {
                    poolHeight = this.getVerticalNodeSpacing();
                }
                gPool.getPool().setHeight(poolHeight);
                poolTop += poolHeight + this.getPoolSpacing();
            }
            for (Pool pool : bpd.getPools().values()) {
                pool.setWidth(maxX + this.getHorizontalNodeSpacing() / 2.0 - poolX);
                for (Lane lane : pool.getLanes().values()) {
                    lane.setWidth((double)pool.getWidth() - this.getLaneOffset());
                }
            }
            bpd.transform(BusinessProcessDiagram.CoordinateOrigins.UPPERLEFT, GraphicalElement.ObjectPin.UPPERLEFT);
        }
    }

    public void printDebug() {
        TreeMap<Character, FlowObject> legend = new TreeMap<Character, FlowObject>();
        char c = 'A';
        for (GridPool gridPool : this.getGridPools()) {
            System.out.println("==========" + gridPool.getPool().getName() + " =========================================================================");
            for (GridLane gl : gridPool.getGridLanes()) {
                System.out.println("----------" + gl.getLane().getName() + " -------------------------------------------------------------------------");
                for (GridRow gr : gl.getGridRows()) {
                    for (FlowObject node : gr.getGridNodes()) {
                        if (node == null) {
                            System.out.print(" ");
                            continue;
                        }
                        if (node instanceof Event) {
                            System.out.print("*");
                            continue;
                        }
                        if (node instanceof Gateway) {
                            System.out.print("+");
                            continue;
                        }
                        if (c == 'Z') {
                            c = 'a';
                        } else if (c == 'z') {
                            c = 'A';
                        }
                        legend.put(Character.valueOf(c), node);
                        char c2 = c;
                        c = (char)(c + '\u0001');
                        System.out.print(Character.toString(c2));
                    }
                    System.out.println();
                }
            }
        }
        System.out.println("LEGEND:");
        for (Map.Entry entry : legend.entrySet()) {
            FlowObject node = (FlowObject)entry.getValue();
            System.out.println("   " + entry.getKey() + ": " + node.getName() + " (" + node.getID() + ")");
        }
    }

    private void _addNodeToGrid(FlowObject node, int tgtCol) {
        GridRow fromNodeRow;
        FlowObject fromNode;
        ConnectingObject firstFlow;
        GridLane gridLane;
        GridPool gridPool;
        if (node.getLane() == null) {
            Pool hiddenPool = node.getModel().getPool("_hidden_");
            if (hiddenPool == null) {
                hiddenPool = new Pool("_hidden_", "", node.getModel());
                hiddenPool.setVisible(false);
            }
            node.setLane(hiddenPool);
        }
        if ((gridPool = this.getGridPool(node.getLane().getPool())) == null) {
            gridPool = this.addGridPool(node.getLane().getPool());
        }
        if ((gridLane = gridPool.getGridLane(node.getLane())) == null) {
            gridLane = gridPool.addGridLane(node.getLane());
        }
        GridRow tgtRow = gridLane.getGridRows().getFirst();
        if (!node.getInflows().isEmpty() && (firstFlow = node.getInflows().getFirst()).getFrom() != null && firstFlow.getFrom() instanceof FlowObject && (fromNode = (FlowObject)firstFlow.getFrom()).getLane() != null && fromNode.getLane().equals(node.getLane()) && (fromNodeRow = (GridRow)fromNode.getAttribute("gridRow")) != null) {
            tgtRow = fromNodeRow;
        }
        if (tgtRow.getNode(tgtCol) != null) {
            int tgtRowIndex = gridLane.getGridRows().indexOf(tgtRow);
            tgtRow = gridLane.addGridRow(tgtRowIndex + 1, new GridRow());
        }
        tgtRow.addNode(tgtCol, node);
    }

    private void _traverseBreadth(FlowObject node, int tgtCol) {
        FlowObject nextNode;
        node.setVisited(true);
        boolean nodeAdded = false;
        for (ConnectingObject flow : node.getOutflows()) {
            if (flow.getTo() == null || !(flow.getTo() instanceof FlowObject) || (nextNode = (FlowObject)flow.getTo()).getAttribute("gridRow") != null) continue;
            this._addNodeToGrid(nextNode, tgtCol);
            nodeAdded = true;
        }
        if (nodeAdded) {
            ++tgtCol;
        }
        for (ConnectingObject flow : node.getOutflows()) {
            if (flow.getTo() == null || !(flow.getTo() instanceof FlowObject) || (nextNode = (FlowObject)flow.getTo()).isVisited().booleanValue()) continue;
            this._traverseBreadth(nextNode, tgtCol);
        }
    }

    private void _traverseDepth(FlowObject node, boolean checkSuccessors) {
        node.setVisited(true);
        for (ConnectingObject flow : node.getInflows()) {
            GraphicalElement priorNode = flow.getFrom();
            if (priorNode == null || !(priorNode instanceof FlowObject) || node.getAttribute("gridRow").equals(priorNode.getAttribute("gridRow")) || checkSuccessors && node.hasSuccessor((FlowObject)priorNode, null)) continue;
            while (this._getNodeIndex(node) < this._getNodeIndex((FlowObject)priorNode)) {
                this._shiftNodeRight(node);
            }
        }
        for (ConnectingObject flow : node.getOutflows()) {
            GraphicalElement nextNode = flow.getTo();
            if (nextNode == null || !(nextNode instanceof FlowObject) || ((FlowObject)nextNode).isVisited().booleanValue()) continue;
            this._traverseDepth((FlowObject)nextNode, checkSuccessors);
        }
    }

    private int _getNodeIndex(FlowObject node) {
        GridRow thisRow = (GridRow)node.getAttribute("gridRow");
        if (thisRow == null) {
            return 0;
        }
        return thisRow.getGridNodes().indexOf(node);
    }

    private void _shiftNodeRight(FlowObject node) {
        int currentIndex;
        GridRow thisRow = (GridRow)node.getAttribute("gridRow");
        if (thisRow.getNode((currentIndex = thisRow.getGridNodes().indexOf(node)) + 1) == null) {
            thisRow.getGridNodes().remove(currentIndex + 1);
        }
        thisRow.addNode(currentIndex, null);
    }

    private boolean _slideNodeLeft(FlowObject node, int distance) {
        GridRow thisRow = (GridRow)node.getAttribute("gridRow");
        int currentIndex = this._getNodeIndex(node);
        boolean nodeMoved = false;
        for (int i = 1; i <= distance && currentIndex > 0 && thisRow.getNode(currentIndex - 1) == null; --currentIndex, ++i) {
            thisRow.getGridNodes().set(currentIndex - 1, node);
            thisRow.getGridNodes().set(currentIndex, null);
            nodeMoved = true;
        }
        return nodeMoved;
    }

    private boolean _compressSpace(FlowObject node) {
        boolean nodeMoved = false;
        int minSpaceCanMove = Integer.MAX_VALUE;
        int nodeIndex = this._getNodeIndex(node);
        for (ConnectingObject flow : node.getInflows()) {
            GraphicalElement priorNode = flow.getFrom();
            if (priorNode == null || !(priorNode instanceof FlowObject) || this._getNodeIndex((FlowObject)priorNode) >= nodeIndex) continue;
            if (priorNode.getOutflows().size() <= 2) {
                minSpaceCanMove = Math.min(minSpaceCanMove, nodeIndex - this._getNodeIndex((FlowObject)priorNode));
                continue;
            }
            minSpaceCanMove = Math.min(minSpaceCanMove, nodeIndex - (this._getNodeIndex((FlowObject)priorNode) + 1));
        }
        if (minSpaceCanMove > 1 && minSpaceCanMove < Integer.MAX_VALUE) {
            nodeMoved = this._slideNodeLeft(node, minSpaceCanMove);
        }
        return nodeMoved;
    }

    private LinkedList<Coordinate> _createPath(GraphicalElement srcObj, GraphicalElement tgtObj, Class flowClass) {
        LinkedList<Coordinate> path = new LinkedList<Coordinate>();
        return path;
    }

    private boolean _linesIntersect(double start1, double end1, double start2, double end2) {
        boolean intersect = false;
        return intersect;
    }

    public void setFlowsConnectToCenter(boolean flowsConnectToCenter) {
        this._flowsConnectToCenter = flowsConnectToCenter;
    }

    public boolean isFlowsConnectToCenter() {
        return this._flowsConnectToCenter;
    }

    private class GridRow {
        private LinkedList<FlowObject> _GridNodes = new LinkedList();
        private GridLane _GridLane;

        private GridRow() {
        }

        public void setGridNodes(LinkedList<FlowObject> nodes) {
            this._GridNodes = nodes;
        }

        public LinkedList<FlowObject> getGridNodes() {
            return this._GridNodes;
        }

        public void setGridLane(GridLane gridLane) {
            this._GridLane = gridLane;
        }

        public GridLane getGridLane() {
            return this._GridLane;
        }

        public void addNode(FlowObject node) {
            this.getGridNodes().add(node);
            if (node != null) {
                node.setAttribute("gridRow", this);
            }
        }

        public void addNode(int i, FlowObject node) {
            while (this.getGridNodes().size() <= i) {
                this.getGridNodes().add(null);
            }
            this.getGridNodes().add(i, node);
            if (node != null) {
                node.setAttribute("gridRow", this);
            }
        }

        public FlowObject getNode(int i) {
            if (i >= this.getGridNodes().size()) {
                this.addNode(i, null);
                return null;
            }
            return this.getGridNodes().get(i);
        }
    }

    private class GridLane {
        private Swimlane _Lane;
        private LinkedList<GridRow> _GridRows = new LinkedList();
        private GridPool _GridPool;

        private GridLane() {
            this.getGridRows().add(new GridRow());
        }

        private GridLane(Swimlane lane) {
            this();
            this.setLane(lane);
        }

        public void setLane(Swimlane lane) {
            this._Lane = lane;
        }

        public Swimlane getLane() {
            return this._Lane;
        }

        public void setGridRows(LinkedList<GridRow> rows) {
            this._GridRows = rows;
        }

        public LinkedList<GridRow> getGridRows() {
            return this._GridRows;
        }

        public void setGridPool(GridPool gridPool) {
            this._GridPool = gridPool;
        }

        public GridPool getGridPool() {
            return this._GridPool;
        }

        public GridRow addGridRow(GridRow row) {
            this.getGridRows().add(row);
            row.setGridLane(this);
            return row;
        }

        public GridRow getGridRow(int i) {
            return this.getGridRows().get(i);
        }

        public GridRow addGridRow(int i, GridRow row) {
            this.getGridRows().add(i, row);
            row.setGridLane(this);
            return row;
        }
    }

    private class GridPool {
        private Pool _Pool;
        private LinkedList<GridLane> _GridLanes = new LinkedList();

        private GridPool() {
        }

        private GridPool(Pool pool) {
            this.setPool(pool);
        }

        public void setPool(Pool pool) {
            this._Pool = pool;
        }

        public Pool getPool() {
            return this._Pool;
        }

        public void setGridLanes(LinkedList<GridLane> lanes) {
            this._GridLanes = lanes;
        }

        public LinkedList<GridLane> getGridLanes() {
            return this._GridLanes;
        }

        public GridLane addGridLane(GridLane gLane) {
            this.getGridLanes().add(gLane);
            gLane.setGridPool(this);
            return gLane;
        }

        public GridLane addGridLane(Swimlane lane) {
            GridLane gLane = new GridLane(lane);
            this.addGridLane(gLane);
            return gLane;
        }

        public GridLane getGridLane(int i) {
            return this.getGridLanes().get(i);
        }

        public GridLane getGridLane(Swimlane lane) {
            GridLane foundLane = null;
            for (GridLane gLane : this.getGridLanes()) {
                if (gLane.getLane() != lane) continue;
                foundLane = gLane;
                break;
            }
            return foundLane;
        }
    }
}

