/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.Coordinate;

public abstract class GraphicalElement
implements Cloneable {
    protected BusinessProcessDiagram mModel;
    private String mID;
    private String mName = "";
    private String mDocumentation = "";
    private double mWidth = 0.0;
    private double mHeight = 0.0;
    private ObjectPin mObjectPin = ObjectPin.UPPERLEFT;
    private String mSourceID;
    protected Coordinate mPosition = new Coordinate();
    protected Coordinate mTextPosition = new Coordinate();
    protected LinkedList<ConnectingObject> mInflows = new LinkedList();
    protected LinkedList<ConnectingObject> mOutflows = new LinkedList();
    protected HashMap<String, Object> mAttributes = new HashMap();

    public GraphicalElement() {
    }

    public GraphicalElement(String id, String name) {
        this();
        this.mID = id;
        this.mName = name;
    }

    public GraphicalElement(String id, String name, BusinessProcessDiagram bpd) {
        this(id, name);
        this.setModel(bpd);
    }

    public GraphicalElement clone() throws CloneNotSupportedException {
        GraphicalElement copy = (GraphicalElement)super.clone();
        copy.setPosition(this.mPosition.clone());
        copy.setTextPosition(this.mTextPosition.clone());
        copy.setInflows(new LinkedList<ConnectingObject>());
        copy.setOutflows(new LinkedList<ConnectingObject>());
        copy.setAttributes((HashMap)this.mAttributes.clone());
        return copy;
    }

    public GraphicalElement clone(String newID) throws CloneNotSupportedException {
        GraphicalElement copy = this.clone();
        copy.setID(newID);
        copy.setModel(this.mModel);
        return copy;
    }

    public void setID(String iD) {
        this.mID = iD;
    }

    public String getID() {
        if (this.mID == null) {
            this.mID = "";
        }
        return this.mID;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        if (this.mName == null) {
            this.mName = "";
        }
        return this.mName;
    }

    public void setTextPosition(Coordinate textPosition) {
        this.mTextPosition = textPosition;
    }

    public Coordinate getTextPosition() {
        if (this.mTextPosition == null) {
            this.mTextPosition = new Coordinate();
        }
        return this.mTextPosition;
    }

    public void setSourceID(String sourceID) {
        this.mSourceID = sourceID;
    }

    public String getSourceID() {
        if (this.mSourceID == null) {
            this.mSourceID = "";
        }
        return this.mSourceID;
    }

    public void setInflows(LinkedList<ConnectingObject> inflows) {
        this.mInflows = inflows;
    }

    public LinkedList<ConnectingObject> getInflows() {
        if (this.mInflows == null) {
            this.mInflows = new LinkedList();
        }
        return this.mInflows;
    }

    public LinkedList<ConnectingObject> getInflows(Class flowClass) {
        LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>();
        for (ConnectingObject flow : this.getInflows()) {
            if (!flow.getClass().equals(flowClass)) continue;
            inFlows.add(flow);
        }
        return inFlows;
    }

    public void setOutflows(LinkedList<ConnectingObject> outflows) {
        this.mOutflows = outflows;
    }

    public LinkedList<ConnectingObject> getOutflows() {
        if (this.mOutflows == null) {
            this.mOutflows = new LinkedList();
        }
        return this.mOutflows;
    }

    public LinkedList<ConnectingObject> getOutflows(Class flowClass) {
        LinkedList<ConnectingObject> outFlows = new LinkedList<ConnectingObject>();
        for (ConnectingObject flow : this.getOutflows()) {
            if (!flow.getClass().equals(flowClass)) continue;
            outFlows.add(flow);
        }
        return outFlows;
    }

    public void setPosition(Coordinate position) {
        this.mPosition = position;
    }

    public void setPosition(float x, float y) {
        this.mPosition.setX(x);
        this.mPosition.setY(y);
    }

    public void setPosition(double x, double y) {
        this.mPosition.setX(x);
        this.mPosition.setY(y);
    }

    public Coordinate getPosition() {
        if (this.mPosition == null) {
            this.mPosition = new Coordinate();
        }
        return this.mPosition;
    }

    public void setObjectPin(ObjectPin objectPin) {
        this.mObjectPin = objectPin;
    }

    public ObjectPin getObjectPin() {
        if (this.mObjectPin == null) {
            this.mObjectPin = ObjectPin.UPPERLEFT;
        }
        return this.mObjectPin;
    }

    public void setDocumentation(String documentation) {
        this.mDocumentation = documentation;
    }

    public String getDocumentation() {
        if (this.mDocumentation == null) {
            this.mDocumentation = "";
        }
        return this.mDocumentation;
    }

    public void setWidth(double width) {
        this.mWidth = width;
    }

    public void setWidth(float width) {
        this.mWidth = width;
    }

    public void setHeight(double height) {
        this.mHeight = height;
    }

    public void setHeight(float height) {
        this.mHeight = height;
    }

    public float getWidth() {
        return (float)this.mWidth;
    }

    public float getHeight() {
        return (float)this.mHeight;
    }

    public double getWidthd() {
        return this.mWidth;
    }

    public double getHeightd() {
        return this.mHeight;
    }

    public void setModel(BusinessProcessDiagram model) {
        this.mModel = model;
        if (model != null && model.getGraphicalElements().get(this.getID()) == null) {
            model.getGraphicalElements().put(this.getID(), this);
        }
    }

    public BusinessProcessDiagram getModel() {
        return this.mModel;
    }

    public void setAttributes(HashMap<String, Object> attributes) {
        this.mAttributes = attributes;
    }

    public Map<String, Object> getAttributes() {
        if (this.mAttributes == null) {
            this.mAttributes = new HashMap();
        }
        return this.mAttributes;
    }

    public void remove() {
        this.getModel().getGraphicalElements().remove(this.getID());
        LinkedList<ConnectingObject> tmpFlows = new LinkedList<ConnectingObject>(this.getInflows());
        for (ConnectingObject flow : tmpFlows) {
            flow.setTo(null);
        }
        tmpFlows = new LinkedList<ConnectingObject>(this.getOutflows());
        for (ConnectingObject flow : tmpFlows) {
            flow.setFrom(null);
        }
    }

    public void setAttribute(String key, Object value) {
        this.getAttributes().put(key, value);
    }

    public Object getAttribute(String key) {
        return this.getAttributes().get(key);
    }

    public void removeAttribute(String key) {
        this.getAttributes().remove(key);
    }

    public float getX() {
        return this.getPosition().getX();
    }

    public float getY() {
        return this.getPosition().getY();
    }

    public double getXd() {
        return this.getPosition().getXd();
    }

    public double getYd() {
        return this.getPosition().getYd();
    }

    public void setX(double x) {
        this.getPosition().setX(x);
    }

    public void setX(float x) {
        this.getPosition().setX(x);
    }

    public void setY(double y) {
        this.getPosition().setY(y);
    }

    public void setY(float y) {
        this.getPosition().setY(y);
    }

    public static enum ObjectPin {
        UPPERLEFT,
        LOWERLEFT,
        MIDDLE;

    }
}

