/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.HashSet;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.GraphicalElement;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;
import oracle.tutor.bpmn.Subprocess;
import oracle.tutor.bpmn.Swimlane;

public abstract class FlowObject
extends GraphicalElement
implements Cloneable {
    private Boolean mVisited = false;
    protected Subprocess mParentSubprocess;
    protected Swimlane mLane;

    public FlowObject() {
    }

    public FlowObject(String id, String name) {
        super(id, name);
    }

    public FlowObject(String id, String name, Swimlane swimlane) {
        this(id, name);
        this.setLane(swimlane);
    }

    public FlowObject(String id, String name, Lane lane) {
        this(id, name);
        this.setLane(lane);
    }

    public FlowObject(String id, String name, Pool pool) {
        this(id, name);
        this.setLane(pool);
    }

    public FlowObject(String id, String name, BusinessProcessDiagram bpd) {
        super(id, name, bpd);
        bpd.addNode(this);
    }

    @Override
    public FlowObject clone() throws CloneNotSupportedException {
        return (FlowObject)super.clone();
    }

    @Override
    public FlowObject clone(String newID) throws CloneNotSupportedException {
        FlowObject copy = (FlowObject)super.clone(newID);
        if (this.getModel() != null) {
            this.getModel().addNode(copy);
        }
        return copy;
    }

    public void setParentSubProcess(Subprocess parentSubprocess) {
        if (parentSubprocess == null) {
            if (this.getParentSubProcess() != null) {
                this.getParentSubProcess().getAllNodes().remove(this.getID());
                this.getParentSubProcess().getStartNodes().remove(this);
            }
        } else if (parentSubprocess.getAllNodes().get(this.getID()) == null) {
            parentSubprocess.getAllNodes().put(this.getID(), this);
        }
        this.mParentSubprocess = parentSubprocess;
    }

    public Subprocess getParentSubProcess() {
        return this.mParentSubprocess;
    }

    public void setLane(Lane lane) {
        this.setLane((Swimlane)lane);
    }

    public void setLane(Pool pool) {
        this.setLane((Swimlane)pool);
    }

    public void setLane(Swimlane swimlane) {
        this.mLane = swimlane;
        if (swimlane != null) {
            this.setModel(swimlane.getModel());
            this.getModel().addNode(this);
        }
    }

    public Swimlane getLane() {
        return this.mLane;
    }

    public void setVisited(Boolean visited) {
        this.mVisited = visited;
    }

    public Boolean isVisited() {
        if (this.mVisited == null) {
            this.mVisited = false;
        }
        return this.mVisited;
    }

    @Override
    public void remove() {
        this.getModel().getAllNodes().remove(this.getID());
        this.getModel().getStartNodes().remove(this);
        this.getModel().getSequencedNodes().remove(this);
        this.setParentSubProcess(null);
        super.remove();
    }

    public boolean hasSuccessor(FlowObject targetNode, SequenceFlow flowToIgnore) {
        HashSet<FlowObject> visitedNodes = new HashSet<FlowObject>();
        if (targetNode == null || targetNode.getInflows(SequenceFlow.class).isEmpty()) {
            return false;
        }
        return this.findSuccessor(targetNode, flowToIgnore, visitedNodes);
    }

    private boolean findSuccessor(FlowObject targetNode, SequenceFlow flowToIgnore, HashSet<FlowObject> visitedNodes) {
        if (visitedNodes.contains(this)) {
            return false;
        }
        visitedNodes.add(this);
        boolean foundTarget = false;
        for (ConnectingObject flow : this.getOutflows(SequenceFlow.class)) {
            FlowObject toNode;
            FlowObject flowObject = toNode = flow.getTo() instanceof FlowObject ? (FlowObject)flow.getTo() : null;
            if (flow == flowToIgnore || toNode == null || toNode == this) continue;
            if (toNode == targetNode) {
                foundTarget = true;
                break;
            }
            if (!toNode.findSuccessor(targetNode, flowToIgnore, visitedNodes)) continue;
            foundTarget = true;
            break;
        }
        return foundTarget;
    }
}

