/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.LinkedList;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.GraphicalElement;

public abstract class ConnectingObject
extends GraphicalElement
implements Cloneable {
    private GraphicalElement mFrom;
    private GraphicalElement mTo;
    private LinkedList<Coordinate> mPath = new LinkedList();

    public ConnectingObject() {
    }

    public ConnectingObject(String id, String name) {
        super(id, name);
    }

    public ConnectingObject(String id, String name, GraphicalElement obj1, GraphicalElement obj2) {
        this(id, name);
        this.setFrom(obj1);
        this.setTo(obj2);
        obj1.getModel().addFlow(this);
    }

    @Override
    public ConnectingObject clone() throws CloneNotSupportedException {
        ConnectingObject copy = (ConnectingObject)super.clone();
        LinkedList<Coordinate> newPath = new LinkedList<Coordinate>();
        for (Coordinate coord : this.getPath()) {
            newPath.add(coord.clone());
        }
        copy.setPath(newPath);
        return copy;
    }

    @Override
    public ConnectingObject clone(String newID) throws CloneNotSupportedException {
        ConnectingObject copy = (ConnectingObject)super.clone(newID);
        if (copy.getModel() != null) {
            copy.getModel().addFlow(copy);
        }
        return copy;
    }

    public void setFrom(GraphicalElement from) {
        if (this.getFrom() != null) {
            this.getFrom().getOutflows().remove(this);
        }
        if (from != null && !from.getOutflows().contains(this)) {
            from.getOutflows().add(this);
        }
        this.mFrom = from;
    }

    public GraphicalElement getFrom() {
        return this.mFrom;
    }

    public void setTo(GraphicalElement to) {
        if (this.getTo() != null) {
            this.getTo().getInflows().remove(this);
        }
        if (to != null && !to.getInflows().contains(this)) {
            to.getInflows().add(this);
        }
        this.mTo = to;
    }

    public GraphicalElement getTo() {
        return this.mTo;
    }

    public void setPath(LinkedList<Coordinate> path) {
        this.mPath = path;
    }

    public LinkedList<Coordinate> getPath() {
        if (this.mPath == null) {
            this.mPath = new LinkedList();
        }
        return this.mPath;
    }

    @Override
    public void remove() {
        this.getModel().getAllFlows().remove(this.getID());
        this.setFrom(null);
        this.setTo(null);
        super.remove();
    }
}

