/*
 * Decompiled with CFR 0.152.
 */
package oracle.tutor.bpmn;

import java.util.Collection;
import java.util.LinkedList;
import oracle.tutor.bpmn.Event;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Resource;

public class Activity
extends FlowObject
implements Cloneable {
    private LoopType _loopType = LoopType.NONE;
    private Boolean _compensation = false;
    private Collection<Event> _attachedEvents = new LinkedList<Event>();
    private LinkedList<Resource> _resources = new LinkedList();

    public Activity() {
    }

    public Activity(String id, String name) {
        super(id, name);
    }

    public Activity(String id, String name, Lane lane) {
        super(id, name, lane);
    }

    public Activity(String id, String name, Pool pool) {
        super(id, name, pool);
    }

    @Override
    public Activity clone() throws CloneNotSupportedException {
        Activity copy = (Activity)super.clone();
        copy.setAttachedEvents(new LinkedList<Event>());
        copy.setResources((LinkedList)this.getResources().clone());
        return copy;
    }

    @Override
    public Activity clone(String newID) throws CloneNotSupportedException {
        return (Activity)super.clone(newID);
    }

    public void setLoopType(LoopType loopType) {
        this._loopType = loopType;
    }

    public LoopType getLoopType() {
        if (this._loopType == null) {
            this._loopType = LoopType.NONE;
        }
        return this._loopType;
    }

    public void setAttachedEvents(Collection<Event> attachedEvents) {
        this._attachedEvents = attachedEvents;
    }

    public Collection<Event> getAttachedEvents() {
        if (this._attachedEvents == null) {
            this._attachedEvents = new LinkedList<Event>();
        }
        return this._attachedEvents;
    }

    public void setCompensation(Boolean compensation) {
        this._compensation = compensation;
    }

    public Boolean isCompensation() {
        if (this._compensation == null) {
            this._compensation = false;
        }
        return this._compensation;
    }

    public void setResources(LinkedList<Resource> resources) {
        this._resources = resources;
    }

    public LinkedList<Resource> getResources() {
        return this._resources;
    }

    @Override
    public void remove() {
        LinkedList<Event> tmpEvents = new LinkedList<Event>(this.getAttachedEvents());
        for (Event e : tmpEvents) {
            e.setTarget(null);
        }
        super.remove();
    }

    public void addResource(Resource resource) {
        this.getResources().add(resource);
    }

    public static enum LoopType {
        NONE,
        STANDARD,
        MULTIINSTANCE;

    }
}

