/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.wfmc.parser;

import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.importer.wfmc.ModelAttributes;
import oracle.bpm.project.importer.wfmc.parser.DataType;
import oracle.bpm.project.importer.wfmc.parser.XPDLElement;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.Element;

public class FormalParameter
extends XPDLElement {
    private static final String ID = "Id";
    private static final String NAME = "Name";
    private static final String MODE = "Mode";
    private static final String INDEX = "Index";

    public FormalParameter() {
        this.setTagName("FormalParameter");
    }

    public FormalParameter(String name, TypeDescription type) {
        this();
        this.setAttribute(ModelAttributes.ID, name);
        this.addChild((Element)new DataType(type));
    }

    public DataType getDataType() {
        DefaultElement dataType = this.findChildByClass(DataType.class);
        if (dataType != null) {
            dataType = dataType.findChildByClass(DataType.class);
        }
        if (dataType == null) {
            dataType = new DataType();
        }
        return (DataType)dataType;
    }

    public String getDescription() {
        XPDLElement description = (XPDLElement)this.findChildByName("Description");
        if (description != null) {
            return description.getTextContent();
        }
        return "";
    }

    @Override
    public String getId() {
        return this.getAttribute(ID);
    }

    public boolean isIn() {
        return "IN".equals(this.getAttribute(MODE)) || "INOUT".equals(this.getAttribute(MODE));
    }

    public String getName() {
        return this.getAttribute(NAME);
    }

    public boolean isOut() {
        return "OUT".equals(this.getAttribute(MODE)) || "INOUT".equals(this.getAttribute(MODE));
    }
}

