/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.aris.parser;

import java.util.Set;
import oracle.bpm.project.importer.aris.parser.ArisElement;
import oracle.bpm.project.importer.aris.parser.Occurrence;

public class Model
extends ArisElement {
    private Dimensions dimensions;
    private Occurrence[] occurrencesArray;
    private Set occurrencesSet;

    public Dimensions getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new Dimensions();
            Set occurrencesSet = this.getOccurrencesAsSet();
            for (Occurrence occurrence : occurrencesSet) {
                this.dimensions.addShapeCoordinates(occurrence.getX(), occurrence.getY());
            }
        }
        return this.dimensions;
    }

    @Override
    public String getId() {
        return this.getAttribute("Model.ID");
    }

    public String getName() {
        return this.getAttrDefValue("AttrDef.Type", "AT_NAME");
    }

    public Occurrence[] getOccurrences() {
        Set occurrencesSet = this.getOccurrencesAsSet();
        if (this.occurrencesArray == null) {
            this.occurrencesArray = occurrencesSet.toArray(new Occurrence[occurrencesSet.size()]);
        }
        return this.occurrencesArray;
    }

    public Set getOccurrencesAsSet() {
        if (this.occurrencesSet == null) {
            this.occurrencesSet = this.findChildrenByClassAsSet(Occurrence.class);
        }
        return this.occurrencesSet;
    }

    public static class Dimensions {
        private double maxX = 0.0;
        private double maxY = 0.0;
        private double minX = Double.MAX_VALUE;
        private double minY = Double.MAX_VALUE;

        public double getHeight() {
            return this.maxY - this.minY;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public double getMinX() {
            return this.minX;
        }

        public double getMinY() {
            return this.minY;
        }

        public double getWidth() {
            return this.maxX - this.minX;
        }

        protected void addShapeCoordinates(double x, double y) {
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
        }
    }
}

