/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.aris.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import oracle.bpm.project.importer.aris.parser.AML;
import oracle.bpm.project.importer.aris.parser.ArisElementFactory;
import oracle.bpm.project.model.exception.ImporterException;
import oracle.bpm.xmlparser.ElementFactory;
import oracle.bpm.xmlparser.MessageListener;
import oracle.bpm.xmlparser.Parser;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class ArisParser
extends Parser {
    private AML aml;
    private MessageListener listener;
    private Parser parser;
    private static ArisParser instance;

    private ArisParser() {
    }

    public static ArisParser getInstance() {
        if (instance == null) {
            instance = new ArisParser();
        }
        return instance;
    }

    public AML getAML() {
        return this.aml;
    }

    public MessageListener getListener() {
        return this.listener;
    }

    public void parse(File source) throws ImporterException {
        if (this.parser == null) {
            this.parser = new Parser();
            this.parser.setDocumentLocator((Locator)new LocatorImpl());
            this.parser.setElementFactory((ElementFactory)new ArisElementFactory());
            this.parser.setMessageListener(this.listener);
        }
        source = this.fixDTD(source);
        try {
            URL sourceUrl = source.toURL();
            FileInputStream inputStream = new FileInputStream(source);
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
            System.err.println("sourceUrl = " + sourceUrl);
            this.setAML((AML)this.parser.parse(sourceUrl, (Reader)inputReader));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ImporterException(null, (Throwable)e);
        }
    }

    public void reset() {
        instance = null;
    }

    public void setListener(MessageListener listener) {
        this.listener = listener;
    }

    private File fixDTD(File file) {
        File fixedFile = new File(System.getProperty("user.home") + File.separator + file.getName() + "-fixed.xml");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            FileWriter fileWriter = new FileWriter(fixedFile);
            String line = bufferedReader.readLine();
            while (line != null) {
                if (line.indexOf("<!DOCTYPE AML SYSTEM") != -1) {
                    line = "<!DOCTYPE AML [";
                }
                fileWriter.write(line + "\n");
                line = bufferedReader.readLine();
            }
            fileWriter.flush();
            fileWriter.close();
            bufferedReader.close();
            return fixedFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setAML(AML aml) {
        this.aml = aml;
    }
}

