/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.aris.parser;

import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.project.importer.aris.parser.AML;
import oracle.bpm.project.importer.aris.parser.ArisElement;
import oracle.bpm.project.importer.aris.parser.AttrDef;
import oracle.bpm.project.importer.aris.parser.AttrOcc;
import oracle.bpm.project.importer.aris.parser.AttrValue;
import oracle.bpm.project.importer.aris.parser.CxnDef;
import oracle.bpm.project.importer.aris.parser.CxnOcc;
import oracle.bpm.project.importer.aris.parser.Database;
import oracle.bpm.project.importer.aris.parser.ElementType;
import oracle.bpm.project.importer.aris.parser.FFTextDef;
import oracle.bpm.project.importer.aris.parser.FFTextOcc;
import oracle.bpm.project.importer.aris.parser.FilterGUID;
import oracle.bpm.project.importer.aris.parser.FontStyleSheet;
import oracle.bpm.project.importer.aris.parser.GUID;
import oracle.bpm.project.importer.aris.parser.Generic;
import oracle.bpm.project.importer.aris.parser.Group;
import oracle.bpm.project.importer.aris.parser.HeaderInfo;
import oracle.bpm.project.importer.aris.parser.Language;
import oracle.bpm.project.importer.aris.parser.MasterGUID;
import oracle.bpm.project.importer.aris.parser.Model;
import oracle.bpm.project.importer.aris.parser.ObjDef;
import oracle.bpm.project.importer.aris.parser.ObjOcc;
import oracle.bpm.project.importer.aris.parser.Position;
import oracle.bpm.project.importer.aris.parser.Prefix;
import oracle.bpm.project.importer.aris.parser.SymbolGUID;
import oracle.bpm.project.importer.aris.parser.Text;
import oracle.bpm.project.importer.aris.parser.User;
import oracle.bpm.project.importer.aris.parser.UserGroup;
import oracle.bpm.xmlparser.Element;
import oracle.bpm.xmlparser.ElementFactory;
import oracle.bpm.xmlparser.NamespaceContext;
import oracle.bpm.xmlparser.Parser;
import org.xml.sax.Locator;

public class ArisElementFactory
implements ElementFactory {
    private NamespaceContext context;
    private Locator locator;
    private Parser parser;

    public Element create(String namespace, String name, Map<QName, String> attrs) {
        ArisElement element;
        int type = ElementType.findByName(name);
        switch (type) {
            case 0: {
                element = new AML();
                break;
            }
            case 17: {
                element = new HeaderInfo();
                break;
            }
            case 19: {
                element = new Language();
                break;
            }
            case 8: 
            case 20: 
            case 21: {
                element = new Generic();
                break;
            }
            case 28: {
                element = new Prefix();
                break;
            }
            case 7: {
                element = new Database();
                break;
            }
            case 1: {
                element = new AttrDef();
                break;
            }
            case 3: {
                element = new AttrValue();
                break;
            }
            case 23: {
                element = new Model();
                break;
            }
            case 31: {
                element = new User();
                break;
            }
            case 32: {
                element = new UserGroup();
                break;
            }
            case 15: {
                element = new GUID();
                break;
            }
            case 11: {
                element = new FilterGUID();
                break;
            }
            case 30: {
                element = new SymbolGUID();
                break;
            }
            case 14: {
                element = new FontStyleSheet();
                break;
            }
            case 13: {
                element = new Generic();
                break;
            }
            case 9: {
                element = new FFTextDef();
                break;
            }
            case 10: {
                element = new FFTextOcc();
                break;
            }
            case 16: {
                element = new Group();
                break;
            }
            case 24: {
                element = new ObjDef();
                break;
            }
            case 5: {
                element = new CxnDef();
                break;
            }
            case 12: {
                element = new Generic();
                break;
            }
            case 4: 
            case 18: 
            case 26: {
                element = new Generic();
                break;
            }
            case 25: {
                element = new ObjOcc();
                break;
            }
            case 27: {
                element = new Position();
                break;
            }
            case 29: {
                element = new Position();
                break;
            }
            case 6: {
                element = new CxnOcc();
                break;
            }
            case 2: {
                element = new AttrOcc();
                break;
            }
            case 22: {
                element = new MasterGUID();
                break;
            }
            default: {
                element = null;
            }
        }
        if (element == null) {
            return null;
        }
        if (this.locator == null) {
            this.locator = this.parser.getLocator();
        }
        element.setTagName(name);
        element.setAttributes(attrs);
        element.setXMLParser(this.parser);
        element.setLine(this.locator.getLineNumber());
        element.setColumn(this.locator.getColumnNumber());
        element.setNSContext(this.context);
        return element;
    }

    public Element createText(String text) {
        return new Text(text);
    }

    public void setContext(NamespaceContext ctx) {
        this.context = ctx;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }
}

