/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.debug.components;

import fuego.directory.DirectoryException;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.util.DirectoryEnvironment;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.compiler.debug.components.ProjectObjectDebug;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.ApplicationRole;
import oracle.bpm.project.model.identity.Group;
import oracle.bpm.project.model.identity.Member;
import oracle.bpm.project.model.identity.MemberType;
import oracle.bpm.project.model.identity.User;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.PotentialAssignee;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.model.organization.RoleEscalation;
import oracle.bpm.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoleDebug
implements RoleInterface {
    private Map<String, Map<Object, Object>> propertiesByApplication = new HashMap<String, Map<Object, Object>>();
    private Role role;

    public RoleDebug() {
        this.role = new RoleImpl();
    }

    public RoleDebug(Role role) {
        this.role = role;
    }

    @Override
    public String getDescription() {
        return this.role.getDescription();
    }

    @Override
    public String getId() {
        return this.role.getId();
    }

    @Override
    public int getIn() {
        return -1;
    }

    @Override
    public String getName() {
        return this.role.getId();
    }

    @Override
    public String getOrganization() {
        return this.role.getOrganization().getProject().getName();
    }

    @Override
    public void addParticipant(String participant, String permission) {
    }

    @Override
    public String retrieveEncryptedPropertyFor(String application, String name, String key) throws DirectoryException {
        String encryptedValue = (String)this.retrievePropertyInternal(application, name);
        String value = DirectoryEnvironment.encryptValue(key, Base64.decode(encryptedValue));
        if (!value.startsWith(key)) {
            if (Log.isDebugging()) {
                Log.logDebug("Invalid encryption key " + key + " for value " + value);
            }
            return null;
        }
        return value.substring(key.length());
    }

    @Override
    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        return this.retrievePropertyInternal(application, name);
    }

    @Override
    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        return (String)this.retrievePropertyInternal(application, name);
    }

    @Override
    public void storeEncryptedPropertyFor(String application, String name, String value, String key) throws DirectoryException {
        String encryptedValue = DirectoryEnvironment.encryptValue(key, key + value);
        try {
            encryptedValue = Base64.encode(encryptedValue.getBytes(Literals.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw DirectoryRuntimeException.wrapException((Throwable)e);
        }
        this.storePropertyInternal(application, name, encryptedValue);
    }

    @Override
    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        this.storePropertyInternal(application, name, value);
    }

    @Override
    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        this.storePropertyInternal(application, name, value);
    }

    public Class getRawClass() {
        return RoleInterface.class;
    }

    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    private Object retrievePropertyInternal(String application, String name) {
        Map<Object, Object> propertiesByName = this.propertiesByApplication.get(application);
        if (propertiesByName != null) {
            return propertiesByName.get(name);
        }
        return null;
    }

    private void storePropertyInternal(String application, String name, Object value) {
        Map<Object, Object> propertiesByName = this.propertiesByApplication.get(application);
        if (propertiesByName == null) {
            propertiesByName = new HashMap<Object, Object>();
            this.propertiesByApplication.put(application, propertiesByName);
        }
        propertiesByName.put(name, value);
    }

    private static class RoleImpl
    extends ProjectObjectDebug
    implements Role {
        private Path path;

        private RoleImpl() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public ProjectObjectType getProjectObjectType() {
            ProjectObjectType projectObjectType = ProjectObjectType.ROLES_CONTAINER;
            if (projectObjectType == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/RoleDebug$RoleImpl.getProjectObjectType must not return null");
            }
            return projectObjectType;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        public boolean isReferencedByProcesses() {
            return false;
        }

        public LocaleStringMap getLabelMap() {
            return null;
        }

        public String getDefaultLabel() {
            return null;
        }

        public String getLabel(Locale locale) {
            return null;
        }

        public AssignableToRole findAssignedObject(String assignedObjectId) {
            return null;
        }

        public void setName(String name) {
        }

        public void setShared(boolean shared) {
        }

        public boolean isShared() {
            return true;
        }

        public RoleEscalation getRoleEscalation() {
            return null;
        }

        public void setRoleEscalation(RoleEscalation roleEscalation) {
        }

        public String getName() {
            return null;
        }

        public String getDescription() {
            return "Debug Role";
        }

        public boolean isVirtual() {
            return false;
        }

        public Collection<CalendarRuleAssignment> getCalendarRuleAssignment() {
            return null;
        }

        public Collection<RoleAssignment> getRoleAssignments() {
            return null;
        }

        public void setDescription(String description) {
        }

        public CalendarRuleAssignment.Mutable createCalendarRuleAssignment() {
            return null;
        }

        public void setCalendarRuleAssignment(Collection<CalendarRuleAssignment> calendarRuleAssignments) {
        }

        public void addCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        }

        public void removeCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        }

        public void addRoleAssignment(RoleAssignment roleAssignment) {
        }

        public void removeRoleAssignment(RoleAssignment roleAssignment) {
        }

        public void removeAllRoleAssignments() {
        }

        public boolean isProcessOwner() {
            return false;
        }

        public void removeCalendarRuleAssignments(CalendarRule calendarRule) {
        }

        public void removeCalendarRuleAssignments(OrganizationalUnit ou) {
        }

        public PotentialAssignee getPotentialAssignee() {
            return null;
        }

        public void setPotentialAssignee(PotentialAssignee potentialAssignee) {
        }

        public int compareTo(Role role) {
            return this.getId().compareTo(role.getId());
        }

        public Organization getOrganization() {
            return null;
        }

        public Class getRawClass() {
            return Role.class;
        }

        public boolean is(Class<? extends ProjectObject> clazz) {
            return clazz.isAssignableFrom(this.getRawClass());
        }

        public void setId(String id) {
        }

        public void setModified(boolean value) {
        }

        public void setDefault(boolean isDefault) {
        }

        public void delete() throws ProjectException {
        }

        public Sequence<User> getUsers() {
            return null;
        }

        public void addMember(Member member) throws ProjectException {
        }

        public void removeMember(Member member) throws ProjectException {
        }

        public Member findMember(String memberId) {
            return null;
        }

        public Sequence<Member> getMembers() {
            return null;
        }

        public void addUser(User user) throws ProjectException {
        }

        public Sequence<Group> getGroups() {
            return null;
        }

        public void addGroup(Group group) throws ProjectException {
        }

        public Sequence<ApplicationRole> getApplicationRoles() {
            return null;
        }

        public void addApplicationRole(ApplicationRole applicationRole) throws ProjectException {
        }

        public User createUser(String id) throws ProjectException {
            return null;
        }

        public Group createGroup(String id) throws ProjectException {
            return null;
        }

        public ApplicationRole createApplicationRole(String id) throws ProjectException {
            return null;
        }

        public User findUser(String userId) {
            return null;
        }

        public Group findGroup(String groupId) {
            return null;
        }

        public ApplicationRole findApplicationRole(String applicationRoleId) {
            return null;
        }

        public void removeUser(User user) throws ProjectException {
        }

        public void removeGroup(Group group) throws ProjectException {
        }

        public void removeApplicationRole(ApplicationRole applicationRole) throws ProjectException {
        }

        public Member createMember(MemberType memberType, String id) {
            return null;
        }

        public Comparator<ProjectObject> getChildComparator() {
            return null;
        }

        public boolean contains(ProjectObject child) {
            return false;
        }

        @Nullable
        public <T extends ProjectObject> T findChild(Class<T> type, String id) {
            return null;
        }

        public <E extends ProjectObject> E findDescendant(Class<E> type, String id) {
            return null;
        }

        @NotNull
        public <E extends ProjectObject> Sequence<E> getDescendants(Class<E> type) {
            if (null == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/RoleDebug$RoleImpl.getDescendants must not return null");
            }
            return null;
        }

        @NotNull
        public <E extends ProjectObject> Sequence<E> getChildrenByType(Class<E> type) {
            if (null == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/RoleDebug$RoleImpl.getChildrenByType must not return null");
            }
            return null;
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren() {
            if (null == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/RoleDebug$RoleImpl.getChildren must not return null");
            }
            return null;
        }

        public void addChild(ProjectObject child) throws ProjectException {
        }

        public void addChild(ProjectObject child, int position) throws ProjectException {
        }

        public void removeChild(ProjectObject child) throws ProjectException {
        }

        public void moveChild(ProjectObject child, int newPosition) throws ProjectException {
        }

        public void replaceChild(ProjectObject oldProjectObject, ProjectObject newProjectObject) throws ProjectException {
        }

        public ProjectObject getChildAt(int index) {
            return null;
        }

        public void clear() {
        }

        public int indexOf(ProjectObject projectObject) {
            return -1;
        }

        public int getChildCount() {
            return 0;
        }
    }
}

