/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.debug.components;

import fuego.directory.DirectoryException;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.compiler.debug.components.ActivityDebug;
import oracle.bpm.compiler.debug.components.OrganizationalGroupDebug;
import oracle.bpm.components.ActivityInterface;
import oracle.bpm.components.OrganizationalGroupInterface;
import oracle.bpm.components.ProcessInterface;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;

public class ProcessInterfaceDebug
implements ProcessInterface {
    private Process model;
    private HashMap<String, Map<Object, Object>> properties = new HashMap();

    public ProcessInterfaceDebug(Process model) {
        this.model = model;
    }

    @Override
    public ActivityInterface getActivityInterface(String activityName) {
        Activity node = this.model.findActivity(activityName);
        if (node != null) {
            return ActivityDebug.create((FlowNode)node);
        }
        return null;
    }

    @Override
    public ActivityInterface[] getActivitiesInterface() {
        Sequence nodes = this.model.getFlowNodes();
        ActivityInterface[] acts = new ActivityInterface[nodes.toArray().length];
        int i = 0;
        for (FlowNode node : nodes) {
            acts[i++] = ActivityDebug.create(node);
        }
        return acts;
    }

    @Override
    public int getCatalogIn() {
        return -1;
    }

    @Override
    public OrganizationalGroupInterface getGroupInterface(String groupName) {
        Group group = this.model.getProject().getOrganization().findGroup(groupName);
        if (group != null) {
            return new OrganizationalGroupDebug(group);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.model.getId();
    }

    @Override
    public String getName() {
        return this.model.getId();
    }

    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public String retrieveEncryptedPropertyFor(String application, String name, String key) throws DirectoryException {
        return (String)this.retrievePropertyInternal(application, name);
    }

    @Override
    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        return this.retrievePropertyInternal(application, name);
    }

    @Override
    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        return (String)this.retrievePropertyInternal(application, name);
    }

    @Override
    public void storeEncryptedPropertyFor(String application, String name, String value, String key) throws DirectoryException {
        this.storePropertyInternal(application, name, value);
    }

    @Override
    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        this.storePropertyInternal(application, name, value);
    }

    @Override
    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        this.storePropertyInternal(application, name, value);
    }

    public void updateClass() {
    }

    public void validateProcInstCache() {
    }

    @Override
    public String getRealRole(String roleId) {
        return roleId;
    }

    private Object retrievePropertyInternal(String application, String name) {
        Map<Object, Object> props = this.properties.get(application);
        if (props == null) {
            return null;
        }
        return props.get(name);
    }

    private void storePropertyInternal(String application, String name, Object value) {
        Map<Object, Object> props = this.properties.get(application);
        if (props == null) {
            props = new HashMap<Object, Object>();
            this.properties.put(application, props);
        }
        props.put(name, value);
    }
}

