/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.debug.components;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.compiler.debug.components.ActivityDebug;
import oracle.bpm.compiler.debug.components.RoleDebug;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.components.Activity;
import oracle.bpm.components.DetachedFieldHandler;
import oracle.bpm.components.InstanceComponent;
import oracle.bpm.components.InstanceId;
import oracle.bpm.components.Participant;
import oracle.bpm.components.ParticipantInterface;
import oracle.bpm.components.ProcessInstanceInterface;
import oracle.bpm.components.Role;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.util.DefaultValue;

public class ProcessInstanceDebug
implements ProcessInstanceInterface {
    private Activity activity_d;
    private Time activityDeadline_d;
    private TreeMap<String, String> childrenInstanceIds_d = null;
    private Time creationTime_d;
    private String currentException_d = null;
    private String description_d;
    private int instId_d;
    private Participant nextParticipant_d = null;
    private int numberOfThreads_d;
    private InstanceId parentInstanceId_d = new InstanceId("id=0,cn=Process,ou=orgUnit,o=org", 0, 0);
    private HashMap<Integer, Integer> participantForRole = null;
    private int priority_d;
    private Time processDeadline_d;
    private String processId_d = "";
    private int processIn_d;
    private Time receptionTime_d = Time.now();
    private String result_d;
    private Activity sourceActivity_d;
    private int status_d;
    private boolean stickyParticipant = false;
    private int threadId_d;

    public ProcessInstanceDebug() {
        this.activityDeadline_d = this.receptionTime_d.addMinutes(20L);
        this.creationTime_d = this.receptionTime_d.addMinutes(-20L);
        this.description_d = CoreMsg.DUMMY_VALUE.toString();
        this.processDeadline_d = this.receptionTime_d.addMinutes(100L);
        this.activity_d = new Activity(new ActivityDebug());
        this.sourceActivity_d = new Activity(new ActivityDebug());
        this.childrenInstanceIds_d = new TreeMap();
    }

    @Override
    public Activity getActivityComponent() {
        return this.activity_d;
    }

    @Override
    public Time getActivityDeadline() {
        return this.activityDeadline_d;
    }

    @Override
    public ParticipantInterface getAuthor() {
        return Participant.getAutomaticParticipant().getParticipant();
    }

    @Override
    public final SortedMap<String, String> getChildrenInstanceIds() {
        return this.childrenInstanceIds_d;
    }

    @Override
    public Time getCreationTime() {
        return this.creationTime_d;
    }

    public void setCurrentException(String exception) {
        this.currentException_d = exception;
    }

    @Override
    public String getCurrentException() {
        return this.currentException_d;
    }

    @Override
    public void setDescription(String descr) {
        this.description_d = descr;
    }

    @Override
    public String getDescription() {
        return this.description_d;
    }

    @Override
    public String getGlobalInstanceId() {
        return "";
    }

    @Override
    public String getInstanceId() {
        return "";
    }

    @Override
    public int getInstanceIn() {
        return this.instId_d;
    }

    @Override
    public int get_SplitJoinIndex_() {
        return 0;
    }

    @Override
    public Interval getMinInstanceTimeout(Interval tout) {
        return tout;
    }

    @Override
    public void setNextParticipant(ParticipantInterface p) {
    }

    @Override
    public Participant getNextParticipantComponent() {
        return this.nextParticipant_d;
    }

    @Override
    public int getNumberOfThreads() {
        return this.numberOfThreads_d;
    }

    @Override
    public String getOrganization() {
        return null;
    }

    @Override
    public String getOrganizationalUnit() {
        return null;
    }

    @Override
    public final InstanceId getParentInstanceId() {
        return this.parentInstanceId_d;
    }

    @Override
    public void setParticipantForRole(Role role, Participant participant) {
        if (role == null || participant == null) {
            return;
        }
        if (this.participantForRole == null) {
            this.participantForRole = new HashMap();
        }
        Integer rolIn = role.getId();
        Integer participantIn = participant.getIn();
        this.participantForRole.put(rolIn, participantIn);
    }

    @Override
    public Participant getParticipantForRole(Role role) {
        return null;
    }

    @Override
    public void setPriority(int priority) {
        this.priority_d = priority;
    }

    @Override
    public int getPriority() {
        return this.priority_d;
    }

    @Override
    public void setProcessDeadline(Time d) {
        this.processDeadline_d = d;
    }

    @Override
    public Time getProcessDeadline() {
        return this.processDeadline_d;
    }

    @Override
    public String getProcessId() {
        return this.processId_d;
    }

    @Override
    public int getProcessIn() {
        return this.processIn_d;
    }

    @Override
    public Time getReceptionTime() {
        return this.receptionTime_d;
    }

    @Override
    public void setResult(String result) {
        this.result_d = result;
    }

    @Override
    public String getResult() {
        return this.result_d;
    }

    @Override
    public RoleInterface getRole() {
        return new RoleDebug();
    }

    @Override
    public Activity getSourceActivityComponent() {
        return this.sourceActivity_d;
    }

    @Override
    public void setStickyParticipant(boolean sticky) {
        this.stickyParticipant = sticky;
    }

    @Override
    public int getThreadIn() {
        return this.threadId_d;
    }

    @Override
    public int getUserStatus() {
        return this.status_d;
    }

    @Override
    public InstanceComponent cloneInstanceComponent() {
        return null;
    }

    @Override
    public DetachedFieldHandler createDetachedFieldHandler() {
        return new SimpleDetachedFieldHandler();
    }

    @Override
    public boolean hasStickyParticipant() {
        return this.stickyParticipant;
    }

    @Override
    public void resetInstanceComponent(byte[] instance) {
    }

    @Override
    public String getThreadParentId() {
        return "";
    }

    public Class<ProcessInstanceInterface> getRawClass() {
        return ProcessInstanceInterface.class;
    }

    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    @Exclude
    public static class SimpleDetachedFieldHandler
    implements DetachedFieldHandler {
        private Map<String, Object> variables = new TreeMap<String, Object>();

        @Override
        public void setDetachedField(String name, Object value) {
            this.variables.put(name, value);
        }

        @Override
        public Object getDetachedField(String name, Class<?> type) {
            Object value;
            if (!this.variables.containsKey(name)) {
                value = DefaultValue.forClass(type);
                this.variables.put(name, value);
            } else {
                value = this.variables.get(name);
            }
            return value;
        }
    }
}

