/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.debug.components;

import fuego.directory.DirectoryException;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.util.DirectoryEnvironment;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import oracle.bpm.compiler.debug.components.ProjectObjectDebug;
import oracle.bpm.compiler.debug.components.RoleDebug;
import oracle.bpm.components.Locale;
import oracle.bpm.components.ParticipantInterface;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.ParticipantAbsence;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.util.Base64;
import org.jetbrains.annotations.NotNull;

public class ParticipantDebug
implements ParticipantInterface {
    private boolean enabled = true;
    private Participant participant;
    private final Map<String, Map<Object, Object>> propertiesByApplication = new HashMap<String, Map<Object, Object>>();

    public ParticipantDebug() {
        this(new ParticipantImpl(null));
    }

    public ParticipantDebug(String participantId) {
    }

    private ParticipantDebug(Participant participant) {
        this.participant = participant;
    }

    public static ParticipantDebug create(Participant participant) {
        return new ParticipantDebug(participant);
    }

    @Override
    public String getActualId() {
        return this.participant.getId();
    }

    @Override
    public boolean isAutomatic() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.participant.getDisplayName();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.participant.isEnabled() && this.enabled;
    }

    @Override
    public String getId() {
        return this.participant.getId();
    }

    @Override
    public int getIn() {
        return -1;
    }

    @Override
    public Locale getLocale() {
        java.util.Locale locale = java.util.Locale.getDefault();
        return new Locale(locale.getLanguage(), locale.getCountry());
    }

    @Override
    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    @Override
    public String getMailAddress() {
        return this.participant.getMail();
    }

    @Override
    public String getTelephone() {
        return this.participant.getTelephone();
    }

    @Override
    public String getFirstName() {
        return this.participant.getFirstName();
    }

    @Override
    public String getLastName() {
        return this.participant.getLastName();
    }

    @Override
    public String getName() {
        return this.participant.getDisplayName();
    }

    @Override
    public String getOrganization() {
        return this.participant.getOrganization().getProject().getName();
    }

    @Override
    public String getOrganizationalUnit() {
        return this.participant.getOrganizationalUnit().getId();
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public boolean isPresent() {
        return this.participant.isEnabled();
    }

    @Override
    public List<RoleInterface> getRoles() {
        ArrayList<RoleInterface> roles = new ArrayList<RoleInterface>();
        Collection roleAssignment = this.participant.getRoleAssignments();
        for (RoleAssignment assignment : roleAssignment) {
            roles.add(new RoleDebug(assignment.getRole()));
        }
        return roles;
    }

    public boolean equals(Object obj) {
        return this.getName() != null && obj instanceof ParticipantInterface && this.getName().equals(((ParticipantInterface)obj).getName());
    }

    public int hashCode() {
        return System.identityHashCode(this.getName());
    }

    @Override
    public String retrieveEncryptedPropertyFor(String application, String name, String key) throws DirectoryException {
        String encryptedValue = (String)this.retrievePropertyInternal(application, name);
        String value = DirectoryEnvironment.encryptValue(key, Base64.decode(encryptedValue));
        if (!value.startsWith(key)) {
            if (Log.isDebugging()) {
                Log.logDebug("Invalid encryption key " + key + " for value " + value);
            }
            return null;
        }
        return value.substring(key.length());
    }

    @Override
    public Object retrieveObjectPropertyFor(String application, String name) throws DirectoryException {
        return this.retrievePropertyInternal(application, name);
    }

    @Override
    public String retrievePropertyFor(String application, String name) throws DirectoryException {
        return (String)this.retrievePropertyInternal(application, name);
    }

    @Override
    public void storeEncryptedPropertyFor(String application, String name, String value, String key) throws DirectoryException {
        String encryptedValue = DirectoryEnvironment.encryptValue(key, key + value);
        try {
            encryptedValue = Base64.encode(encryptedValue.getBytes(Literals.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw DirectoryRuntimeException.wrapException((Throwable)e);
        }
        this.storePropertyInternal(application, name, encryptedValue);
    }

    @Override
    public void storeObjectPropertyFor(String application, String name, Object value) throws Exception {
        this.storePropertyInternal(application, name, value);
    }

    @Override
    public void storePropertyFor(String application, String name, String value) throws DirectoryException {
        this.storePropertyInternal(application, name, value);
    }

    public Class getRawClass() {
        return ParticipantInterface.class;
    }

    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    private Object retrievePropertyInternal(String application, String name) {
        Map<Object, Object> propertiesByName = this.propertiesByApplication.get(application);
        if (propertiesByName != null) {
            return propertiesByName.get(name);
        }
        return null;
    }

    private void storePropertyInternal(String application, String name, Object value) {
        Map<Object, Object> propertiesByName = this.propertiesByApplication.get(application);
        if (propertiesByName == null) {
            propertiesByName = new HashMap<Object, Object>();
            this.propertiesByApplication.put(application, propertiesByName);
        }
        propertiesByName.put(name, value);
    }

    private static class ParticipantImpl
    extends ProjectObjectDebug
    implements Participant {
        private final Organization organization;
        private Path path;

        ParticipantImpl(Organization organization) {
            this.organization = organization;
            this.path = Path.PARTICIPANT;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @NotNull
        public Participant.Mutable asMutable() {
            throw new UnsupportedOperationException();
        }

        public boolean receivesMail() {
            return false;
        }

        public String getDisplayName() {
            return "Debug Participant";
        }

        public String getEmployeeId() {
            return "Debug Participant";
        }

        public String getFax() {
            return "";
        }

        public String getFirstName() {
            return "Debug";
        }

        public String getLastName() {
            return "Participant";
        }

        public String getMail() {
            return "";
        }

        public String getManager() {
            return null;
        }

        public OrganizationalUnit getOrganizationalUnit() {
            return this.organization.getRootOrganizationalUnit();
        }

        public String getTelephone() {
            return null;
        }

        public boolean isAdministrator() {
            return false;
        }

        public boolean isEnabled() {
            return true;
        }

        public byte[] getPhoto() {
            return new byte[0];
        }

        public Collection<ParticipantAbsence> getAbsencePeriods() {
            return null;
        }

        public Collection<ParticipantAbsence> getReplacementPeriods() {
            return null;
        }

        public void removeRole(Role role) {
        }

        public Role findAssignedRole(String roleId) {
            return null;
        }

        public Group findAssignedGroup(String groupId) {
            return null;
        }

        public void removeGroup(Group group) {
        }

        public Collection<RoleAssignment> getRoleAssignments() {
            return new ArrayList<RoleAssignment>();
        }

        public Organization getOrganization() {
            return this.organization;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public ProjectObjectType getProjectObjectType() {
            ProjectObjectType projectObjectType = ProjectObjectType.PARTICIPANT;
            if (projectObjectType == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/ParticipantDebug$ParticipantImpl.getProjectObjectType must not return null");
            }
            return projectObjectType;
        }

        public Collection<GroupAssignment> getGroupAssignments() {
            return new ArrayList<GroupAssignment>();
        }

        public void setPath(Path aPath) {
            this.path = aPath;
        }

        public java.util.Locale getLocale() {
            return null;
        }

        public TimeZone getTimeZone() {
            return null;
        }

        public double getCost() {
            return 0.0;
        }

        public int getEfficiency() {
            return 0;
        }

        public int compareTo(Participant participant) {
            return this.getId().compareTo(participant.getId());
        }

        public Class getRawClass() {
            return Participant.class;
        }

        public boolean is(Class<? extends ProjectObject> clazz) {
            return clazz.isAssignableFrom(this.getRawClass());
        }

        public void setId(String id) {
        }

        public void setName(String id) {
        }

        public void setDefault(boolean isDefault) {
        }

        public void delete() throws ProjectException {
        }

        public String getName() {
            return this.getId();
        }
    }
}

