/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.debug.components;

import fuego.directory.DirectoryException;
import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.components.OrganizationalGroupInterface;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.RoleAssignment;

public class OrganizationalGroupDebug
implements OrganizationalGroupInterface {
    private ArrayList<String> addedAssignments = new ArrayList();
    private ArrayList<String> addedParticipants = new ArrayList();
    private ArrayList<String> assignedGroups = new ArrayList();
    private String[] assignedParts;
    private boolean enabled = true;
    private Group group;
    private ArrayList<String> removedAssignments = new ArrayList();
    private ArrayList<String> removedGroups = new ArrayList();
    private ArrayList<String> removedParticipants = new ArrayList();

    public OrganizationalGroupDebug(Group group) {
        this.group = group;
    }

    @Override
    public void setAssignedGroups(String[] groups) {
        this.assignedGroups.clear();
        for (String groupId : groups) {
            this.assignedGroups.add(groupId);
        }
        this.removedGroups.clear();
    }

    @Override
    public void setAssignedParticipants(String[] participants) {
        this.assignedParts = participants;
        this.removedParticipants.clear();
        this.addedParticipants.clear();
    }

    @Override
    public String[] getAssignedParticipants() {
        ArrayList<String> assignedParticipants = new ArrayList<String>();
        assignedParticipants.addAll(this.addedParticipants);
        if (this.assignedParts != null) {
            for (String partId : this.assignedParts) {
                if (this.removedParticipants.contains(partId)) continue;
                assignedParticipants.add(partId);
            }
        } else {
            Collection assignedObjects = this.group.getAssignedObjects();
            for (GroupAssignment groupAssignment : assignedObjects) {
                AssignableToGroup assignedObject = groupAssignment.getAssignedObject();
                if (!(assignedObject instanceof Participant) || this.removedParticipants.contains(assignedObject.getId())) continue;
                assignedParticipants.add(assignedObject.getId());
            }
        }
        return assignedParticipants.toArray(new String[0]);
    }

    @Override
    public String getDescription() {
        return this.group.getDescription();
    }

    @Override
    public String getDisplayName() {
        return this.group.getId();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.group.isEnabled() && this.enabled;
    }

    @Override
    public String getId() {
        return this.group.getId();
    }

    @Override
    public String getName() {
        return this.group.getId();
    }

    @Override
    public String[] getRolesAssignment() throws DirectoryException {
        Collection roleAssignment = this.group.getRoleAssignments();
        ArrayList<String> roles = new ArrayList<String>();
        roles.addAll(this.addedAssignments);
        for (RoleAssignment assignment : roleAssignment) {
            if (this.removedAssignments.contains(assignment.getRole().getId() + "-" + assignment.getParametricValue())) continue;
            roles.add(assignment.getRole().getId());
        }
        return roles.toArray(new String[0]);
    }

    @Override
    public void addGroup(String groupId) {
        this.removedGroups.remove(groupId);
        this.assignedGroups.add(groupId);
    }

    @Override
    public void addParticipant(String participant) {
        this.removedParticipants.remove(participant);
        this.addedParticipants.add(participant);
    }

    @Override
    public void addRoleAssignment(String role, String parametricValue, int permissions) {
        String id = role + "-" + parametricValue;
        this.addedAssignments.add(id);
        this.removedAssignments.remove(id);
    }

    @Override
    public boolean hasGroupAssigned(String groupId) {
        if (this.assignedGroups.contains(groupId)) {
            return true;
        }
        if (this.removedGroups.contains(groupId)) {
            return false;
        }
        Collection groupAssignments = this.group.getGroupAssignments();
        for (GroupAssignment groupAssignment : groupAssignments) {
            if (!groupAssignment.getGroup().getId().equals(groupId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasParticipantAssigned(String participant) {
        if (this.addedParticipants.contains(participant)) {
            return true;
        }
        if (this.removedParticipants.contains(participant)) {
            return false;
        }
        Collection assignedObjects = this.group.getAssignedObjects();
        for (GroupAssignment groupAssignment : assignedObjects) {
            if (!(groupAssignment.getAssignedObject() instanceof Participant) || !groupAssignment.getAssignedObject().getId().equals(participant)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRoleAssigned(String role) {
        return this.hasRoleAssigned(role, null);
    }

    @Override
    public boolean hasRoleAssigned(String role, String parametricValue) {
        String id = role + "-" + parametricValue;
        if (this.addedAssignments.contains(id)) {
            return true;
        }
        if (this.removedAssignments.contains(id)) {
            return false;
        }
        Collection roleAssignment = this.group.getRoleAssignments();
        for (RoleAssignment assignment : roleAssignment) {
            if (!assignment.getRole().getId().equals(role) || parametricValue != null && !parametricValue.equals(assignment.getParametricValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeGroup(String groupId) {
        this.removedGroups.add(groupId);
        this.assignedGroups.add(groupId);
    }

    @Override
    public void removeParticipant(String participant) {
        this.removedParticipants.add(participant);
        this.addedParticipants.remove(participant);
    }

    @Override
    public void removeRoleAssignment(String role, String parametricValue) {
        String o = role + "-" + parametricValue;
        this.removedAssignments.add(o);
        this.addedAssignments.remove(o);
    }
}

