/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler.debug.components;

import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.compiler.debug.components.ProcessInterfaceDebug;
import oracle.bpm.compiler.debug.components.ProjectObjectDebug;
import oracle.bpm.compiler.debug.components.RoleDebug;
import oracle.bpm.components.ActivityInterface;
import oracle.bpm.components.ActivityRetryThrowable;
import oracle.bpm.components.ProcessInterface;
import oracle.bpm.components.RoleInterface;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ActivityGenerateEvents;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.ManualTask;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.ScriptTask;
import oracle.bpm.project.model.processes.SendTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.activities.AbortableFeature;
import oracle.bpm.project.model.processes.activities.ActivityLevelFeature;
import oracle.bpm.project.model.processes.activities.AutocompleteFeature;
import oracle.bpm.project.model.processes.activities.HasInstanceAccessFeature;
import oracle.bpm.project.model.processes.activities.SuspendableFeature;
import oracle.bpm.project.model.processes.activities.UserSelectsTransitionFeature;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityDebug
implements ActivityInterface {
    private FlowNode node;

    public ActivityDebug() {
        this.node = new ActivityImpl();
    }

    public ActivityDebug(String processName, String activityName) {
        if (activityName == null || "".equals(activityName)) {
            this.node = new ActivityImpl();
        } else {
            Object project = null;
            Process process = project.findProcess(processName);
            assert (process != null);
            this.node = process.findNode(activityName);
        }
    }

    public static ActivityInterface create(FlowNode node) {
        ActivityDebug activityDebug = new ActivityDebug();
        activityDebug.node = node;
        return activityDebug;
    }

    @Override
    public boolean isAbortable() {
        return ((AbortableFeature)this.node.getFeature(AbortableFeature.class)).getValue();
    }

    @Override
    public boolean isAutoComplete() {
        return ((AutocompleteFeature)this.node.getFeature(AutocompleteFeature.class)).getValue();
    }

    @Override
    public boolean isAutomatic() {
        return !ModelUtils.isAnyInteractive((FlowNode)this.node);
    }

    @Override
    public String getCommonName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return this.node.getDefaultDescription();
    }

    @Override
    public String getDocumentation() {
        return this.node.getDocumentationMap().getString();
    }

    @Override
    public boolean isGlobalInstance() {
        return ((HasInstanceAccessFeature)this.node.getFeature(HasInstanceAccessFeature.class)).getValue();
    }

    @Override
    public ActivityInterface getJoinInterface() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.node.getDefaultLabel();
    }

    @Override
    public String getLabel(Locale locale) {
        return this.node.getLabel(locale);
    }

    @Override
    public String getLevel() {
        return ((ActivityLevelFeature)this.node.getFeature(ActivityLevelFeature.class)).getValue();
    }

    @Override
    public String getName() {
        return this.node.getId();
    }

    @Override
    public String getOrganization() {
        return this.node.getProject().getName();
    }

    public oracle.bpm.components.Process getProcess() {
        return new oracle.bpm.components.Process();
    }

    @Override
    public ProcessInterface getProcessInterface() {
        return new ProcessInterfaceDebug(this.node.getProcess());
    }

    @Override
    public RoleInterface getRoleInterface() {
        Lane lane = this.node.getLane();
        if (lane != null) {
            return new RoleDebug(this.node.getProject().getOrganization().findRoleById(lane.getRole()));
        }
        return new RoleDebug();
    }

    @Override
    public boolean isSuspendable() {
        return ((SuspendableFeature)this.node.getFeature(SuspendableFeature.class)).getValue();
    }

    @Override
    public boolean getUserSelectsTransition() {
        return ((UserSelectsTransitionFeature)this.node.getFeature(UserSelectsTransitionFeature.class)).getValue();
    }

    @Override
    public boolean hasMultipleTransitions() {
        return false;
    }

    public void retry(Interval interval) throws ActivityRetryThrowable {
        throw new ActivityRetryThrowable(interval);
    }

    public void retry(Time time) throws ActivityRetryThrowable {
        throw new ActivityRetryThrowable(time);
    }

    public Class getRawClass() {
        return ActivityInterface.class;
    }

    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    private static class ActivityImpl
    extends ProjectObjectDebug
    implements FlowNode {
        private ActivityImpl() {
        }

        public boolean isExclusiveGateway() {
            return false;
        }

        public boolean isInclusiveGateway() {
            return false;
        }

        public boolean isParallelGateway() {
            return false;
        }

        public NodeContainer getParentObject() {
            return null;
        }

        public boolean isEventBasedGateway() {
            return false;
        }

        public GatewayDirection getDirection() {
            return null;
        }

        public ParallelGateway toParallel() {
            return null;
        }

        public ExclusiveGateway toExclusive() {
            return null;
        }

        public InclusiveGateway toInclusive() {
            return null;
        }

        public EventBasedGateway toEventBased() {
            return null;
        }

        public void setDirection(GatewayDirection gatewayDirection) {
        }

        public void setMergingGateway(Gateway gateway) {
        }

        public Gateway getMergingGateway() {
            return null;
        }

        public Sequence<SequenceFlow> getOutgoingSequenceFlows() {
            return null;
        }

        public Sequence<SequenceFlow> getIncomingSequenceFlows() {
            return null;
        }

        public Sequence<ConditionalFlow> getOutgoingConditionalFlows() {
            return null;
        }

        public Lane getLane() {
            return null;
        }

        public boolean isActivity() {
            return false;
        }

        public boolean isEvent() {
            return false;
        }

        public boolean isGateway() {
            return false;
        }

        public boolean isConversationMember() {
            return false;
        }

        public boolean isProcessCommunicationMember() {
            return false;
        }

        public boolean isLoggable() {
            return false;
        }

        public void setMergeGateway(Gateway gateway) {
        }

        public Gateway getMergeGateway() {
            return null;
        }

        public <T extends FlowNode> T asAnyNode(Class<T> clazz) {
            return null;
        }

        @Nullable
        public Subprocess getSubprocess() {
            return null;
        }

        public void setX(int x) {
        }

        public void setY(int y) {
        }

        public void setHeight(int height) {
        }

        public void setWidth(int width) {
        }

        public void setLane(Lane lane) {
        }

        public FlowNode copy() {
            return null;
        }

        public void applyFrom(FlowNode flowNode) throws ProjectException {
        }

        public ActivityGenerateEvents getGenerateEvents() {
            return null;
        }

        public void setGenerateEvents(ActivityGenerateEvents generateEvents) {
        }

        public Sequence<SequenceFlow> getOutgoingTransitions() {
            return null;
        }

        public Features getFeatures() {
            return null;
        }

        public <T extends Feature> T getFeature(Class<T> clazz) {
            return null;
        }

        public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
            return null;
        }

        public Activity toActivity() {
            return null;
        }

        @Nullable
        public <T extends Activity> T asActivity(Class<T> clazz) {
            return null;
        }

        public Class<? extends Activity> getActivityClass() {
            return null;
        }

        public BpmnType getBpmnType() {
            return null;
        }

        public Sequence<BoundaryEvent> getActivityBoundaryEvents() {
            return null;
        }

        public boolean isSubprocess() {
            return false;
        }

        public boolean isAutomatic() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean isUserTask() {
            return false;
        }

        public boolean isServiceTask() {
            return false;
        }

        public boolean isSubProcess() {
            return false;
        }

        public boolean isScriptTask() {
            return false;
        }

        public boolean isManualTask() {
            return false;
        }

        public boolean isBusinessRuleTask() {
            return false;
        }

        public boolean isCallActivity() {
            return false;
        }

        public boolean isReceiveTask() {
            return false;
        }

        public boolean isSendTask() {
            return false;
        }

        public UserTask toUserTask() {
            return null;
        }

        public ServiceTask toServiceTask() {
            return null;
        }

        public ReceiveTask toReceiveTask() {
            return null;
        }

        public BusinessRuleTask toBusinessRuleTask() {
            return null;
        }

        public ManualTask toManualTask() {
            return null;
        }

        public SendTask toSendTask() {
            return null;
        }

        public ScriptTask toScriptTask() {
            return null;
        }

        public Subprocess toSubprocess() {
            return null;
        }

        public CallActivity toCallActivity() {
            return null;
        }

        public LocaleStringMap getLabelMap() {
            LocaleStringMap localeStringMap = LocaleStringMap.create();
            localeStringMap.put(Locale.getDefault(), "Debug Activity");
            return localeStringMap;
        }

        public String getDefaultLabel() {
            return this.getLabelMap().getString();
        }

        public String getLabel(Locale locale) {
            return this.getLabelMap().getString(locale);
        }

        public LocaleStringMap getDescriptionMap() {
            LocaleStringMap localeStringMap = LocaleStringMap.create();
            localeStringMap.put(Locale.getDefault(), "Description Debug Activity");
            return localeStringMap;
        }

        public String getDefaultDescription() {
            return this.getDescriptionMap().getString();
        }

        public LocaleStringMap getDocumentationMap() {
            return LocaleStringMap.create();
        }

        public LocaleStringMap getUseCaseDocumentationMap() {
            return LocaleStringMap.create();
        }

        public Localizable.Mutable asMutableLocalizable() {
            return null;
        }

        public int getWidth() {
            return 0;
        }

        public int getHeight() {
            return 0;
        }

        public int getX() {
            return 0;
        }

        public int getY() {
            return 0;
        }

        public Point getLocation() {
            return Point.ORIGIN;
        }

        public void setLocation(Point point) {
        }

        public boolean isAdjustable() {
            return false;
        }

        public String getName() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public ProjectObjectType getProjectObjectType() {
            ProjectObjectType projectObjectType = ProjectObjectType.ACTIVITY;
            if (projectObjectType == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.getProjectObjectType must not return null");
            }
            return projectObjectType;
        }

        public Process getProcess() {
            return null;
        }

        public boolean isGroupEndActivity() {
            return false;
        }

        public boolean isGroupBeginActivity() {
            return false;
        }

        public EventTriggerType getEventTriggerType() {
            return null;
        }

        public boolean isCatchEvent() {
            return false;
        }

        public boolean isThrowEvent() {
            return false;
        }

        public boolean isStart() {
            return false;
        }

        public boolean isIntermediate() {
            return false;
        }

        public boolean isEnd() {
            return false;
        }

        public CatchEvent asCatchEvent() {
            return null;
        }

        public ThrowEvent asThrowEvent() {
            return null;
        }

        public ThrowEvent toThrow(EventTriggerType triggerType) {
            return null;
        }

        public CatchEvent toCatch(EventTriggerType triggerType) {
            return null;
        }

        public BoundaryEvent toBoundary(EventTriggerType triggerType, Activity relatedActivity) {
            return null;
        }

        public void setEventTriggerType(EventTriggerType eventTriggerType) {
        }

        public EventDefinition getEventDefinition() {
            return null;
        }

        @Nullable
        public <T extends Gateway> T asGateway(Class<T> clazz) {
            return null;
        }

        public void setId(String id) {
        }

        public void setModified(boolean value) {
        }

        public void setReadOnly(boolean value) {
        }

        public void setDefault(boolean isDefault) {
        }

        public void delete() throws ProjectException {
        }

        public void setLabelMap(LocaleStringMap label) {
        }

        public void setDefaultLabel(String label) {
        }

        public void setDefaultDescription(String description) {
        }

        public void setDescription(LocaleStringMap map) {
        }

        public void setDocumentation(ModificationAwareLocaleStringMap map) {
        }

        public void setUseCaseDocumentation(ModificationAwareLocaleStringMap map) {
        }

        public Class getRawClass() {
            return FlowNode.class;
        }

        public boolean is(Class<? extends ProjectObject> clazz) {
            return clazz.isAssignableFrom(this.getRawClass());
        }

        public void addChild(ProjectObject child) throws ProjectException {
        }

        public void addChild(ProjectObject child, int position) throws ProjectException {
        }

        public void clear() {
        }

        public int indexOf(ProjectObject projectObject) {
            return -1;
        }

        public int getChildCount() {
            return 0;
        }

        public <T extends ProjectObject> T findChild(Class<T> type, String id) {
            return null;
        }

        public Comparator<ProjectObject> getChildComparator() {
            return null;
        }

        public boolean contains(ProjectObject child) {
            return false;
        }

        public <E extends ProjectObject> E findDescendant(Class<E> type, String id) {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Sequence<? extends ProjectObject> getChildren() {
            Sequence sequence = CollectionUtils.emptySequence();
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.getChildren must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public <E extends ProjectObject> Sequence<E> getChildrenByType(Class<E> type) {
            Sequence sequence = CollectionUtils.emptySequence();
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.getChildrenByType must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public <E extends ProjectObject> Sequence<E> getDescendants(Class<E> type) {
            Sequence sequence = CollectionUtils.emptySequence();
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.getDescendants must not return null");
            }
            return sequence;
        }

        public void removeChild(ProjectObject child) throws ProjectException {
        }

        public void moveChild(ProjectObject child, int newPosition) throws ProjectException {
        }

        public void replaceChild(ProjectObject oldProjectObject, ProjectObject newProjectObject) throws ProjectException {
        }

        public ProjectObject getChildAt(int index) {
            return null;
        }

        @NotNull
        public Map<String, String> getAnnotations(boolean visible) {
            if (null == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.getAnnotations must not return null");
            }
            return null;
        }

        public Sequence<DataDeclaration> getDeclarations() {
            return CollectionUtils.emptySequence();
        }

        public Sequence<DataDeclaration> getLocalDeclarations() {
            return CollectionUtils.emptySequence();
        }

        public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
            return CollectionUtils.emptySequence();
        }

        public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
            return CollectionUtils.emptySequence();
        }

        public DataDeclarationContainer getParentScope() {
            return null;
        }

        public String getAnnotationValue(@NotNull String key, boolean visible) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.getAnnotationValue must not be null");
            }
            return this.getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
        }

        public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.addAnnotation must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.addAnnotation must not be null");
            }
        }

        public void removeAnnotation(@NotNull String key, boolean visible) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/compiler/debug/components/ActivityDebug$ActivityImpl.removeAnnotation must not be null");
            }
        }

        public DataDeclaration findLocalDeclaration(String name) {
            return null;
        }

        public DataDeclaration findDeclaration(String name) {
            return null;
        }

        public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
            return null;
        }

        public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
            return null;
        }

        public Sequence<DataDeclaration> findDeclarationPath(String path) {
            return CollectionUtils.emptySequence();
        }

        public boolean isMutableDeclarationContainer() {
            return false;
        }

        public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
            return null;
        }

        public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
            return null;
        }

        public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        }

        public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        }

        public void clearDeclarations() throws ProjectException {
        }

        public boolean isDraftable() {
            return false;
        }

        public boolean isDataAssociationsEnabled() {
            return false;
        }

        public boolean isMessageHeadersEnabled() {
            return false;
        }

        public boolean isServicePropertiesEnabled() {
            return false;
        }

        public boolean isConversational() {
            return false;
        }
    }
}

