/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import fuego.directory.DirEngine;
import fuego.directory.DirEngineConfiguration;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.standalone.StandaloneBAMPreferences;
import fuego.prefs.engine.standalone.StandaloneLogPreferences;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.data.EngineAccessInfo;
import oracle.bpm.data.Frequency;
import oracle.bpm.data.PresentableProperties;
import oracle.bpm.data.ServerLocation;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.xml.DeserializationException;
import oracle.bpm.xml.Serializer;
import oracle.bpm.xml.XMLDeserializer;
import oracle.bpm.xml.XMLSerializer;
import oracle.bpm.xml.XMLSerializerWriter;

public class EngineProperties
implements Cloneable,
PresentableProperties {
    public List<EngineAccessInfo> accessInfo;
    public String administratorMail;
    public String archivingConfiguration;
    public Boolean archivingEnabled;
    public Boolean autoStartable;
    public String bamSnapshotDisposing;
    public String bamSnapshotResolution;
    public int cacheSize = -1;
    public String configuration;
    public String creationConfiguration;
    public boolean[] customizedFields;
    public int directoryPollingInterval = -1;
    public int disposeInstanceCaducity = -1;
    public int disposeLatency = -1;
    public Time disposerStartingTime;
    public int dueItemsPollingInterval = -1;
    public int executionThreadPoolSize = -1;
    public String groupMCastAddr;
    public int httpThreadCount = -1;
    public int initPoolSize = -1;
    public int instanceMaxSize = -1;
    public int instanceRetrievalSize = -1;
    public int ipcServiceEnabled = -1;
    public int ipcServicePort = -1;
    public int itemExecutionTimeout = -1;
    public HashMap JDBCdriverProperties;
    public String jmsQueue;
    public String jmsQueueFactory;
    public String jmsTopic;
    public String jmsTopicFactory;
    public int jvmHeapMax = -1;
    public List<ServerLocation> locations;
    public int logBackupFiles = -1;
    public String logDefaultClientSeverities;
    public int logDefaultDetailLevel = -1;
    public String logDefaultSeverities;
    public String logMailSeverities;
    public int logMaxSize = -1;
    public String mailServerName;
    public int maxCILTimeout = -1;
    public int maxIPCIncomingConnections = -1;
    public int maxPoolSize = -1;
    public int notifyThreadLatency = -1;
    public int notifyThreadPriority = -1;
    public String protocolStackconfiguration;
    public int requestQueueSize = -1;
    public int requestQueueTimeout = -1;
    public int retryInterval = -1;
    public int retryTimes = -1;
    public int rogueThreadsLimit = -1;
    public String roleMCastAddr;
    public String runtimeConfiguration;
    public String serverId;
    public int snmpAgentPort = -1;
    public String snmpManagerHost;
    public int snmpManagerPort = -1;
    public int snmpServiceEnabled = -1;
    public String startArguments;
    public String startJavaArguments;
    public String templateId;
    public int toDoQueueSize = -1;
    public int toDoThreadCount = -1;
    public int toDoThreadPriority = -1;
    public Boolean traceComponents;
    public String webBUIServer;
    public String webServicesURL;
    public int writeEvents = -1;
    private static final String NONE = "None";
    private static final String WARNING = "Warning";
    private static final String SEVERE = "Severe";
    private static final String FATAL = "Fatal";
    private static final String INFO = "Info";
    private static final String DEBUG = "Debug";
    private static final String NO = "NO";
    private static final String YES = "YES";
    public static Msg[] writeEventValues = new Msg[]{DirectoryMsg.DEPENDS_ON_PROCESS, DirectoryMsg.NEVER, DirectoryMsg.ALWAYS};
    private static String localhost;
    public static ServerLocation locations_ELEMENT_;
    public static EngineAccessInfo accessInfo_ELEMENT_;
    public static final int DISPOSE_LATENCY_ID = 0;
    public static final int DISPOSE_INSTANCE_CADUCITY_ID = 1;
    public static final int DIRECTORY_POLLING_INTERVAL_ID = 2;
    public static final int CACHE_SIZE_ID = 3;
    public static final int INSTANCE_MAX_SIZE_ID = 4;
    public static final int JVM_HEAP_MAX_ID = 5;
    public static final int WRITE_EVENTS_ID = 6;
    public static final int EXECUTION_THREAD_POOL_SIZE_ID = 7;
    public static final int MAX_CIL_TIMEOUT_ID = 8;
    public static final int MAIL_SERVER_NAME_ID = 9;
    public static final int ADMINISTRATOR_MAIL_ID = 10;
    public static final int WEB_BUI_SERVER_ID = 11;
    public static final int WEB_SERVICES_URL_ID = 12;
    public static final int HTTP_PROXY_ID = 13;
    public static final int LOG_DEFAULT_DETAIL_LEVEL_ID = 14;
    public static final int LOG_MAX_SIZE_ID = 15;
    public static final int LOG_BACKUP_FILES_ID = 16;
    public static final int LOG_DEFAULT_SEVERITIES_ID = 17;
    public static final int LOG_DEFAULT_CLIENT_SEVERITIES_ID = 18;
    public static final int LOG_MAIL_SEVERITIES_ID = 19;
    public static final int NOTIFY_THREAD_LATENCY_ID = 20;
    public static final int NOTIFY_THREAD_PRIORITY_ID = 21;
    public static final int INSTANCE_RETRIEVAL_SIZE_ID = 22;
    public static final int RETRY_INTERVAL_ID = 23;
    public static final int RETRY_TIMES_ID = 24;
    public static final int TO_DO_QUEUE_SIZE_ID = 25;
    public static final int TO_DO_THREAD_COUNT_ID = 26;
    public static final int TO_DO_THREAD_PRIORITY_ID = 27;
    public static final int ITEM_EXECUTION_TIMEOUT_ID = 28;
    public static final int IPC_SERVICE_ENABLED_ID = 29;
    public static final int IPC_SERVICE_PORT_ID = 30;
    public static final int INIT_POOL_SIZE_ID = 31;
    public static final int MAX_POOL_SIZE_ID = 32;
    public static final int SNMP_AGENT_PORT_ID = 33;
    public static final int SNMP_MANAGER_HOST_ID = 34;
    public static final int SNMP_MANAGER_PORT_ID = 35;
    public static final int SNMP_SERVICE_ENABLED_ID = 36;
    public static final int MAX_IPC_INCOMING_CONNECTIONS_ID = 37;
    public static final int ARCHIVING_ENABLED_ID = 38;
    public static final int DISPOSER_STARTING_TIME_ID = 39;
    public static final int ARCHIVING_CONFIGURATION_ID = 40;
    public static final int BAM_SNAPSHOT_RESOLUTION_ID = 41;
    public static final int BAM_SNAPSHOT_DISPOSER_ID = 42;
    public static final int REQUEST_QUEUE_SIZE_ID = 43;
    public static final int REQUEST_QUEUE_TIMEOUT_ID = 44;
    public static final int ROGUE_THREADS_LIMIT_ID = 45;
    public static final int HTTP_THREAD_COUNT_ID = 46;
    public static final int TRACE_COMPONENTS_ID = 47;
    public static final int AUTOSTARTABLE_ID = 48;
    public static final int START_ARGUMENTS_ID = 49;
    public static final int START_JAVA_ARGUMENTS_ID = 50;
    public static final int JMS_QUEUE_ID = 51;
    public static final int PROTOCOL_STACK_CONFIGURATION_ID = 52;
    public static final int DUE_ITEMS_POLLING_INTERVAL_ID = 55;
    public static final int JMS_TOPIC_ID = 56;
    public static final int JMS_QUEUE_FACTORY_ID = 57;
    public static final int JMS_TOPIC_FACTORY_ID = 58;
    public static final int MAX_WEB_SERVICE_SESSION_TIMEOUT_ID = 59;
    public static final int FIELD_COUNT = 60;
    public static final int DB_INIT_POOLSIZE_DEF = 10;
    public static final int DB_MAX_POOLSIZE_DEF = 30;
    public static final int CACHESIZE_DEF = 5000;
    public static final int MAX_INSTANCESIZE_DEF = 16;
    public static final int MAX_JVMHEAPMAX_DEF = 256;
    public static final int MAX_INSTANCE_RETRIEVAL_SIZE_DEF = 1000;
    public static final int RETRY_INTERVAL_DEF = 600;
    public static final int RETRY_TIMES_DEF = 3;
    public static final int TODO_THREAD_PRIORITY_DEF = 5;
    public static final int NOTIFY_THREAD_PRIORITY_DEF = 1;
    public static final int NOTIFY_THREAD_LATENCY_DEF = 15;
    public static final int TODO_THREAD_COUNT_DEF = 5;
    public static final int TODO_QUEUE_SIZE_DEF = 1000;
    public static final String MAIL_SERVER_DEF = "smtp";
    public static final String ADM_MAIL_DEF = "admin@example.com";
    public static final String WEB_BUI_SERVER_DEF = "http://$LOCALHOST$:9595/portal";
    public static final String JMS_QUEUE_DEF = "queue/ToDoQueue";
    public static final String JMS_TOPIC_DEF = "topic/EngineNews";
    public static final String JMS_QUEUE_FACTORY_DEF = "XAConnectionFactory";
    public static final String JMS_TOPIC_FACTORY_DEF = "XATopicConnectionFactory";
    public static final String PROTOCOL_STACK_CONFIGURATION_DEF = "UDP(mcast_addr=224.8.8.8;mcast_port=45566)";
    public static final String LOG_DEFAULT_SEVERITIES_DEF;
    public static final String LOG_DEFAULT_CLIENT_SEVERITIES_DEF;
    public static final String LOG_MAIL_SEVERITIES_DEF;
    public static final int LOG_DEFAULT_FILE_SIZE_DEF = 2000;
    public static final int LOG_DEFAULT_BACKUP_FILES_DEF = 5;
    public static final int LOG_DEFAULT_DETAIL_LEVEL_DEF = 1;
    public static final int DISPOSE_LATENCY_DEF = 2;
    public static final int DISPOSE_INSTANCE_CADUCITY_DEF = 15;
    public static final boolean DISPOSE_PARTICIPANTS_DEF = true;
    public static final int DISPOSE_PARTICIPANT_CADUCITY_DEF = 30;
    public static final int ITEM_EXEC_TO_DEF = 720;
    public static final int EXECUTION_THREAD_POOL_SIZE_DEF = 50;
    public static final int MAX_CIL_TIMEOUT = 30;
    public static final int DIRECTORY_POLLING_INTERVAL = 1;
    public static final int DUE_ITEMS_POLLING_INTERVAL = 60;
    public static final int IPC_SERVICE_PORT_DEF = 54350;
    public static final int MAX_IPC_INCOMING_CONNECTIONS_DEF = 5;
    public static final String WEB_SERVICES_URL = "http://$LOCALHOST$:9595/fws/servlet/Deploy";
    public static final int SNMP_AGENT_PORT_DEF = 161;
    public static final String SNMP_MANAGER_HOST_DEF = "$LOCALHOST$";
    public static final int SNMP_MANAGER_PORT_DEF = 162;
    public static final boolean ARCHIVING_ENABLED_DEF = false;
    public static final String ENGINE_ENCODING;
    public static final Frequency BAM_SNAPSHOT_RESOLUTION_DEF;
    public static final Frequency BAM_SNAPSHOT_DISPOSER_DEF;
    public static final int REQUEST_QUEUE_SIZE_DEF = 300;
    public static final int REQUEST_QUEUE_TIMEOUT_DEF = 5;
    public static final int ROGUE_THREADS_LIMIT_DEF = 100;
    public static final int HTTP_THREAD_COUNT_DEF = 5;
    public static final String TEMPLATE_EXPRESS_INTERACTIVE = "Interactive";
    public static final String TEMPLATE_EXPRESS_AUTOMATIC = "Automatic";
    public static final String TEMPLATE_EXPRESS_MIXED = "Mixed";

    public EngineProperties() {
    }

    private EngineProperties(String engineId, String configuration) {
        this.serverId = engineId;
        this.configuration = configuration;
        this.customizedFields = new boolean[60];
        this.clearCustomizations();
    }

    public static StringList getAvailableTemplates() {
        return StringList.create(TEMPLATE_EXPRESS_INTERACTIVE, TEMPLATE_EXPRESS_AUTOMATIC, TEMPLATE_EXPRESS_MIXED);
    }

    public static EngineProperties doImport(InputStream istr) throws DeserializationException {
        return EngineProperties.doImport(istr, true);
    }

    public static String updateURL(String url) {
        if (!url.startsWith("http://")) {
            return url;
        }
        int beginIndex = "http://".length();
        int endIndex = url.lastIndexOf(":");
        if (endIndex < beginIndex) {
            endIndex = url.indexOf("/", beginIndex);
        }
        if (endIndex < beginIndex) {
            return "http://" + EngineProperties.getHostName(url.substring(beginIndex));
        }
        return "http://" + EngineProperties.getHostName(url.substring(beginIndex, endIndex)) + url.substring(endIndex);
    }

    public static EngineProperties load(String serverId, String configuration, DirectorySession session) throws DirectoryException {
        DirEngineConfiguration engineConf = DirEngineConfiguration.fetch(session, configuration, serverId);
        if (engineConf == null) {
            return null;
        }
        String p = engineConf.getProperties();
        try {
            ByteArrayInputStream istr = new ByteArrayInputStream(p.getBytes(ENGINE_ENCODING));
            return EngineProperties.doImport(istr);
        }
        catch (DeserializationException de) {
            Log.logSevere(de);
            throw new RuntimeExceptionShell(de);
        }
        catch (UnsupportedEncodingException uee) {
            Log.logSevere(uee);
            throw new RuntimeExceptionShell(uee);
        }
    }

    public void setAdministratorMail(String administratorMail) {
        this.administratorMail = administratorMail;
        this.setCustomizationStatus(10, true);
    }

    public String getAdministratorMail() {
        if (this.administratorMail == null) {
            this.setAdministratorMail("");
        }
        return this.administratorMail;
    }

    public void setArchivingConfiguration(String archivingConfiguration) {
        this.archivingConfiguration = archivingConfiguration;
        this.setCustomizationStatus(40, true);
    }

    public String getArchivingConfiguration() {
        return this.archivingConfiguration;
    }

    public boolean isArchivingEnable() {
        return this.archivingEnabled;
    }

    public void setArchivingEnabled(boolean archivingEnabled) {
        this.archivingEnabled = archivingEnabled;
        this.setCustomizationStatus(38, true);
    }

    public void setAutoStartable(boolean autoStartable) {
        this.autoStartable = autoStartable;
        this.setCustomizationStatus(48, true);
    }

    public boolean isAutoStartable() {
        return this.autoStartable != null && this.autoStartable != false;
    }

    public void setBamSnapshotDisposing(Frequency bamSnapshotDisposing) {
        this.bamSnapshotDisposing = bamSnapshotDisposing == null ? BAM_SNAPSHOT_DISPOSER_DEF.toString() : bamSnapshotDisposing.toString();
        this.setCustomizationStatus(42, true);
    }

    public Frequency getBamSnapshotDisposing() {
        return this.bamSnapshotDisposing == null ? BAM_SNAPSHOT_DISPOSER_DEF : Frequency.valueOf(this.bamSnapshotDisposing);
    }

    public void setBamSnapshotResolution(Frequency bamSnapshotResolution) {
        this.bamSnapshotResolution = bamSnapshotResolution == null ? BAM_SNAPSHOT_RESOLUTION_DEF.toString() : bamSnapshotResolution.toString();
        this.setCustomizationStatus(41, true);
    }

    public Frequency getBamSnapshotResolution() {
        return this.bamSnapshotResolution == null ? BAM_SNAPSHOT_RESOLUTION_DEF : Frequency.valueOf(this.bamSnapshotResolution);
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        this.setCustomizationStatus(3, true);
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setCreationConfiguration(String configuration) {
        this.creationConfiguration = configuration;
    }

    public String getCreationConfiguration() {
        return this.creationConfiguration;
    }

    public void setDirectoryPollingInterval(int val) {
        this.directoryPollingInterval = val;
        this.setCustomizationStatus(2, true);
    }

    public int getDirectoryPollingInterval() {
        return this.directoryPollingInterval;
    }

    public void setDisposeInstanceCaducity(int instanceCaducity) {
        this.disposeInstanceCaducity = instanceCaducity;
        this.setCustomizationStatus(1, true);
    }

    public int getDisposeInstanceCaducity() {
        return this.disposeInstanceCaducity;
    }

    public void setDisposeLatency(int latency) {
        this.disposeLatency = latency;
        this.setCustomizationStatus(0, true);
    }

    public int getDisposeLatency() {
        return this.disposeLatency;
    }

    public void setDisposerStartingTime(Time disposerStartingTime) {
        this.disposerStartingTime = disposerStartingTime;
        this.setCustomizationStatus(39, true);
    }

    public Time getDisposerStartingTime() {
        return this.disposerStartingTime;
    }

    public void setDueItemsPollingInterval(int val) {
        this.dueItemsPollingInterval = val;
        this.setCustomizationStatus(55, true);
    }

    public int getDueItemsPollingInterval() {
        return this.dueItemsPollingInterval;
    }

    public Iterator getEngineAccessInfo() {
        if (this.accessInfo == null) {
            return null;
        }
        return this.accessInfo.iterator();
    }

    public List<EngineAccessInfo> getEngineAccessInfoList() {
        return this.accessInfo;
    }

    public String getEngineTemplate() {
        return "default";
    }

    public EngineType getEngineType() {
        String engineTypeStr = System.getProperty("fuego.engine.type");
        return engineTypeStr == null ? EngineType.ENTERPRISE : EngineType.valueOf(engineTypeStr);
    }

    public void setExecutionThreadPoolSize(int executionThreadPoolSize) {
        this.executionThreadPoolSize = executionThreadPoolSize;
        this.setCustomizationStatus(7, true);
    }

    public int getExecutionThreadPoolSize() {
        return this.executionThreadPoolSize;
    }

    public String getFullLogDefaultClientSeverities() {
        return this.getFullLogSeverities(this.logDefaultClientSeverities);
    }

    public String getFullLogDefaultSeverities() {
        return this.getFullLogSeverities(this.logDefaultSeverities);
    }

    public String getFullLogMailSeverities() {
        if (this.logMailSeverities.equals(WARNING)) {
            return "Fatal,Severe,Warning";
        }
        if (this.logMailSeverities.equals(SEVERE)) {
            return "Fatal,Severe";
        }
        return this.logMailSeverities;
    }

    @Override
    public Msg getHint(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return CoreMsg.DAYS;
            }
            case 2: 
            case 8: 
            case 28: {
                return DirectoryMsg.MINUTES;
            }
            case 14: 
            case 21: 
            case 27: {
                return DirectoryMsg.PRIORITY_HINT;
            }
            case 15: {
                return DirectoryMsg.LOGSIZE_HINT;
            }
            case 20: 
            case 23: 
            case 55: {
                return CoreMsg.SECONDS;
            }
            case 4: {
                return DirectoryMsg.KBYTES;
            }
            case 5: {
                return DirectoryMsg.MBYTES;
            }
            case 44: {
                return DirectoryMsg.MINUTES;
            }
        }
        return null;
    }

    public void setHttpThreadCount(int httpThreadCount) {
        this.httpThreadCount = httpThreadCount;
        this.setCustomizationStatus(46, true);
    }

    public int getHttpThreadCount() {
        return this.httpThreadCount;
    }

    @Override
    public int getIncrement(int id) {
        switch (id) {
            case 7: 
            case 33: 
            case 35: {
                return 10;
            }
            case 23: {
                return 15;
            }
            case 4: {
                return 16;
            }
            case 28: {
                return 30;
            }
            case 5: {
                return 32;
            }
            case 3: 
            case 15: 
            case 22: 
            case 25: {
                return 100;
            }
            case 43: {
                return 100;
            }
            case 44: {
                return 30;
            }
            case 46: {
                return 10;
            }
            case 45: {
                return 10;
            }
        }
        return 1;
    }

    public void setInitPoolSize(int initPoolSize) {
        this.initPoolSize = initPoolSize;
        this.setCustomizationStatus(31, true);
    }

    public int getInitPoolSize() {
        return this.initPoolSize;
    }

    public void setInstanceMaxSize(int instanceMaxSize) {
        this.instanceMaxSize = instanceMaxSize;
        this.setCustomizationStatus(4, true);
    }

    public int getInstanceMaxSize() {
        return this.instanceMaxSize;
    }

    public void setInstanceRetrievalSize(int newSize) {
        this.instanceRetrievalSize = newSize;
        this.setCustomizationStatus(22, true);
    }

    public int getInstanceRetrievalSize() {
        return this.instanceRetrievalSize;
    }

    public String getInternalSnmpManagerHost() {
        return this.snmpManagerHost;
    }

    public String getInternalWebBUIServer() {
        return this.webBUIServer;
    }

    public String getInternalWebServicesURL() {
        return this.webServicesURL;
    }

    public void setIpcServiceEnabled(String val) {
        int ind = EngineProperties.valuesServiceEnabled().indexOf(val);
        if (ind != -1) {
            this.ipcServiceEnabled = ind;
        }
        this.setCustomizationStatus(29, true);
    }

    public void setIpcServiceEnabled(boolean enabled) {
        this.ipcServiceEnabled = enabled ? 1 : 0;
        this.setCustomizationStatus(29, true);
    }

    public String getIpcServiceEnabled() {
        return (String)EngineProperties.valuesServiceEnabled().get(this.ipcServiceEnabled);
    }

    public boolean isIpcServiceEnabled() {
        return this.ipcServiceEnabled != 0;
    }

    public void setIpcServiceEnabledValue(int val) {
        this.ipcServiceEnabled = val;
        this.setCustomizationStatus(29, true);
    }

    public int getIpcServiceEnabledValue() {
        return this.ipcServiceEnabled;
    }

    public void setIpcServicePort(int val) {
        this.ipcServicePort = val;
        this.setCustomizationStatus(30, true);
    }

    public int getIpcServicePort() {
        return this.ipcServicePort;
    }

    public void setItemExecutionTimeout(int timeout) {
        this.itemExecutionTimeout = timeout;
        this.setCustomizationStatus(28, true);
    }

    public int getItemExecutionTimeout() {
        return this.itemExecutionTimeout;
    }

    public void setJmsQueue(String jmsQueue) {
        this.jmsQueue = jmsQueue;
        this.setCustomizationStatus(51, true);
    }

    public String getJmsQueue() {
        if (this.jmsQueue == null) {
            this.setJmsQueue("");
        }
        return this.jmsQueue;
    }

    public void setJmsQueueFactory(String jmsQueueFactory) {
        this.jmsQueueFactory = jmsQueueFactory;
        this.setCustomizationStatus(57, true);
    }

    public String getJmsQueueFactory() {
        if (this.jmsQueueFactory == null) {
            this.setJmsQueueFactory("");
        }
        return this.jmsQueueFactory;
    }

    public void setJmsTopic(String jmsTopic) {
        this.jmsTopic = jmsTopic;
        this.setCustomizationStatus(56, true);
    }

    public String getJmsTopic() {
        if (this.jmsTopic == null) {
            this.setJmsTopic("");
        }
        return this.jmsTopic;
    }

    public void setJmsTopicFactory(String jmsTopicFactory) {
        this.jmsTopicFactory = jmsTopicFactory;
        this.setCustomizationStatus(58, true);
    }

    public String getJmsTopicFactory() {
        if (this.jmsTopicFactory == null) {
            this.setJmsTopicFactory("");
        }
        return this.jmsTopicFactory;
    }

    public void setJvmHeapMax(int jvmHeapMax) {
        this.jvmHeapMax = jvmHeapMax;
        this.setCustomizationStatus(5, true);
    }

    public int getJvmHeapMax() {
        return this.jvmHeapMax;
    }

    public void setLogBackupFiles(int logBackupFiles) {
        this.logBackupFiles = logBackupFiles;
        this.setCustomizationStatus(16, true);
    }

    public int getLogBackupFiles() {
        return this.logBackupFiles;
    }

    public void setLogDefaultClientSeverities(String logDefaultClientSeverities) {
        this.logDefaultClientSeverities = logDefaultClientSeverities;
        this.setCustomizationStatus(18, true);
    }

    public String getLogDefaultClientSeverities() {
        return this.logDefaultClientSeverities;
    }

    public void setLogDefaultDetailLevel(int logDefaultDetailLevel) {
        this.logDefaultDetailLevel = logDefaultDetailLevel;
        this.setCustomizationStatus(14, true);
    }

    public int getLogDefaultDetailLevel() {
        return this.logDefaultDetailLevel;
    }

    public void setLogDefaultSeverities(String logDefaultSeverities) {
        this.logDefaultSeverities = logDefaultSeverities;
        this.setCustomizationStatus(17, true);
    }

    public String getLogDefaultSeverities() {
        return this.logDefaultSeverities;
    }

    public void setLogMailSeverities(String logMailSeverities) {
        this.logMailSeverities = logMailSeverities;
        this.setCustomizationStatus(19, true);
    }

    public String getLogMailSeverities() {
        return this.logMailSeverities;
    }

    public void setLogMaxSize(int logMaxSize) {
        this.logMaxSize = logMaxSize;
        this.setCustomizationStatus(15, true);
    }

    public int getLogMaxSize() {
        return this.logMaxSize;
    }

    public void setMailServerName(String mailServer) {
        this.mailServerName = mailServer;
        this.setCustomizationStatus(9, true);
    }

    public String getMailServerName() {
        if (this.mailServerName == null) {
            this.setMailServerName("");
        }
        return this.mailServerName;
    }

    @Override
    public int getMax(int id) {
        switch (id) {
            case 2: {
                return 60;
            }
            case 7: 
            case 26: {
                return 200;
            }
            case 14: {
                return 10;
            }
            case 15: {
                return 1000000000;
            }
            case 0: 
            case 1: 
            case 16: 
            case 24: 
            case 31: 
            case 32: {
                return 100;
            }
            case 20: {
                return 300;
            }
            case 21: 
            case 27: {
                return 10;
            }
            case 3: {
                return 1000000;
            }
            case 4: {
                return 0x100000;
            }
            case 5: {
                return 4096;
            }
            case 22: {
                return 50000;
            }
            case 23: 
            case 25: 
            case 55: {
                return 100000;
            }
            case 28: {
                return Integer.MAX_VALUE;
            }
            case 30: 
            case 33: 
            case 35: {
                return 65535;
            }
            case 8: {
                return Integer.MAX_VALUE;
            }
            case 37: {
                return 20;
            }
            case 43: {
                return 10000;
            }
            case 44: {
                return 1440;
            }
            case 46: {
                return 200;
            }
            case 45: {
                return 100000;
            }
        }
        return 0;
    }

    public void setMaxCILTimeout(int maxCILTimeout) {
        this.maxCILTimeout = maxCILTimeout;
        this.setCustomizationStatus(8, true);
    }

    public int getMaxCILTimeout() {
        return this.maxCILTimeout;
    }

    public void setMaxIPCIncomingConnections(int maxIPCIncomingConnections) {
        this.maxIPCIncomingConnections = maxIPCIncomingConnections;
        this.setCustomizationStatus(37, true);
    }

    public int getMaxIPCIncomingConnections() {
        return this.maxIPCIncomingConnections;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.setCustomizationStatus(32, true);
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public int getMin(int id) {
        switch (id) {
            case 30: {
                return 1024;
            }
            case 3: 
            case 7: {
                return 10;
            }
            case 15: {
                return 1000;
            }
            case 21: 
            case 27: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 256;
            }
            case 22: 
            case 25: {
                return 100;
            }
            case 23: {
                return 15;
            }
            case 24: 
            case 37: {
                return 0;
            }
            case 31: 
            case 32: {
                return 5;
            }
            case 43: {
                return 0;
            }
            case 44: {
                return 1;
            }
            case 46: {
                return 1;
            }
            case 45: {
                return 0;
            }
        }
        return 1;
    }

    @Override
    public boolean isModifiableInRuntime(int id) {
        switch (id) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 39: 
            case 55: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Msg getMsg(int id) {
        switch (id) {
            case 10: {
                return DirectoryMsg.ADMINISTRATOR_MAIL;
            }
            case 3: {
                return DirectoryMsg.CACHE_SIZE;
            }
            case 2: {
                return DirectoryMsg.DIRECTORY_POLLING_INTERVAL;
            }
            case 55: {
                return DirectoryMsg.DUE_ITEMS_POLLING_INTERVAL;
            }
            case 1: {
                return DirectoryMsg.DISPOSE_INSTANCE_CADUCITY;
            }
            case 0: {
                return DirectoryMsg.DISPOSE_LATENCY;
            }
            case 7: {
                return DirectoryMsg.EXECUTION_THREAD_POOL_SIZE;
            }
            case 31: {
                return DirectoryMsg.INIT_POOL_SIZE;
            }
            case 4: {
                return DirectoryMsg.INSTANCE_MAX_SIZE;
            }
            case 22: {
                return DirectoryMsg.INSTANCE_RETRIEVAL_SIZE;
            }
            case 29: {
                return DirectoryMsg.IPC_SERVICE_ENABLED;
            }
            case 30: {
                return DirectoryMsg.IPC_SERVICE_PORT;
            }
            case 28: {
                return DirectoryMsg.ITEM_EXECUTION_TIMEOUT;
            }
            case 5: {
                return DirectoryMsg.JVM_HEAP_MAX;
            }
            case 16: {
                return DirectoryMsg.LOG_BACKUP_FILES;
            }
            case 18: {
                return DirectoryMsg.LOG_DEFAULT_CLIENT_SEVERITIES;
            }
            case 17: {
                return DirectoryMsg.LOG_DEFAULT_SEVERITIES;
            }
            case 14: {
                return DirectoryMsg.LOG_DEFAULT_DETAIL_LEVEL;
            }
            case 19: {
                return DirectoryMsg.LOG_MAIL_SEVERITIES;
            }
            case 15: {
                return DirectoryMsg.LOG_MAX_SIZE;
            }
            case 9: {
                return DirectoryMsg.MAIL_SERVER_NAME;
            }
            case 8: {
                return DirectoryMsg.MAX_CIL_TIMEOUT;
            }
            case 59: {
                return DirectoryMsg.MAX_WEB_SERVICE_SESSION_TIMEOUT;
            }
            case 32: {
                return DirectoryMsg.MAX_POOL_SIZE;
            }
            case 20: {
                return DirectoryMsg.NOTIFY_THREAD_LATENCY;
            }
            case 21: {
                return DirectoryMsg.NOTIFY_THREAD_PRIORITY;
            }
            case 23: {
                return DirectoryMsg.RETRY_INTERVAL;
            }
            case 24: {
                return DirectoryMsg.RETRY_TIMES;
            }
            case 25: {
                return DirectoryMsg.TO_DO_QUEUE_SIZE;
            }
            case 26: {
                return DirectoryMsg.TO_DO_THREAD_COUNT;
            }
            case 27: {
                return DirectoryMsg.TO_DO_THREAD_PRIORITY;
            }
            case 11: {
                return DirectoryMsg.WORK_PORTAL_URL;
            }
            case 12: {
                return DirectoryMsg.WEB_SERVICES_URL;
            }
            case 6: {
                return DirectoryMsg.WRITE_EVENTS;
            }
            case 33: {
                return DirectoryMsg.SNMP_AGENT_PORT;
            }
            case 34: {
                return DirectoryMsg.SNMP_MANAGER_HOST;
            }
            case 35: {
                return DirectoryMsg.SNMP_MANAGER_PORT;
            }
            case 36: {
                return DirectoryMsg.SNMP_SERVICE_ENABLED;
            }
            case 37: {
                return DirectoryMsg.MAX_IPC_INCOMING_CONNECTIONS;
            }
            case 40: {
                return DirectoryMsg.ARCHIVING_CONFIGURATION;
            }
            case 38: {
                return DirectoryMsg.ARCHIVING_ENABLED;
            }
            case 39: {
                return DirectoryMsg.DISPOSER_STARTING_TIME;
            }
            case 42: {
                return DirectoryMsg.SNAPSHOT_DISPOSER;
            }
            case 41: {
                return DirectoryMsg.SNAPSHOT_RESOLUTION;
            }
            case 43: {
                return DirectoryMsg.REQUEST_QUEUE_SIZE;
            }
            case 44: {
                return DirectoryMsg.REQUEST_QUEUE_TIMEOUT;
            }
            case 46: {
                return DirectoryMsg.HTTP_THREAD_COUNT;
            }
            case 45: {
                return DirectoryMsg.ROGUE_THREADS_LIMIT;
            }
            case 48: {
                return DirectoryMsg.AUTOSTARTABLE;
            }
            case 49: {
                return DirectoryMsg.START_ARGUMENTS;
            }
        }
        return null;
    }

    public void setNotifyThreadLatency(int latency) {
        this.notifyThreadLatency = latency;
        this.setCustomizationStatus(20, true);
    }

    public int getNotifyThreadLatency() {
        return this.notifyThreadLatency;
    }

    public void setNotifyThreadPriority(int priority) {
        this.notifyThreadPriority = priority;
        this.setCustomizationStatus(21, true);
    }

    public int getNotifyThreadPriority() {
        return this.notifyThreadPriority;
    }

    public void setProtocolStackconfiguration(String protocolStackconfiguration) {
        this.protocolStackconfiguration = protocolStackconfiguration;
        this.setCustomizationStatus(52, true);
    }

    public String getProtocolStackconfiguration() {
        if (this.protocolStackconfiguration == null) {
            this.setProtocolStackconfiguration("");
        }
        return this.protocolStackconfiguration;
    }

    public void setRequestQueueSize(int requestQueueSize) {
        this.requestQueueSize = requestQueueSize;
        this.setCustomizationStatus(43, true);
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public void setRequestQueueTimeout(int requestQueueTimeout) {
        this.requestQueueTimeout = requestQueueTimeout;
        this.setCustomizationStatus(44, true);
    }

    public int getRequestQueueTimeout() {
        return this.requestQueueTimeout;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        this.setCustomizationStatus(23, true);
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        this.setCustomizationStatus(24, true);
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRogueThreadsLimit(int rogueThreadsLimit) {
        this.rogueThreadsLimit = rogueThreadsLimit;
        this.setCustomizationStatus(45, true);
    }

    public int getRogueThreadsLimit() {
        return this.rogueThreadsLimit;
    }

    public void setRuntimeConfiguration(String configuration) {
        this.runtimeConfiguration = configuration;
    }

    public String getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public List<ServerLocation> getServerLocationList() {
        return this.locations;
    }

    public Iterator getServerLocations() {
        if (this.locations == null) {
            return null;
        }
        return this.locations.iterator();
    }

    public void setSnmpAgentPort(int snmpAgentPort) {
        this.snmpAgentPort = snmpAgentPort;
        this.setCustomizationStatus(33, true);
    }

    public int getSnmpAgentPort() {
        return this.snmpAgentPort;
    }

    public void setSnmpManagerHost(String snmpManagerHost) {
        this.snmpManagerHost = snmpManagerHost;
        this.setCustomizationStatus(34, true);
    }

    public String getSnmpManagerHost() {
        return EngineProperties.getHostName(this.snmpManagerHost);
    }

    public void setSnmpManagerPort(int snmpManagerPort) {
        this.snmpManagerPort = snmpManagerPort;
        this.setCustomizationStatus(35, true);
    }

    public int getSnmpManagerPort() {
        return this.snmpManagerPort;
    }

    public void setSnmpServiceEnabled(String val) {
        int ind = EngineProperties.valuesServiceEnabled().indexOf(val);
        if (ind != -1) {
            this.snmpServiceEnabled = ind;
        }
        this.setCustomizationStatus(36, true);
    }

    public void setSnmpServiceEnabled(boolean enabled) {
        this.snmpServiceEnabled = enabled ? 1 : 0;
        this.setCustomizationStatus(36, true);
    }

    public String getSnmpServiceEnabled() {
        return this.snmpServiceEnabled == -1 ? null : (String)EngineProperties.valuesServiceEnabled().get(this.snmpServiceEnabled);
    }

    public boolean isSnmpServiceEnabled() {
        return this.snmpServiceEnabled != 0;
    }

    public void setSnmpServiceEnabledValue(int val) {
        this.snmpServiceEnabled = val;
        this.setCustomizationStatus(36, true);
    }

    public int getSnmpServiceEnabledValue() {
        return this.snmpServiceEnabled;
    }

    public void setStartArguments(String startArguments) {
        this.startArguments = startArguments;
        this.setCustomizationStatus(49, true);
    }

    public String getStartArguments() {
        return this.startArguments;
    }

    public void setStartJavaArguments(String startJavaArguments) {
        this.startJavaArguments = startJavaArguments;
        this.setCustomizationStatus(50, true);
    }

    public String getStartJavaArguments() {
        return this.startJavaArguments;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setToDoQueueSize(int size) {
        this.toDoQueueSize = size;
        this.setCustomizationStatus(25, true);
    }

    public int getToDoQueueSize() {
        return this.toDoQueueSize;
    }

    public void setToDoThreadCount(int toDoCount) {
        this.toDoThreadCount = toDoCount;
        this.setCustomizationStatus(26, true);
    }

    public int getToDoThreadCount() {
        return this.toDoThreadCount;
    }

    public void setToDoThreadPriority(int priority) {
        this.toDoThreadPriority = priority;
        this.setCustomizationStatus(27, true);
    }

    public int getToDoThreadPriority() {
        return this.toDoThreadPriority;
    }

    public void setTraceComponents(boolean traceComponents) {
        this.traceComponents = traceComponents;
        this.setCustomizationStatus(47, true);
    }

    public String getTraceComponents() {
        return (String)this.valuesTraceComponents().get(this.traceComponents != null && this.traceComponents != false ? 1 : 0);
    }

    public boolean isTracingComponents() {
        return this.traceComponents != null && this.traceComponents != false;
    }

    @Override
    public StringList getValues(int id) {
        switch (id) {
            case 17: 
            case 18: {
                return EngineProperties.valuesLogSeverities();
            }
            case 19: {
                return EngineProperties.valuesLogMailSeverities();
            }
            case 29: 
            case 36: {
                return EngineProperties.valuesServiceEnabled();
            }
        }
        return null;
    }

    public void setWebBUIServer(String webBUIServer) {
        this.webBUIServer = webBUIServer;
        this.setCustomizationStatus(11, true);
    }

    public String getWebBUIServer() {
        if (this.webBUIServer == null) {
            this.setWebBUIServer("");
        }
        return EngineProperties.updateURL(this.webBUIServer);
    }

    public void setWebServicesURL(String webServicesURL) {
        this.webServicesURL = webServicesURL;
        this.setCustomizationStatus(12, true);
    }

    public String getWebServicesURL() {
        if (this.webServicesURL == null) {
            this.setWebServicesURL("");
        }
        return EngineProperties.updateURL(this.webServicesURL);
    }

    public void setWriteEv(int val) {
        this.writeEvents = val;
        this.setCustomizationStatus(6, true);
    }

    public void setWriteEvents(String val) {
        for (int i = 0; i < writeEventValues.length; ++i) {
            if (!val.equals(writeEventValues[i].getCode())) continue;
            this.writeEvents = i;
            this.setCustomizationStatus(6, true);
            break;
        }
    }

    public Msg getWriteEvents() {
        return writeEventValues[this.writeEvents];
    }

    public int getWriteEventsValue() {
        return this.writeEvents;
    }

    public void addEngineAccessInfo(EngineAccessInfo l) {
        if (this.accessInfo == null) {
            this.accessInfo = new ArrayList<EngineAccessInfo>();
        }
        this.accessInfo.add(l);
    }

    public void addServerLocation(ServerLocation l) {
        if (this.locations == null) {
            this.locations = new ArrayList<ServerLocation>();
        }
        this.locations.add(l);
    }

    public Object clone() {
        EngineProperties props = new EngineProperties(this.getServerId(), this.getConfiguration());
        props.setAdministratorMail(this.getAdministratorMail());
        props.setInitPoolSize(this.getInitPoolSize());
        props.setMaxPoolSize(this.getMaxPoolSize());
        props.setCacheSize(this.getCacheSize());
        props.setInstanceRetrievalSize(this.getInstanceRetrievalSize());
        props.setRetryTimes(this.getRetryTimes());
        props.setToDoThreadPriority(this.getToDoThreadPriority());
        props.setNotifyThreadPriority(this.getNotifyThreadPriority());
        props.setNotifyThreadLatency(this.getNotifyThreadLatency());
        props.setToDoThreadCount(this.getToDoThreadCount());
        props.setToDoQueueSize(this.getToDoQueueSize());
        props.setMailServerName(this.getMailServerName());
        props.setAdministratorMail(this.getAdministratorMail());
        props.setWebBUIServer(this.getInternalWebBUIServer());
        props.setRetryInterval(this.getRetryInterval());
        props.setLogDefaultSeverities(this.getLogDefaultSeverities());
        props.setLogDefaultClientSeverities(this.getLogDefaultClientSeverities());
        props.setLogDefaultDetailLevel(this.getLogDefaultDetailLevel());
        props.setLogMailSeverities(this.getLogMailSeverities());
        props.setLogMaxSize(this.getLogMaxSize());
        props.setLogBackupFiles(this.getLogBackupFiles());
        props.setDisposeLatency(this.getDisposeLatency());
        props.setDisposeInstanceCaducity(this.getDisposeInstanceCaducity());
        props.setExecutionThreadPoolSize(this.getExecutionThreadPoolSize());
        props.setItemExecutionTimeout(this.getItemExecutionTimeout());
        props.setMaxCILTimeout(this.getMaxCILTimeout());
        props.setJvmHeapMax(this.getJvmHeapMax());
        props.setInstanceMaxSize(this.getInstanceMaxSize());
        props.setWriteEv(this.getWriteEventsValue());
        props.setDirectoryPollingInterval(this.getDirectoryPollingInterval());
        props.setDueItemsPollingInterval(this.getDueItemsPollingInterval());
        props.setJmsQueue(this.getJmsQueue());
        props.setJmsQueueFactory(this.getJmsQueueFactory());
        props.setJmsTopic(this.getJmsTopic());
        props.setJmsTopicFactory(this.getJmsTopicFactory());
        props.setProtocolStackconfiguration(this.getProtocolStackconfiguration());
        props.locations = new ArrayList<ServerLocation>();
        if (this.getServerLocationList() != null) {
            props.locations.addAll(this.getServerLocationList());
        }
        props.accessInfo = new ArrayList<EngineAccessInfo>();
        if (this.getEngineAccessInfoList() != null) {
            props.accessInfo.addAll(this.getEngineAccessInfoList());
        }
        props.setIpcServiceEnabledValue(this.getIpcServiceEnabledValue());
        props.setIpcServicePort(this.getIpcServicePort());
        props.setMaxIPCIncomingConnections(this.getMaxIPCIncomingConnections());
        props.setWebServicesURL(this.getInternalWebServicesURL());
        props.setCreationConfiguration(this.getCreationConfiguration());
        props.setRuntimeConfiguration(this.getRuntimeConfiguration());
        props.setSnmpAgentPort(this.getSnmpAgentPort());
        props.setSnmpManagerHost(this.getInternalSnmpManagerHost());
        props.setSnmpManagerPort(this.getSnmpManagerPort());
        props.setSnmpServiceEnabled(this.getSnmpServiceEnabled());
        props.setArchivingEnabled(this.isArchivingEnable());
        props.setDisposerStartingTime(this.getDisposerStartingTime());
        props.setArchivingConfiguration(this.getArchivingConfiguration());
        props.setBamSnapshotDisposing(this.getBamSnapshotDisposing());
        props.setBamSnapshotResolution(this.getBamSnapshotResolution());
        props.setHttpThreadCount(this.getHttpThreadCount());
        props.setRogueThreadsLimit(this.getRogueThreadsLimit());
        props.setRequestQueueSize(this.getRequestQueueSize());
        props.setRequestQueueTimeout(this.getRequestQueueTimeout());
        props.setTemplateId(this.getTemplateId());
        for (int i = 0; i < 60; ++i) {
            props.setCustomizationStatus(i, this.hasBeenCustomized(i));
        }
        return props;
    }

    public boolean hasBeenCustomized(int fieldId) {
        if (this.customizedFields == null) {
            this.customizedFields = new boolean[60];
            this.clearCustomizations();
        }
        return this.customizedFields[fieldId];
    }

    public void removeAllEngineAccessInfo() {
        if (this.accessInfo != null) {
            this.accessInfo.clear();
        }
    }

    public void removeAllServerLocations() {
        if (this.locations != null) {
            this.locations.clear();
        }
    }

    public void restoreDefaultLocationInfo(String homeDir, String logDir) {
        this.removeAllEngineAccessInfo();
        this.removeAllServerLocations();
        ServerLocation loc = new ServerLocation(SNMP_MANAGER_HOST_DEF, "http://$LOCALHOST$:9595/webconsole", logDir, homeDir);
        loc.host = SNMP_MANAGER_HOST_DEF;
        this.addServerLocation(loc);
        this.addEngineAccessInfo(EngineAccessInfo.createDefaultLocalInfo(SNMP_MANAGER_HOST_DEF));
    }

    public void store(DirectorySession session) throws DirectoryException {
        DirEngine engine = DirEngine.fetch(session, this.getServerId());
        if (engine == null) {
            DirEngine.create(session, this.getServerId());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, ENGINE_ENCODING);
            this.doExport(osw);
        }
        catch (UnsupportedEncodingException ignore) {
            ignore.printStackTrace();
        }
        DirEngineConfiguration engineConf = DirEngineConfiguration.fetch(session, this.getConfiguration(), this.getServerId());
        if (engineConf == null) {
            DirEngineConfiguration.create(session, this.getConfiguration(), this.getServerId(), os.toString());
        } else {
            engineConf.setProperties(os.toString());
            engineConf.update();
        }
    }

    public void updatePortalContext(String context) {
        String url = this.webBUIServer.substring(0, this.webBUIServer.lastIndexOf("/"));
        this.webBUIServer = url + "/" + context;
        this.setCustomizationStatus(11, true);
    }

    public void updatePortalPort(int port) {
        String url = this.webBUIServer.substring(0, this.webBUIServer.lastIndexOf(":"));
        this.webBUIServer = url + ":" + port + this.webBUIServer.substring(this.webBUIServer.lastIndexOf("/"));
        this.setCustomizationStatus(11, true);
    }

    public void loadDefaultValues() {
        this.setInitPoolSize(10);
        this.setMaxPoolSize(30);
        this.setCacheSize(5000);
        this.setInstanceRetrievalSize(1000);
        this.setRetryTimes(3);
        this.setToDoThreadPriority(5);
        this.setNotifyThreadPriority(1);
        this.setNotifyThreadLatency(15);
        this.setToDoThreadCount(5);
        this.setToDoQueueSize(1000);
        this.setMailServerName(MAIL_SERVER_DEF);
        this.setAdministratorMail(ADM_MAIL_DEF);
        this.setJmsQueue(JMS_QUEUE_DEF);
        this.setJmsQueueFactory(JMS_QUEUE_FACTORY_DEF);
        this.setJmsTopic(JMS_TOPIC_DEF);
        this.setJmsTopicFactory(JMS_TOPIC_FACTORY_DEF);
        this.setProtocolStackconfiguration(PROTOCOL_STACK_CONFIGURATION_DEF);
        this.setWebBUIServer(WEB_BUI_SERVER_DEF);
        this.setRetryInterval(600);
        this.setLogDefaultSeverities(LOG_DEFAULT_SEVERITIES_DEF);
        this.setLogDefaultClientSeverities(LOG_DEFAULT_CLIENT_SEVERITIES_DEF);
        this.setLogDefaultDetailLevel(1);
        this.setLogMailSeverities(LOG_MAIL_SEVERITIES_DEF);
        this.setLogMaxSize(2000);
        this.setLogBackupFiles(5);
        this.setDisposeLatency(2);
        this.setDisposeInstanceCaducity(15);
        this.setExecutionThreadPoolSize(50);
        this.setItemExecutionTimeout(720);
        this.setMaxCILTimeout(30);
        this.setJvmHeapMax(256);
        this.setInstanceMaxSize(16);
        this.setWriteEv(0);
        this.setDirectoryPollingInterval(1);
        this.setDueItemsPollingInterval(60);
        this.setIpcServiceEnabledValue(0);
        this.setIpcServicePort(54350);
        this.setMaxIPCIncomingConnections(5);
        this.setWebServicesURL(WEB_SERVICES_URL);
        this.setSnmpAgentPort(161);
        this.setSnmpManagerHost(SNMP_MANAGER_HOST_DEF);
        this.setSnmpManagerPort(162);
        this.setSnmpServiceEnabledValue(0);
        this.setArchivingEnabled(false);
        this.setDisposerStartingTime(Time.now());
        this.setBamSnapshotDisposing(BAM_SNAPSHOT_DISPOSER_DEF);
        this.setBamSnapshotResolution(BAM_SNAPSHOT_RESOLUTION_DEF);
        this.setHttpThreadCount(5);
        this.setRogueThreadsLimit(100);
        this.setRequestQueueSize(300);
        this.setRequestQueueTimeout(5);
        this.setTraceComponents(false);
        this.setAutoStartable(false);
        this.locations = new ArrayList<ServerLocation>();
        this.accessInfo = new ArrayList<EngineAccessInfo>();
        this.clearCustomizations();
    }

    @Override
    public Msg validate() {
        if (this.creationConfiguration == null || "".equals(this.creationConfiguration)) {
            return DirectoryMsg.MISSING_CREATION_CONFIGURATION;
        }
        if (this.getMailServerName().length() <= 0) {
            return DirectoryMsg.MAIL_SERVER_CANT_BE_VOID;
        }
        if (this.getAdministratorMail().length() <= 0) {
            return DirectoryMsg.ADMIN_MAIL_CANT_BE_VOID;
        }
        if (this.getJmsQueue().length() <= 0) {
            return DirectoryMsg.JMS_QUEUE_CANT_BE_VOID;
        }
        if (this.getJmsQueueFactory().length() <= 0) {
            return DirectoryMsg.JMS_QUEUE_FACTORY_CANT_BE_VOID;
        }
        if (this.getJmsTopic().length() <= 0) {
            return DirectoryMsg.JMS_TOPIC_CANT_BE_VOID;
        }
        if (this.getJmsTopicFactory().length() <= 0) {
            return DirectoryMsg.JMS_TOPIC_FACTORY_CANT_BE_VOID;
        }
        if (this.getProtocolStackconfiguration().length() <= 0) {
            return DirectoryMsg.PROTOCOL_STACK_CANT_BE_VOID;
        }
        if (this.cacheSize <= 0) {
            return DirectoryMsg.CACHE_SIZE_MUST_BE_GTO;
        }
        if (this.instanceMaxSize * this.cacheSize * 2 > this.jvmHeapMax * 1024) {
            return DirectoryMsg.INSTANCEMAX_SIZE_MUST_BE_LTJVM;
        }
        if (this.instanceMaxSize <= 0) {
            return DirectoryMsg.INSTANCEMAX_SIZE_MUST_BE_GTO;
        }
        if (this.jvmHeapMax <= 0) {
            return DirectoryMsg.JVMHEAPMAX_MUST_BE_GTO;
        }
        if (this.toDoQueueSize <= 0) {
            return DirectoryMsg.TO_DO_QUEUE_SIZE_MUST_BE_GT0;
        }
        if (this.toDoThreadCount <= 0) {
            return DirectoryMsg.TO_DO_THREAD_COUNT_MUST_BE_GT0;
        }
        if ((double)this.maxPoolSize < 0.3 * (double)this.toDoThreadCount + (double)this.toDoThreadCount) {
            return DirectoryMsg.MAXPOOLSIZE_MUST_BE_GT_TO_DO_THREAD_COUNT;
        }
        if ((double)this.toDoThreadCount > 0.9 * (double)this.executionThreadPoolSize) {
            return DirectoryMsg.TO_DO_THREAD_COUNT_MUST_BE_LT_EXECUTION_THREAD_COUNT;
        }
        if (this.initPoolSize <= 0) {
            return DirectoryMsg.INIT_POOL_SIZE_MUST_BE_GTO;
        }
        if (this.maxPoolSize <= 0) {
            return DirectoryMsg.MAX_POOL_SIZE_MUST_BE_GTO;
        }
        if (this.maxPoolSize < this.initPoolSize) {
            return DirectoryMsg.MAX_POOL_SIZE_MUST_BE_GT_INIT_POOL_SIZE;
        }
        if (this.isSnmpServiceEnabled() && (this.snmpManagerHost == null || "".equals(this.snmpManagerHost))) {
            return DirectoryMsg.SNMP_MANAGER_HOST_NOT_NULL;
        }
        return null;
    }

    public Msg validate(int fieldId, Object value) {
        switch (fieldId) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 55: {
                int intVal = (Integer)value;
                int max = this.getMax(fieldId);
                int min = this.getMin(fieldId);
                if (intVal > max) {
                    return DirectoryMsg.HIGHER_THAN_MAXIMUM(max);
                }
                if (intVal >= min) break;
                return DirectoryMsg.LOWER_THAN_MINIMUM(min);
            }
            case 10: {
                break;
            }
            case 9: 
            case 34: 
            case 51: 
            case 52: 
            case 56: {
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 42: {
                return this.checkValidValues(this.convertFrequencies(Frequency.getBAMSnapshotDisposingValidFrequencies()), value);
            }
            case 41: {
                return this.checkValidValues(this.convertFrequencies(Frequency.getBAMSnapshotResolutionValidFrequencies()), value);
            }
            case 6: 
            case 17: 
            case 18: 
            case 19: {
                return this.checkValidValues(this.getValues(fieldId), value);
            }
            case 29: 
            case 36: 
            case 38: {
                break;
            }
            case 49: {
                if (((String)value).startsWith("-")) break;
                return DirectoryMsg.INVALID_START_ARGUMENTS;
            }
            case 50: {
                if (((String)value).startsWith("-")) break;
                return DirectoryMsg.INVALID_START_JAVA_ARGUMENTS;
            }
        }
        return null;
    }

    public StringList valuesTraceComponents() {
        return StringList.create(NO, YES);
    }

    static EngineProperties createDefaultEngine() {
        EngineProperties properties = new EngineProperties();
        properties.loadDefaultValues();
        return properties;
    }

    static EngineProperties createEngine(String engineId, String homeDir, String logDir) {
        EngineProperties result = new EngineProperties(engineId, "default");
        result.loadDefaultValues();
        ServerLocation loc = new ServerLocation(SNMP_MANAGER_HOST_DEF, "http://$LOCALHOST$:9595/webconsole", logDir, homeDir);
        result.addServerLocation(loc);
        result.addEngineAccessInfo(EngineAccessInfo.createDefaultInfo(loc.getHost()));
        return result;
    }

    static EngineProperties createEngineFromTemplate(String templateId) throws IOException, DeserializationException {
        FileInputStream is = new FileInputStream(new File(FuegoDirectories.configDir(), templateId + ".xml"));
        EngineProperties properties = EngineProperties.doImport(is, false);
        properties.setTemplateId(templateId);
        properties.clearCustomizations();
        return properties;
    }

    static EngineProperties createLocalEngine(String engineId, String homeDir, String logDir) {
        EngineProperties result = new EngineProperties(engineId, "default");
        result.loadDefaultValues();
        result.restoreDefaultLocationInfo(homeDir, logDir);
        return result;
    }

    static EngineProperties createLocalEngineFromTemplate(String templateId, String engineId, String homeDir, String logDir) throws IOException, DeserializationException {
        EngineProperties result = EngineProperties.createLocalEngine(engineId, homeDir, logDir);
        result.loadValuesFromTemplate(templateId);
        return result;
    }

    static EngineProperties doImport(String properties) throws DeserializationException {
        try {
            ByteArrayInputStream istr = new ByteArrayInputStream(properties.getBytes(ENGINE_ENCODING));
            return EngineProperties.doImport(istr);
        }
        catch (UnsupportedEncodingException uee) {
            Log.logSevere(uee);
            throw new RuntimeExceptionShell(uee);
        }
    }

    static EngineProperties load(String serverId, DirectorySession session) throws DirectoryException {
        return EngineProperties.load(serverId, "default", session);
    }

    void doExport(OutputStream os) {
        try {
            XMLSerializerWriter pw = XMLSerializer.createWriter(os);
            pw.write("EngineProperties", DynamicObject.valueOf(this));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void doExport(Writer writer) {
        XMLSerializerWriter pw = new XMLSerializerWriter(writer, (Serializer)new XMLSerializer());
        pw.write("EngineProperties", DynamicObject.valueOf(this));
    }

    void loadValuesFromTemplate(String templateId) throws DeserializationException, IOException {
        EngineProperties properties = EngineProperties.createEngineFromTemplate(templateId);
        this.updateValues(properties);
        this.clearCustomizations();
    }

    private static EngineProperties doImport(InputStream istr, boolean initDefaults) throws DeserializationException {
        XMLDeserializer deserializer = new XMLDeserializer();
        DynamicObject properties = deserializer.parse(istr);
        EngineProperties propsObj = properties.convertTo(EngineProperties.class);
        if (!initDefaults) {
            return propsObj;
        }
        EngineProperties props = EngineProperties.createDefaultEngine();
        props.updateValues(propsObj);
        props.setServerId(propsObj.getServerId());
        props.setConfiguration(propsObj.getConfiguration());
        props.setCreationConfiguration(propsObj.getCreationConfiguration());
        props.setRuntimeConfiguration(propsObj.getRuntimeConfiguration());
        props.locations = propsObj.getServerLocationList();
        props.accessInfo = propsObj.getEngineAccessInfoList();
        props.clearCustomizations();
        props.JDBCdriverProperties = propsObj.JDBCdriverProperties;
        return props;
    }

    private static String getHostName(String host) {
        if (!SNMP_MANAGER_HOST_DEF.equals(host)) {
            return host;
        }
        if (localhost == null) {
            localhost = "localhost";
            try {
                localhost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return localhost;
    }

    private static StringList valuesLogMailSeverities() {
        return StringList.create(NONE, WARNING, SEVERE);
    }

    private static StringList valuesLogSeverities() {
        return StringList.create(FATAL, SEVERE, WARNING, INFO, DEBUG);
    }

    private static StringList valuesServiceEnabled() {
        return StringList.create(NO, YES);
    }

    private void setCustomizationStatus(int fieldId, boolean status) {
        if (this.customizedFields == null || this.customizedFields.length < 60) {
            this.customizedFields = new boolean[60];
            this.clearCustomizations();
        }
        this.customizedFields[fieldId] = status;
    }

    private String getFullLogSeverities(String severities) {
        if (severities.equals(DEBUG)) {
            return "Trace,Fatal,Severe,Warning,Info,Debug";
        }
        if (severities.equals(INFO)) {
            return "Trace,Fatal,Severe,Warning,Info";
        }
        if (severities.equals(WARNING)) {
            return "Trace,Fatal,Severe,Warning";
        }
        if (severities.equals(SEVERE)) {
            return "Trace,Fatal,Severe";
        }
        return "Trace,Fatal";
    }

    private void clearCustomizations() {
        for (int i = 0; i < 60; ++i) {
            this.setCustomizationStatus(i, false);
        }
    }

    private Msg checkValidValues(Collection values, Object value) {
        boolean valid = false;
        Iterator it = values.iterator();
        while (!valid && it.hasNext()) {
            Object v = it.next();
            if (!v.equals(value)) continue;
            valid = true;
        }
        if (!valid) {
            return DirectoryMsg.NOT_IN_VALID_VALUES(values.toString());
        }
        return null;
    }

    private StringList convertFrequencies(Collection<Frequency> frequencies) {
        return StringList.convert(frequencies);
    }

    private void updateValues(EngineProperties properties) {
        Frequency freqValue;
        Time timeValue;
        Boolean booleanValue;
        int intVal;
        String strVal = properties.getTemplateId();
        if (strVal != null) {
            this.setTemplateId(strVal);
        }
        if ((strVal = properties.getAdministratorMail()) != null && !"".equals(strVal)) {
            this.setAdministratorMail(strVal);
        }
        if ((strVal = properties.getJmsQueue()) != null && !"".equals(strVal)) {
            this.setJmsQueue(strVal);
        }
        if ((strVal = properties.getJmsQueueFactory()) != null && !"".equals(strVal)) {
            this.setJmsQueueFactory(strVal);
        }
        if ((strVal = properties.getJmsTopic()) != null && !"".equals(strVal)) {
            this.setJmsTopic(strVal);
        }
        if ((strVal = properties.getJmsTopicFactory()) != null && !"".equals(strVal)) {
            this.setJmsTopicFactory(strVal);
        }
        if ((strVal = properties.getProtocolStackconfiguration()) != null && !"".equals(strVal)) {
            this.setProtocolStackconfiguration(strVal);
        }
        if ((intVal = properties.getInitPoolSize()) != -1) {
            this.setInitPoolSize(intVal);
        }
        if ((intVal = properties.getMaxPoolSize()) != -1) {
            this.setMaxPoolSize(intVal);
        }
        if ((intVal = properties.getCacheSize()) != -1) {
            this.setCacheSize(intVal);
        }
        if ((intVal = properties.getInstanceRetrievalSize()) != -1) {
            this.setInstanceRetrievalSize(intVal);
        }
        if ((intVal = properties.getRetryTimes()) != -1) {
            this.setRetryTimes(intVal);
        }
        if ((intVal = properties.getToDoThreadPriority()) != -1) {
            this.setToDoThreadPriority(intVal);
        }
        if ((intVal = properties.getNotifyThreadPriority()) != -1) {
            this.setNotifyThreadPriority(intVal);
        }
        if ((intVal = properties.getNotifyThreadLatency()) != -1) {
            this.setNotifyThreadLatency(intVal);
        }
        if ((intVal = properties.getToDoThreadCount()) != -1) {
            this.setToDoThreadCount(intVal);
        }
        if ((intVal = properties.getToDoQueueSize()) != -1) {
            this.setToDoQueueSize(intVal);
        }
        if ((strVal = properties.getMailServerName()) != null && !"".equals(strVal)) {
            this.setMailServerName(strVal);
        }
        if ((strVal = properties.getAdministratorMail()) != null && !"".equals(strVal)) {
            this.setAdministratorMail(strVal);
        }
        if ((strVal = properties.getInternalWebBUIServer()) != null && !"".equals(strVal)) {
            this.setWebBUIServer(strVal);
        }
        if ((intVal = properties.getRetryInterval()) != -1) {
            this.setRetryInterval(intVal);
        }
        if ((strVal = properties.getLogDefaultSeverities()) != null && !"".equals(strVal)) {
            this.setLogDefaultSeverities(strVal);
        }
        if ((strVal = properties.getLogDefaultClientSeverities()) != null && !"".equals(strVal)) {
            this.setLogDefaultClientSeverities(strVal);
        }
        if ((intVal = properties.getLogDefaultDetailLevel()) != -1) {
            this.setLogDefaultDetailLevel(intVal);
        }
        if ((strVal = properties.getLogMailSeverities()) != null && !"".equals(strVal)) {
            this.setLogMailSeverities(strVal);
        }
        if ((intVal = properties.getLogMaxSize()) != -1) {
            this.setLogMaxSize(intVal);
        }
        if ((intVal = properties.getLogBackupFiles()) != -1) {
            this.setLogBackupFiles(intVal);
        }
        if ((intVal = properties.getDisposeLatency()) != -1) {
            this.setDisposeLatency(intVal);
        }
        if ((intVal = properties.getDisposeInstanceCaducity()) != -1) {
            this.setDisposeInstanceCaducity(intVal);
        }
        if ((intVal = properties.getExecutionThreadPoolSize()) != -1) {
            this.setExecutionThreadPoolSize(intVal);
        }
        if ((intVal = properties.getItemExecutionTimeout()) != -1) {
            this.setItemExecutionTimeout(intVal);
        }
        if ((intVal = properties.getMaxCILTimeout()) != -1) {
            this.setMaxCILTimeout(intVal);
        }
        if ((intVal = properties.getJvmHeapMax()) != -1) {
            this.setJvmHeapMax(intVal);
        }
        if ((intVal = properties.getInstanceMaxSize()) != -1) {
            this.setInstanceMaxSize(intVal);
        }
        if ((intVal = properties.getWriteEventsValue()) != -1) {
            this.setWriteEv(intVal);
        }
        if ((intVal = properties.getDirectoryPollingInterval()) != -1) {
            this.setDirectoryPollingInterval(intVal);
        }
        if ((intVal = properties.getDueItemsPollingInterval()) != -1) {
            this.setDueItemsPollingInterval(intVal);
        }
        if ((intVal = properties.getIpcServiceEnabledValue()) != -1) {
            this.setIpcServiceEnabledValue(intVal);
        }
        if ((intVal = properties.getIpcServicePort()) != -1) {
            this.setIpcServicePort(intVal);
        }
        if ((intVal = properties.getMaxIPCIncomingConnections()) != -1) {
            this.setMaxIPCIncomingConnections(intVal);
        }
        if ((strVal = properties.getInternalWebServicesURL()) != null && !"".equals(strVal)) {
            this.setWebServicesURL(strVal);
        }
        if ((strVal = properties.getCreationConfiguration()) != null && !"".equals(strVal)) {
            this.setCreationConfiguration(strVal);
        }
        if ((strVal = properties.getRuntimeConfiguration()) != null && !"".equals(strVal)) {
            this.setRuntimeConfiguration(strVal);
        }
        if ((intVal = properties.getSnmpAgentPort()) != -1) {
            this.setSnmpAgentPort(intVal);
        }
        if ((strVal = properties.getInternalSnmpManagerHost()) != null && !"".equals(strVal)) {
            this.setSnmpManagerHost(strVal);
        }
        if ((intVal = properties.getSnmpManagerPort()) != -1) {
            this.setSnmpManagerPort(intVal);
        }
        if ((strVal = properties.getSnmpServiceEnabled()) != null && !"".equals(strVal)) {
            this.setSnmpServiceEnabled(strVal);
        }
        if ((booleanValue = properties.archivingEnabled) != null) {
            this.setArchivingEnabled(booleanValue);
        }
        if ((timeValue = properties.getDisposerStartingTime()) != null) {
            this.setDisposerStartingTime(timeValue);
        }
        if ((strVal = properties.getArchivingConfiguration()) != null && !"".equals(strVal)) {
            this.setArchivingConfiguration(strVal);
        }
        if ((freqValue = properties.getBamSnapshotDisposing()) != null) {
            this.setBamSnapshotDisposing(freqValue);
        }
        if ((freqValue = properties.getBamSnapshotResolution()) != null) {
            this.setBamSnapshotResolution(freqValue);
        }
        if ((intVal = properties.getHttpThreadCount()) != -1) {
            this.setHttpThreadCount(intVal);
        }
        if ((intVal = properties.getRogueThreadsLimit()) != -1) {
            this.setRogueThreadsLimit(intVal);
        }
        if ((intVal = properties.getRequestQueueSize()) != -1) {
            this.setRequestQueueSize(intVal);
        }
        if ((intVal = properties.getRequestQueueTimeout()) != -1) {
            this.setRequestQueueTimeout(intVal);
        }
        if ((booleanValue = properties.traceComponents) != null) {
            this.setTraceComponents(booleanValue);
        }
        if ((booleanValue = properties.autoStartable) != null) {
            this.setAutoStartable(booleanValue);
        }
        if ((strVal = properties.getStartArguments()) != null && !"".equals(strVal)) {
            this.setStartArguments(strVal);
        }
        if ((strVal = properties.getStartJavaArguments()) != null && !"".equals(strVal)) {
            this.setStartJavaArguments(strVal);
        }
    }

    static {
        locations_ELEMENT_ = null;
        accessInfo_ELEMENT_ = null;
        LOG_DEFAULT_SEVERITIES_DEF = StandaloneLogPreferences.ENGINE_LOG_SEVERITY_DEF;
        LOG_DEFAULT_CLIENT_SEVERITIES_DEF = StandaloneLogPreferences.METHOD_LOG_SEVERITY_DEF;
        LOG_MAIL_SEVERITIES_DEF = StandaloneLogPreferences.MAIL_LOG_SEVERITY_DEF;
        ENGINE_ENCODING = Literals.DEFAULT_ENCODING;
        BAM_SNAPSHOT_RESOLUTION_DEF = StandaloneBAMPreferences.BAM_SNAPSHOT_RESOLUTION_DEF;
        BAM_SNAPSHOT_DISPOSER_DEF = StandaloneBAMPreferences.BAM_SNAPSHOT_DISPOSING_DEF;
    }
}

