/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.standalone;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.engine.base.BaseExecutionPreferences;
import fuego.prefs.validator.ErrorMsg;

public class StandaloneExecutionPreferences
extends BaseExecutionPreferences {
    protected IntegerPreference automaticExecutionThreadsPoolSize;
    protected IntegerPreference automaticExecutionThreadsPriority;
    protected IntegerPreference automaticItemsQueueSize;
    protected BooleanPreference enableSocketFactory;
    protected IntegerPreference httpThreadCount;
    protected IntegerPreference interactiveExecutionThreadsPoolSize = new IntegerPreference("interactiveExecutionThreadsPoolSize", this, DirectoryMsg.EXECUTION_THREAD_POOL_SIZE, null, null, 50, 10, Integer.MAX_VALUE, 10);
    protected IntegerPreference requestQueueSize;
    protected IntegerPreference requestQueueTimeout;
    protected IntegerPreference rogueThreadsLimit;
    private BooleanPreference restartEngineOnRogueThreadsLimit;
    public static final int INTERACTIVE_EXECUTION_THREADS_POOL_SIZE_DEF = 50;
    public static final int AUTOMATIC_EXECUTION_THREADS_POOL_SIZE_DEF = 5;
    public static final int AUTOMATIC_EXECUTION_THREADS_PRIORITY_DEF = 5;
    public static final int AUTOMATIC_ITEMS_QUEUE_SIZE_DEF = 1000;
    public static final int HTTP_THREAD_COUNT_DEF = 5;
    public static final int REQUEST_QUEUE_SIZE_DEF = 300;
    public static final int REQUEST_QUEUE_TIMEOUT_DEF = 5;
    public static final int ROGUE_THREADS_LIMIT_DEF = 100;
    public static final boolean ENABLE_SOKET_FACTORY = true;

    public StandaloneExecutionPreferences(CategoryPreference parent) {
        super(parent);
        this.automaticExecutionThreadsPoolSize = new IntegerPreference("automaticExecutionThreadsPoolSize", this, DirectoryMsg.TO_DO_THREAD_COUNT, null, null, 5, 1, Integer.MAX_VALUE, 1);
        this.automaticExecutionThreadsPriority = new IntegerPreference("automaticExecutionThreadsPriority", this, DirectoryMsg.TO_DO_THREAD_PRIORITY, null, null, 5, 1, 10, 1);
        this.automaticItemsQueueSize = new IntegerPreference("automaticItemsQueueSize", this, DirectoryMsg.TO_DO_QUEUE_SIZE, null, null, 1000, 100, 100000, 100);
        this.httpThreadCount = new IntegerPreference("httpThreadCount", this, DirectoryMsg.HTTP_THREAD_COUNT, null, null, 5, 1, 200, 10);
        this.requestQueueSize = new IntegerPreference("requestQueueSize", this, DirectoryMsg.REQUEST_QUEUE_SIZE, null, null, 300, 0, 10000, 100);
        this.requestQueueTimeout = new IntegerPreference("requestQueueTimeout", this, DirectoryMsg.REQUEST_QUEUE_TIMEOUT, null, DirectoryMsg.MINUTES, 5, 1, 1440, 5);
        this.rogueThreadsLimit = new IntegerPreference("rogueThreadsLimit", this, DirectoryMsg.ROGUE_THREADS_LIMIT, null, null, 100, 0, 100000, 10);
        this.restartEngineOnRogueThreadsLimit = new BooleanPreference("restartEngineOnRogueThreadsLimit", this, DirectoryMsg.RESTART_ENGINE_MAX_ROGUE_THREADS_REACHED, null, null, true);
        this.enableSocketFactory = new BooleanPreference("enableSocketFactory", this, DirectoryMsg.ENABLESOCKETFACTORY, null, null, true);
        this.enableSocketFactory.setModifiableInRuntime(false);
    }

    public IntegerPreference getAutomaticExecutionThreadsPoolSize() {
        return this.automaticExecutionThreadsPoolSize;
    }

    public IntegerPreference getAutomaticExecutionThreadsPriority() {
        return this.automaticExecutionThreadsPriority;
    }

    public IntegerPreference getAutomaticItemsQueueSize() {
        return this.automaticItemsQueueSize;
    }

    public BooleanPreference getEnableSocketFactory() {
        return this.enableSocketFactory;
    }

    public IntegerPreference getHttpThreadCount() {
        return this.httpThreadCount;
    }

    public IntegerPreference getInteractiveExecutionThreadsPoolSize() {
        return this.interactiveExecutionThreadsPoolSize;
    }

    public IntegerPreference getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public IntegerPreference getRequestQueueTimeout() {
        return this.requestQueueTimeout;
    }

    public IntegerPreference getRogueThreadsLimit() {
        return this.rogueThreadsLimit;
    }

    public BooleanPreference getRestartEngineOnRogueThreadsLimit() {
        return this.restartEngineOnRogueThreadsLimit;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = super.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.enableSocketFactory.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.automaticExecutionThreadsPoolSize.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.automaticExecutionThreadsPriority.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.automaticItemsQueueSize.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.httpThreadCount.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.interactiveExecutionThreadsPoolSize.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.requestQueueSize.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.requestQueueTimeout.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.rogueThreadsLimit.validate();
        if (msg != null) {
            return msg;
        }
        if ((double)this.automaticExecutionThreadsPoolSize.getValue() > 0.9 * (double)this.automaticItemsQueueSize.getValue()) {
            return new ErrorMsg(DirectoryMsg.TO_DO_THREAD_COUNT_MUST_BE_LT_EXECUTION_THREAD_COUNT);
        }
        return null;
    }
}

