/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.standalone;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.IntegerPreference;
import fuego.prefs.LocalhostPreference;
import fuego.prefs.engine.EnginePreferences;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.base.BaseBAMPreferences;
import fuego.prefs.engine.base.BaseDisposerPreferences;
import fuego.prefs.engine.base.BaseEngineLocationPreferences;
import fuego.prefs.engine.base.BaseEnginePreferences;
import fuego.prefs.engine.base.BaseExecutionPreferences;
import fuego.prefs.engine.base.BaseIPCPreferences;
import fuego.prefs.engine.base.BaseJMXPreferences;
import fuego.prefs.engine.base.BaseLogPreferences;
import fuego.prefs.engine.base.BaseMemoryPreferences;
import fuego.prefs.engine.base.BaseNetworkingPreferences;
import fuego.prefs.engine.base.BasePAPIPreferences;
import fuego.prefs.engine.base.BaseRoundTripPreferences;
import fuego.prefs.engine.base.BaseSNMPPreferences;
import fuego.prefs.engine.base.BaseTimeoutsPreferences;
import fuego.prefs.engine.base.BaseWSPreferences;
import fuego.prefs.engine.standalone.StandaloneBAMPreferences;
import fuego.prefs.engine.standalone.StandaloneDisposerPreferences;
import fuego.prefs.engine.standalone.StandaloneEngineLocationPreferences;
import fuego.prefs.engine.standalone.StandaloneExecutionPreferences;
import fuego.prefs.engine.standalone.StandaloneIPCPreferences;
import fuego.prefs.engine.standalone.StandaloneJMXPreferences;
import fuego.prefs.engine.standalone.StandaloneLogPreferences;
import fuego.prefs.engine.standalone.StandaloneMemoryPreferences;
import fuego.prefs.engine.standalone.StandaloneNetworkingPreferences;
import fuego.prefs.engine.standalone.StandalonePAPIPreferences;
import fuego.prefs.engine.standalone.StandaloneRoundTripPreferences;
import fuego.prefs.engine.standalone.StandaloneSNMPPreferences;
import fuego.prefs.engine.standalone.StandaloneStartupPreferences;
import fuego.prefs.engine.standalone.StandaloneTimeoutsPreferences;
import fuego.prefs.engine.standalone.StandaloneWSPreferences;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import java.io.IOException;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;

public abstract class StandaloneEnginePreferences
extends BaseEnginePreferences
implements Cloneable {
    protected IntegerPreference httpDebuggerPort;
    protected StandaloneStartupPreferences startupPreferences = new StandaloneStartupPreferences(this);
    private static final int HTTP_DEBUGGER_PORT_DEF = 8080;

    protected StandaloneEnginePreferences(EngineType type, String serverId, String configuration, EnginePreferencesNode root) {
        super(type, null, null, null, serverId, configuration, root);
        this.httpDebuggerPort = new IntegerPreference("httpDebuggerPort", this, DirectoryMsg.HTTP_DEBUGGER_PORT, null, null, 8080, 1024, 65535, 1);
    }

    public StandaloneBAMPreferences getBAM() {
        return (StandaloneBAMPreferences)this.bamPreferences;
    }

    @Override
    public StandaloneDisposerPreferences getDisposer() {
        return (StandaloneDisposerPreferences)this.disposerPreferences;
    }

    @Override
    public StandaloneExecutionPreferences getExecution() {
        return (StandaloneExecutionPreferences)this.executionPreferences;
    }

    public IntegerPreference getHttpDebuggerPort() {
        return this.httpDebuggerPort;
    }

    public StandaloneIPCPreferences getIPC() {
        return (StandaloneIPCPreferences)this.ipcPreferences;
    }

    public StandaloneJMXPreferences getJMX() {
        return (StandaloneJMXPreferences)this.jmxPreferences;
    }

    public StandaloneEngineLocationPreferences getLocation(String host) {
        return (StandaloneEngineLocationPreferences)this.getLocationsMap().get(host);
    }

    public StandaloneEngineLocationPreferences[] getLocations() {
        Collection<BaseEngineLocationPreferences> r = this.getLocationsMap().values();
        return r.toArray(new StandaloneEngineLocationPreferences[r.size()]);
    }

    @Override
    public StandaloneLogPreferences getLog() {
        return (StandaloneLogPreferences)this.logPreferences;
    }

    @Override
    public StandaloneMemoryPreferences getMemory() {
        return (StandaloneMemoryPreferences)this.memoryPreferences;
    }

    @Override
    public StandaloneNetworkingPreferences getNetworking() {
        return (StandaloneNetworkingPreferences)this.networkingPreferences;
    }

    public StandalonePAPIPreferences getPapi() {
        return (StandalonePAPIPreferences)this.papiPreferences;
    }

    public StandaloneSNMPPreferences getSNMP() {
        return (StandaloneSNMPPreferences)this.snmpPreferences;
    }

    public StandaloneStartupPreferences getStartup() {
        return this.startupPreferences;
    }

    @Override
    public StandaloneTimeoutsPreferences getTimeouts() {
        return (StandaloneTimeoutsPreferences)this.timeoutsPreferences;
    }

    @Override
    public StandaloneWSPreferences getWS() {
        return (StandaloneWSPreferences)this.wsPreferences;
    }

    public void loadValuesFromTemplate(String templateId) throws BackingStoreException, IOException, InvalidPreferencesFormatException {
        StandaloneEnginePreferences enginePreferences = EnginePreferences.createStandaloneFromTemplate(this.getServerId().getValue(), templateId, this.getType());
        assert (this.getType().equals((Object)enginePreferences.getType())) : "Template '" + templateId + "' is from a different type '" + (Object)((Object)enginePreferences.getType()) + "'. You must use a template of type '" + (Object)((Object)this.getType()) + "'";
        this.root.merge(enginePreferences.getRoot());
    }

    public void restoreDefaultLocalInfo(String homeDir, String logDir) {
        boolean export = this.getRoot().getExport();
        String localhost = this.getLocalhost();
        StandaloneEngineLocationPreferences engineLocationPreferences = this.getLocation(localhost);
        if (engineLocationPreferences == null) {
            engineLocationPreferences = (StandaloneEngineLocationPreferences)this.createEngineLocationPreferences(localhost);
            this.getLocationsMap().put(localhost, engineLocationPreferences);
            this.locations.setCSValue(localhost);
        }
        engineLocationPreferences.getHomeDir().setValue(homeDir);
        engineLocationPreferences.getLogDir().setValue(logDir);
        engineLocationPreferences.getAccessInfos()[0].getProtocol().setValue("tcp");
        engineLocationPreferences.getAccessInfos()[0].getPort().setValue(8586);
        this.getRoot().setExport(export);
    }

    @Override
    protected String getLocalhost() {
        return LocalhostPreference.getLocalhost();
    }

    @Override
    protected BaseBAMPreferences createBamPreferences() {
        return new StandaloneBAMPreferences(this);
    }

    @Override
    protected BaseDisposerPreferences createDisposerPreferences() {
        return new StandaloneDisposerPreferences(this);
    }

    @Override
    protected BaseEngineLocationPreferences createEngineLocationPreferences(String localhost) {
        return new StandaloneEngineLocationPreferences(localhost, this);
    }

    @Override
    protected BaseExecutionPreferences createExecutionPreferences() {
        return new StandaloneExecutionPreferences(this);
    }

    @Override
    protected BaseIPCPreferences createIpcPreferences() {
        return new StandaloneIPCPreferences(this);
    }

    @Override
    protected BaseJMXPreferences createJmxPreferences() {
        return new StandaloneJMXPreferences(this);
    }

    @Override
    protected BaseLogPreferences createLogPreferences() {
        return new StandaloneLogPreferences(this);
    }

    @Override
    protected BaseMemoryPreferences createMemoryPreferences() {
        return new StandaloneMemoryPreferences(this);
    }

    @Override
    protected BaseNetworkingPreferences createNetworkingPreferences() {
        return new StandaloneNetworkingPreferences(this);
    }

    @Override
    protected BasePAPIPreferences createPapiPreferences() {
        return new StandalonePAPIPreferences(this);
    }

    @Override
    protected BaseSNMPPreferences createSnmpPreferences() {
        return new StandaloneSNMPPreferences(this);
    }

    @Override
    protected BaseTimeoutsPreferences createTimeoutPreferences() {
        return new StandaloneTimeoutsPreferences(this);
    }

    @Override
    protected BaseWSPreferences createWSPreferences() {
        return new StandaloneWSPreferences(this);
    }

    @Override
    protected BaseRoundTripPreferences createRoundTripPreferences() {
        return new StandaloneRoundTripPreferences(this);
    }
}

