/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.StoreEventsPreferences;
import fuego.prefs.StringPreference;
import fuego.prefs.TimePreference;
import fuego.prefs.engine.base.StoreEvents;
import fuego.prefs.validator.ErrorMsg;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

public class BaseRoundTripPreferences
extends CategoryPreference {
    protected StringPreference roundTripConfiguration;
    protected BooleanPreference roundTripEnabled;
    protected IntegerPreference roundTripGranularity = new IntegerPreference("roundTripGranularity", this, DirectoryMsg.ROUND_TRIP_SIMULATION_GRANULARITY, null, CoreMsg.MINUTES, 60, 1, 10080, 1);
    protected TimePreference roundTripStartingTime;
    public static final int ROUND_TRIP_GRANULARITY_DEF = 60;
    public static final Time ROUND_TRIP_STARTING_TIME_DEF = Time.now();
    public static final boolean ROUND_TRIP_ENABLED_DEF = false;
    public static final String ROUND_TRIP_CONFIGURATION_DEF = "";

    public BaseRoundTripPreferences(CategoryPreference parent) {
        this("roundTrip", parent, null, null, null);
    }

    public BaseRoundTripPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.roundTripGranularity.setModifiableInRuntime(true);
        this.roundTripStartingTime = new TimePreference("roundTripStartingTime", this, DirectoryMsg.ROUND_TRIP_SIMULATION_STARTING_TIME, null, null, ROUND_TRIP_STARTING_TIME_DEF);
        this.roundTripStartingTime.setModifiableInRuntime(true);
        this.roundTripEnabled = new BooleanPreference("roundTripEnabled", this, DirectoryMsg.ROUND_TRIP_SIMULATION_ENABLED, null, null, false);
        this.roundTripConfiguration = new StringPreference("roundTripConfiguration", this, DirectoryMsg.ARCHIVING_CONFIGURATION, null, null, ROUND_TRIP_CONFIGURATION_DEF);
    }

    public StringPreference getRoundTripConfiguration() {
        return this.roundTripConfiguration;
    }

    public BooleanPreference getRoundTripEnabled() {
        return this.roundTripEnabled;
    }

    public TimePreference getRoundTripStartingTime() {
        return this.roundTripStartingTime;
    }

    public IntegerPreference getRoundTripGranularity() {
        return this.roundTripGranularity;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.roundTripEnabled.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.roundTripConfiguration.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.roundTripGranularity.validate();
        if (msg != null) {
            return msg;
        }
        return this.roundTripStartingTime.validate();
    }

    public ErrorMsg validate(StoreEventsPreferences storeEvents) {
        ErrorMsg msg = this.validate();
        if (msg != null) {
            return msg;
        }
        if (this.roundTripEnabled.getValue() && StoreEvents.NEVER.equals(storeEvents.getEnumValue())) {
            return new ErrorMsg(DirectoryMsg.EVENTS_SHOULD_BE_ENABLED, 2);
        }
        return null;
    }
}

