/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CSVPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.StoreEventsPreferences;
import fuego.prefs.StringPreference;
import fuego.prefs.ValueHolderPreference;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.base.BaseBAMPreferences;
import fuego.prefs.engine.base.BaseDisposerPreferences;
import fuego.prefs.engine.base.BaseEngineLocationPreferences;
import fuego.prefs.engine.base.BaseExecutionPreferences;
import fuego.prefs.engine.base.BaseIPCPreferences;
import fuego.prefs.engine.base.BaseJMXPreferences;
import fuego.prefs.engine.base.BaseLogPreferences;
import fuego.prefs.engine.base.BaseMemoryPreferences;
import fuego.prefs.engine.base.BaseNetworkingPreferences;
import fuego.prefs.engine.base.BasePAPIPreferences;
import fuego.prefs.engine.base.BaseRoundTripPreferences;
import fuego.prefs.engine.base.BaseSNMPPreferences;
import fuego.prefs.engine.base.BaseTimeoutsPreferences;
import fuego.prefs.engine.base.BaseWSPreferences;
import fuego.prefs.engine.base.StoreEvents;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import fuego.prefs.validator.EngineNameValidator;
import fuego.prefs.validator.ErrorMsg;
import fuego.prefs.validator.PrefValidatorFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.resources.Msg;

public abstract class BaseEnginePreferences
extends CategoryPreference
implements Cloneable {
    protected BaseBAMPreferences bamPreferences;
    protected StringPreference configuration;
    protected StringPreference creationConfiguration;
    protected BooleanPreference debug;
    protected IntegerPreference directoryPollingInterval;
    protected BaseDisposerPreferences disposerPreferences;
    protected BaseExecutionPreferences executionPreferences;
    protected BaseIPCPreferences ipcPreferences;
    protected BaseJMXPreferences jmxPreferences;
    protected CSVPreference locations;
    protected BaseLogPreferences logPreferences;
    protected BaseMemoryPreferences memoryPreferences;
    protected BaseNetworkingPreferences networkingPreferences;
    protected BasePAPIPreferences papiPreferences;
    protected EnginePreferencesNode root;
    protected BaseRoundTripPreferences roundTripPreferences;
    protected StringPreference runtimeConfiguration;
    protected StringPreference serverId;
    protected BaseSNMPPreferences snmpPreferences;
    protected StoreEventsPreferences storeEvents;
    protected BaseTimeoutsPreferences timeoutsPreferences;
    protected final EngineType type;
    protected BaseWSPreferences wsPreferences;
    private Map<String, BaseEngineLocationPreferences> locationPreferences;
    private StringPreference templateId;
    public static final String CREATION_CONFIGURATION_DEF = "";
    public static final String RUNTIME_CONFIGURATION_DEF = "";
    public static final int DIRECTORY_POLLING_INTERVAL_DEF = 1;
    public static final StoreEvents STORE_EVENTS_DEF = StoreEvents.DEPENDS;
    public static final String TEMPLATE_ID_DEF = "Mixed";
    public static boolean DEBUG_DEF = Boolean.getBoolean("fuego.server.debug.enable");

    public BaseEnginePreferences(EngineType type, Msg label, Msg help, Msg hint, String serverId, String configuration, EnginePreferencesNode root) {
        super(type.toString(), null, label, help, hint);
        this.type = type;
        this.root = root;
        this.serverId = new StringPreference("serverId", (CategoryPreference)this, DirectoryMsg.SERVER, null, null, new EngineNameValidator(), serverId);
        this.configuration = new StringPreference("configuration", this, null, null, null, configuration);
        this.creationConfiguration = new StringPreference("creationConfiguration", (CategoryPreference)this, null, null, null, PrefValidatorFactory.createNotEmptyValidator(DirectoryMsg.MISSING_CREATION_CONFIGURATION), "");
        this.runtimeConfiguration = new StringPreference("runtimeConfiguration", (CategoryPreference)this, null, null, null, PrefValidatorFactory.createNotEmptyValidator(DirectoryMsg.MISSING_RUNTIME_CONFIGURATION), "");
        this.directoryPollingInterval = new IntegerPreference("directoryPollingInterval", this, DirectoryMsg.DIRECTORY_POLLING_INTERVAL, null, DirectoryMsg.MINUTES, 1, 1, 60, 1);
        this.directoryPollingInterval.setModifiableInRuntime(false);
        this.storeEvents = new StoreEventsPreferences("storeEvents", (CategoryPreference)this, DirectoryMsg.WRITE_EVENTS, null, null, STORE_EVENTS_DEF);
        this.storeEvents.setModifiableInRuntime(false);
        String localhost = this.getLocalhost();
        this.locations = new CSVPreference("locations", this, null, null, null, localhost);
        this.templateId = new StringPreference("templateId", this, null, null, null, TEMPLATE_ID_DEF);
        this.debug = new BooleanPreference("debug", this, null, null, null, DEBUG_DEF);
        this.logPreferences = this.createLogPreferences();
        this.executionPreferences = this.createExecutionPreferences();
        this.timeoutsPreferences = this.createTimeoutPreferences();
        this.disposerPreferences = this.createDisposerPreferences();
        this.roundTripPreferences = this.createRoundTripPreferences();
        this.bamPreferences = this.createBamPreferences();
        this.ipcPreferences = this.createIpcPreferences();
        this.snmpPreferences = this.createSnmpPreferences();
        this.jmxPreferences = this.createJmxPreferences();
        this.networkingPreferences = this.createNetworkingPreferences();
        this.memoryPreferences = this.createMemoryPreferences();
        this.papiPreferences = this.createPapiPreferences();
        this.wsPreferences = this.createWSPreferences();
    }

    public BaseDisposerPreferences getDisposer() {
        return this.disposerPreferences;
    }

    public BaseRoundTripPreferences getRoundTrip() {
        return this.roundTripPreferences;
    }

    public BaseExecutionPreferences getExecution() {
        return this.executionPreferences;
    }

    public BaseIPCPreferences getIpc() {
        return this.ipcPreferences;
    }

    public BaseJMXPreferences getJmx() {
        return this.jmxPreferences;
    }

    public BooleanPreference getDebug() {
        return this.debug;
    }

    public BaseEngineLocationPreferences[] getLocations() {
        Collection<BaseEngineLocationPreferences> locations = this.getLocationsMap().values();
        return locations.toArray(new BaseEngineLocationPreferences[locations.size()]);
    }

    public BaseLogPreferences getLog() {
        return this.logPreferences;
    }

    public BaseMemoryPreferences getMemory() {
        return this.memoryPreferences;
    }

    public BaseNetworkingPreferences getNetworking() {
        return this.networkingPreferences;
    }

    public BasePAPIPreferences getPAPI() {
        return this.papiPreferences;
    }

    public BaseBAMPreferences getPreferences() {
        return this.bamPreferences;
    }

    public BaseSNMPPreferences getSnmp() {
        return this.snmpPreferences;
    }

    public BaseTimeoutsPreferences getTimeouts() {
        return this.timeoutsPreferences;
    }

    public BaseWSPreferences getWS() {
        return this.wsPreferences;
    }

    public StringPreference getConfiguration() {
        return this.configuration;
    }

    public StringPreference getCreationConfiguration() {
        return this.creationConfiguration;
    }

    public IntegerPreference getDirectoryPollingInterval() {
        return this.directoryPollingInterval;
    }

    public void setPreferenceValue(String preference, String value) {
        StringTokenizer st = new StringTokenizer(preference, ".");
        CategoryPreference target = this;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            JavaClass<?> javaClass = JavaClass.fromClass(target.getClass());
            try {
                Object result = javaClass.invokeMethod(target, "Mget" + token + "()", new Object[0]);
                if (result instanceof CategoryPreference) {
                    target = (CategoryPreference)result;
                    continue;
                }
                if (!(result instanceof ValueHolderPreference)) continue;
                ValueHolderPreference holder = (ValueHolderPreference)result;
                holder.setStringValue(value);
                break;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public EnginePreferencesNode getRoot() {
        return this.root;
    }

    public StringPreference getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public StringPreference getServerId() {
        return this.serverId;
    }

    public StoreEventsPreferences getStoreEvents() {
        return this.storeEvents;
    }

    public StringPreference getTemplateId() {
        return this.templateId;
    }

    public EngineType getType() {
        return this.type;
    }

    public void addEngineLocation(String host, String webconsoleURL, String logDir, String homeDir) {
        BaseEngineLocationPreferences newLocation = this.createEngineLocationPreferences(host);
        newLocation.getHost().setValue(host);
        newLocation.getWebConsoleURL().setValue(webconsoleURL);
        newLocation.getLogDir().setValue(logDir);
        newLocation.getHomeDir().setValue(homeDir);
        this.locations.setCSValue(host);
        this.getLocationsMap().put(host, newLocation);
    }

    public Object clonePrefs() {
        String configuration = this.getRoot().getConfiguration();
        try {
            EnginePreferencesNode newRoot = new EnginePreferencesNode(configuration);
            this.clone(this.root, newRoot);
            return this.getType().createPreferences(this.getServerId().getValue(), configuration, newRoot);
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeEngineLocation(String host) throws BackingStoreException {
        StringList csValues = this.locations.getCSValues();
        if (csValues.contains(host)) {
            this.locations.removeCSValue(host);
            this.getLocationsMap().remove(host);
            this.getParent().node(host).removeNode();
            this.getParent().remove(host);
        }
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.bamPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.disposerPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.executionPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.ipcPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.logPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.memoryPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.networkingPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.papiPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.snmpPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.jmxPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.timeoutsPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.wsPreferences.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.locations.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.directoryPollingInterval.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.storeEvents.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.configuration.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.creationConfiguration.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.runtimeConfiguration.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.serverId.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.templateId.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.roundTripPreferences.validate(this.storeEvents);
        if (msg != null) {
            return msg;
        }
        for (BaseEngineLocationPreferences location : this.getLocationsMap().values()) {
            BaseEngineLocationPreferences loc = location;
            msg = loc.validate();
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    protected abstract BaseBAMPreferences createBamPreferences();

    protected abstract BaseDisposerPreferences createDisposerPreferences();

    protected abstract BaseEngineLocationPreferences createEngineLocationPreferences(String var1);

    protected abstract BaseExecutionPreferences createExecutionPreferences();

    protected abstract BaseIPCPreferences createIpcPreferences();

    protected abstract BaseJMXPreferences createJmxPreferences();

    protected abstract BaseLogPreferences createLogPreferences();

    protected abstract BaseMemoryPreferences createMemoryPreferences();

    protected abstract BaseNetworkingPreferences createNetworkingPreferences();

    protected abstract BasePAPIPreferences createPapiPreferences();

    protected abstract BaseSNMPPreferences createSnmpPreferences();

    protected abstract BaseTimeoutsPreferences createTimeoutPreferences();

    protected abstract BaseWSPreferences createWSPreferences();

    protected abstract BaseRoundTripPreferences createRoundTripPreferences();

    protected Map<String, BaseEngineLocationPreferences> getLocationsMap() {
        if (this.locationPreferences == null) {
            this.locationPreferences = new TreeMap<String, BaseEngineLocationPreferences>();
            for (String location : this.locations.getCSValues()) {
                this.locationPreferences.put(location, this.createEngineLocationPreferences(location));
            }
        }
        return this.locationPreferences;
    }

    @Override
    protected Preferences getParent() {
        return this.getRoot().node(this.getType().toString());
    }

    protected String getLocalhost() {
        return "localhost";
    }

    private void clone(EnginePreferencesNode oldNode, EnginePreferencesNode newNode) throws BackingStoreException {
        String[] childs;
        String[] oldKeys;
        for (String oldKey : oldKeys = oldNode.keys()) {
            newNode.put(oldKey, oldNode.get(oldKey));
        }
        for (String child : childs = oldNode.childrenNames()) {
            EnginePreferencesNode oldChildNode = (EnginePreferencesNode)oldNode.node(child);
            EnginePreferencesNode newChildNode = (EnginePreferencesNode)newNode.node(child);
            this.clone(oldChildNode, newChildNode);
        }
    }
}

