/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.prefs.CategoryPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.ErrorMsg;
import fuego.prefs.validator.PrefValidatorFactory;
import oracle.bpm.resources.Msg;

public abstract class BaseEngineLocationPreferences
extends CategoryPreference {
    protected StringPreference homeDir = new StringPreference("homeDir", this, null, null, null, "");
    protected StringPreference host;
    protected StringPreference logDir;
    protected StringPreference webConsoleURL;
    public static final String HOME_DIR_DEF = "";
    public static final String LOG_DIR_DEF = "";

    public BaseEngineLocationPreferences(String id, CategoryPreference parent) {
        this(id, parent, null, null, null);
    }

    public BaseEngineLocationPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.host = new StringPreference("host", this, null, null, null, id);
        this.logDir = new StringPreference("logDir", this, null, null, null, "");
        this.webConsoleURL = new StringPreference("webConsoleURL", (CategoryPreference)this, null, null, null, PrefValidatorFactory.createUrlPrefValidator(), "http://" + id + ":8686/webconsole");
    }

    public StringPreference getHomeDir() {
        return this.homeDir;
    }

    public StringPreference getHost() {
        return this.host;
    }

    public StringPreference getLogDir() {
        return this.logDir;
    }

    public StringPreference getWebConsoleURL() {
        return this.webConsoleURL;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.homeDir.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.host.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.logDir.validate();
        if (msg != null) {
            return msg;
        }
        return this.webConsoleURL.validate();
    }
}

