/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.TimePreference;
import fuego.prefs.validator.ErrorMsg;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

public abstract class BaseDisposerPreferences
extends CategoryPreference {
    protected StringPreference archivingConfiguration;
    protected BooleanPreference archivingEnabled;
    protected BooleanPreference disposeParticipants;
    protected IntegerPreference disposerLatency = new IntegerPreference("disposerLatency", this, DirectoryMsg.DISPOSE_LATENCY, null, CoreMsg.DAYS, 2, 1, 100, 1);
    protected TimePreference disposerStartingTime;
    protected IntegerPreference instanceCaducity;
    protected IntegerPreference participantCaducity;
    public static final int DISPOSER_LATENCY_DEF = 2;
    public static final int INSTANCE_CADUCITY_DEF = 15;
    public static final Time DISPOSER_STARTING_TIME_DEF = Time.now();
    public static final boolean ARCHIVING_ENABLED_DEF = false;
    public static final String ARCHIVING_CONFIGURATION_DEF = "";
    public static final int PARTICIPANT_CADUCITY_DEF = 30;
    public static final boolean DISPOSE_PARTICIPANTS_DEF = true;

    public BaseDisposerPreferences(CategoryPreference parent) {
        this("disposer", parent, null, null, null);
    }

    public BaseDisposerPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.disposerLatency.setModifiableInRuntime(true);
        this.instanceCaducity = new IntegerPreference("instanceCaducity", this, DirectoryMsg.DISPOSE_INSTANCE_CADUCITY, null, CoreMsg.DAYS, 15, 1, 1000, 1, 1, 100);
        this.instanceCaducity.setModifiableInRuntime(true);
        this.disposeParticipants = new BooleanPreference("disposeParticipants", this, DirectoryMsg.DISPOSE_PARTICIPANTS, null, null, true);
        this.disposeParticipants.setModifiableInRuntime(true);
        this.participantCaducity = new IntegerPreference("participantCaducity", this, DirectoryMsg.DISPOSE_PARTICIPANT_CADUCITY, null, CoreMsg.DAYS, 30, 15, 1000, 1);
        this.participantCaducity.setModifiableInRuntime(true);
        this.disposerStartingTime = new TimePreference("disposerStartingTime", this, DirectoryMsg.DISPOSER_STARTING_TIME, null, null, DISPOSER_STARTING_TIME_DEF);
        this.disposerStartingTime.setModifiableInRuntime(true);
        this.archivingEnabled = new BooleanPreference("archivingEnabled", this, DirectoryMsg.ARCHIVING_ENABLED, null, null, false);
        this.archivingConfiguration = new StringPreference("archivingConfiguration", this, DirectoryMsg.ARCHIVING_CONFIGURATION, null, null, ARCHIVING_CONFIGURATION_DEF);
    }

    public StringPreference getArchivingConfiguration() {
        return this.archivingConfiguration;
    }

    public BooleanPreference getArchivingEnabled() {
        return this.archivingEnabled;
    }

    public BooleanPreference getDisposeParticipants() {
        return this.disposeParticipants;
    }

    public IntegerPreference getDisposerLatency() {
        return this.disposerLatency;
    }

    public TimePreference getDisposerStartingTime() {
        return this.disposerStartingTime;
    }

    public IntegerPreference getInstanceCaducity() {
        return this.instanceCaducity;
    }

    public IntegerPreference getParticipantCaducity() {
        return this.participantCaducity;
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.archivingEnabled.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.disposeParticipants.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.disposerLatency.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.instanceCaducity.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.participantCaducity.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.archivingConfiguration.validate();
        if (msg != null) {
            return msg;
        }
        return this.disposerStartingTime.validate();
    }
}

