/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine;

import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.EngineTemplateType;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.base.BaseEnginePreferences;
import fuego.prefs.engine.j2ee.J2EEEnginePreferences;
import fuego.prefs.engine.standalone.StandaloneEnginePreferences;
import fuego.prefs.engine.standalone.studio.StudioEnginePreferences;
import fuego.prefs.engine.storage.EnginePreferencesNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import oracle.bpm.data.EnginePreferencesMigration;
import oracle.bpm.log.Log;
import oracle.bpm.util.FuegoDirectories;

public class EnginePreferences {
    public static final String DEFAULT_ENGINE_ID = "default";
    public static final String CONFIGURATION = "default";
    public static final String TEMPLATE_EXPRESS_INTERACTIVE = "Interactive";
    public static final String TEMPLATE_EXPRESS_AUTOMATIC = "Automatic";
    public static final String TEMPLATE_EXPRESS_MIXED = "Mixed";

    public static List<EngineTemplateType> getAvailableTemplates() {
        return Arrays.asList(EngineTemplateType.values());
    }

    public static BaseEnginePreferences create(EngineType engineType, String engineId) {
        String configuration = "default";
        EnginePreferencesNode root = EnginePreferences.initialize("default");
        return engineType.createPreferences(engineId, "default", root);
    }

    public static StudioEnginePreferences createLocal(String engineId, String homeDir, String logDir) {
        EnginePreferencesNode root = EnginePreferences.initialize("default");
        StudioEnginePreferences enginePreferences = new StudioEnginePreferences(engineId, "default", root);
        enginePreferences.getLocations()[0].getHomeDir().setValue(homeDir);
        enginePreferences.getLocations()[0].getLogDir().setValue(logDir);
        return enginePreferences;
    }

    public static StandaloneEnginePreferences createLocalFromTemplate(String templateId, String engineId, String homeDir, String logDir, EngineType type) throws IOException, BackingStoreException {
        FileInputStream is = new FileInputStream(new File(FuegoDirectories.configDir(), templateId + ".xml"));
        StandaloneEnginePreferences enginePreferences = EnginePreferences.doImportStandalone(engineId, is, type);
        enginePreferences.getTemplateId().setValue(templateId);
        enginePreferences.getLocations()[0].getHomeDir().setValue(homeDir);
        enginePreferences.getLocations()[0].getLogDir().setValue(logDir);
        return enginePreferences;
    }

    public static StandaloneEnginePreferences createStandalone(EngineType engineType, String engineId, String homeDir, String logDir) {
        assert (engineType.isStandalone()) : DirectoryMsg.MUST_BE_STANDALONE(engineId);
        EnginePreferencesNode root = EnginePreferences.initialize("default");
        StandaloneEnginePreferences enginePreferences = (StandaloneEnginePreferences)engineType.createPreferences(engineId, "default", root);
        enginePreferences.getLocations()[0].getHomeDir().setValue(homeDir);
        enginePreferences.getLocations()[0].getLogDir().setValue(logDir);
        return enginePreferences;
    }

    public static StandaloneEnginePreferences createStandaloneDefault(EngineType engineType) {
        String engineId = "default";
        assert (engineType.isStandalone()) : DirectoryMsg.MUST_BE_STANDALONE("default");
        EnginePreferencesNode root = EnginePreferences.initialize("default");
        return (StandaloneEnginePreferences)engineType.createPreferences("default", "default", root);
    }

    public static StandaloneEnginePreferences createStandaloneFromTemplate(String engineId, String templateId, EngineType type) throws IOException, BackingStoreException {
        InputStream is = EnginePreferences.class.getResourceAsStream("/fuego/" + templateId + ".xml");
        return EnginePreferences.doImportStandalone(engineId, is, type);
    }

    public static void doExport(BaseEnginePreferences preferences, OutputStream os) throws BackingStoreException, IOException {
        EnginePreferences.doExport(preferences, os, "UTF-8");
    }

    public static void doExport(BaseEnginePreferences preferences, OutputStream os, String encoding) throws BackingStoreException, IOException {
        EnginePreferencesNode enginePrefsRootNode = preferences.getRoot();
        enginePrefsRootNode.export(os, encoding);
    }

    public static BaseEnginePreferences doImport(String engineId, InputStream is) throws IOException, BackingStoreException {
        return EnginePreferences.doImport(engineId, is, null);
    }

    public static BaseEnginePreferences doImport(String engineId, InputStream is, EngineType type) throws IOException, BackingStoreException {
        EnginePreferencesNode rootNode = EnginePreferences.initialize("default");
        is = is.markSupported() ? is : new BufferedInputStream(is){

            @Override
            public void close() {
            }
        };
        is.mark(Integer.MAX_VALUE);
        try {
            rootNode.sync(is);
        }
        catch (InvalidPreferencesFormatException e) {
            Log.logWarning(DirectoryMsg.MIGRATING_PREFS);
            return EnginePreferencesMigration.migrate(engineId, is, rootNode, type == null ? EngineType.ENTERPRISE : type);
        }
        return rootNode.getType().createPreferences(engineId, "default", rootNode);
    }

    public static J2EEEnginePreferences doImportJ2EE(String engineId, InputStream is, EngineType type) throws IOException, BackingStoreException {
        assert (type.isJ2EE()) : DirectoryMsg.DIFFERENT_ENGINE_TYPE;
        BaseEnginePreferences preferences = EnginePreferences.doImport(engineId, is, type);
        assert (preferences.getType().isJ2EE()) : DirectoryMsg.DIFFERENT_ENGINE_TYPE;
        return (J2EEEnginePreferences)preferences;
    }

    public static StandaloneEnginePreferences doImportStandalone(String engineId, InputStream is, EngineType type) throws IOException, BackingStoreException {
        assert (type.isStandalone()) : DirectoryMsg.DIFFERENT_ENGINE_TYPE;
        BaseEnginePreferences preferences = EnginePreferences.doImport(engineId, is, type);
        assert (preferences.getType().isStandalone()) : DirectoryMsg.DIFFERENT_ENGINE_TYPE;
        return (StandaloneEnginePreferences)preferences;
    }

    public static StandaloneEnginePreferences doImportStandalone(String engineId, String properties, EngineType type) throws IOException, BackingStoreException {
        ByteArrayInputStream istr = new ByteArrayInputStream(properties.getBytes(EnginePreferencesNode.ENGINE_ENCODING));
        return EnginePreferences.doImportStandalone(engineId, istr, type);
    }

    public static BaseEnginePreferences loadBasePreferences(String engineId, DirectorySession session) throws BackingStoreException {
        EnginePreferencesNode rootNode;
        try {
            rootNode = EnginePreferences.initialize(engineId, "default", session);
        }
        catch (DirectoryException e) {
            throw new BackingStoreException(e);
        }
        if (rootNode == null) {
            return null;
        }
        try {
            rootNode.sync(engineId, session);
        }
        catch (InvalidPreferencesFormatException e) {
            Log.logWarning(DirectoryMsg.MIGRATING_PREFS);
            return EnginePreferencesMigration.migrate(engineId, session, rootNode, EngineType.ENTERPRISE);
        }
        return rootNode.getType().createPreferences(engineId, "default", rootNode);
    }

    public static J2EEEnginePreferences loadJ2EEPreferences(String engineId, DirectorySession session) throws BackingStoreException {
        EnginePreferencesNode rootNode;
        try {
            rootNode = EnginePreferences.initialize(engineId, "default", session);
        }
        catch (DirectoryException e) {
            throw new BackingStoreException(e);
        }
        if (rootNode == null) {
            return null;
        }
        try {
            rootNode.sync(engineId, session);
        }
        catch (InvalidPreferencesFormatException e) {
            Log.logWarning(DirectoryMsg.USING_DEFAULT_PREFS);
        }
        EngineType engineType = rootNode.getType();
        assert (engineType.isJ2EE()) : DirectoryMsg.DIFFERENT_ENGINE_TYPE;
        return (J2EEEnginePreferences)engineType.createPreferences(engineId, "default", rootNode);
    }

    public static StandaloneEnginePreferences loadStandalonePreferences(String engineId, InputStream is, EngineType type) throws BackingStoreException {
        EnginePreferencesNode rootNode;
        assert (type.isStandalone()) : "EngineType must be Standalone";
        is = is.markSupported() ? is : new BufferedInputStream(is){

            @Override
            public void close() {
            }
        };
        is.mark(Integer.MAX_VALUE);
        try {
            rootNode = EnginePreferences.initialize(engineId, "default", null);
        }
        catch (DirectoryException e) {
            throw new BackingStoreException(e);
        }
        if (rootNode == null) {
            return null;
        }
        try {
            rootNode.sync(is);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        catch (InvalidPreferencesFormatException e) {
            Log.logWarning(DirectoryMsg.MIGRATING_PREFS, e);
            return EnginePreferencesMigration.migrate(engineId, is, rootNode, type);
        }
        EngineType engineType = rootNode.getType();
        assert (engineType.isStandalone()) : DirectoryMsg.DIFFERENT_ENGINE_TYPE;
        return (StandaloneEnginePreferences)engineType.createPreferences(engineId, "default", rootNode);
    }

    public static StandaloneEnginePreferences loadStandalonePreferences(String engineId, DirectorySession session, EngineType type) throws BackingStoreException {
        EnginePreferencesNode rootNode;
        assert (type.isStandalone()) : "EngineType must be Standalone";
        try {
            rootNode = EnginePreferences.initialize(engineId, "default", session);
        }
        catch (DirectoryException e) {
            throw new BackingStoreException(e);
        }
        if (rootNode == null) {
            return null;
        }
        try {
            rootNode.sync(engineId, session);
        }
        catch (InvalidPreferencesFormatException e) {
            Log.logWarning(DirectoryMsg.MIGRATING_PREFS);
            return EnginePreferencesMigration.migrate(engineId, session, rootNode, type);
        }
        EngineType engineType = rootNode.getType();
        assert (engineType.isStandalone()) : DirectoryMsg.DIFFERENT_ENGINE_TYPE;
        return (StandaloneEnginePreferences)engineType.createPreferences(engineId, "default", rootNode);
    }

    public static void main(String[] args) throws BackingStoreException, IOException {
        EnginePreferencesNode rootNode;
        StandaloneEnginePreferences sep;
        block3: {
            sep = EnginePreferences.createStandaloneDefault(EngineType.ENTERPRISE);
            rootNode = sep.getRoot();
            String fileName = "/tmp/TestPreferences.xml";
            File file = new File("/tmp/TestPreferences.xml");
            if (!file.exists()) {
                file.createNewFile();
            }
            InputStream bi = new FileInputStream(file);
            bi = new BufferedInputStream(bi){

                @Override
                public void close() {
                }
            };
            bi.mark(Integer.MAX_VALUE);
            try {
                rootNode.sync(bi);
            }
            catch (InvalidPreferencesFormatException e) {
                if (file.length() == 0L) break block3;
                Log.logWarning(DirectoryMsg.MIGRATING_PREFS);
                String engineId = "TestServerId";
                sep = EnginePreferencesMigration.migrate("TestServerId", bi, rootNode, EngineType.ENTERPRISE);
            }
        }
        System.out.println(sep.getRuntimeConfiguration().getKey() + " = " + sep.getRuntimeConfiguration().getValue());
        sep.getRuntimeConfiguration().setValue("runtimeConfiguration");
        System.out.println(sep.getExecution().getAutomaticItemsQueueSize().getKey() + " = " + sep.getExecution().getAutomaticItemsQueueSize().getValue());
        sep.getExecution().getAutomaticItemsQueueSize().setValue(2000);
        System.out.println(sep.getLog().getMaxLogFiles().getKey() + " = " + sep.getLog().getMaxLogFiles().getValue());
        sep.getLog().getMaxLogFiles().setValue(10);
        FileOutputStream fo = new FileOutputStream("/tmp/TestPreferences.xml");
        rootNode.export(fo);
    }

    public static void store(BaseEnginePreferences enginePreferences, OutputStream os, String encoding) throws BackingStoreException {
        EnginePreferencesNode enginePrefsRootNode = enginePreferences.getRoot();
        enginePrefsRootNode.flush(enginePreferences.getServerId().getValue(), os, encoding);
    }

    public static void store(BaseEnginePreferences enginePreferences, DirectorySession session) throws BackingStoreException {
        EnginePreferencesNode enginePrefsRootNode = enginePreferences.getRoot();
        enginePrefsRootNode.flush(enginePreferences.getServerId().getValue(), session);
    }

    private static EnginePreferencesNode initialize(String configuration) {
        try {
            return EnginePreferences.initialize(null, configuration, null);
        }
        catch (DirectoryException directoryException) {
            return null;
        }
    }

    private static EnginePreferencesNode initialize(String engineId, String configuration, DirectorySession session) throws DirectoryException {
        if (session != null && EnginePreferencesNode.fetchEngineConfiguration(engineId, configuration, session) == null) {
            return null;
        }
        return new EnginePreferencesNode(configuration);
    }
}

