/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs;

import fuego.prefs.CategoryPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.StringPrefValidator;
import java.io.UnsupportedEncodingException;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Base64;
import oracle.bpm.util.SimpleCrypt;

public class PasswordPreference
extends StringPreference {
    private static final String KEY = "secret";
    private static final String CHARSET_NAME = "UTF-8";

    public PasswordPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, String defaultValue) {
        super(id, parent, label, help, hint, PasswordPreference.cryptValue(defaultValue));
    }

    public PasswordPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, StringPrefValidator validator, String defaultValue) {
        super(id, parent, label, help, hint, validator, PasswordPreference.cryptValue(defaultValue));
    }

    public PasswordPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, String regExp, Msg errorMsg, String defaultValue) {
        super(id, parent, label, help, hint, regExp, errorMsg, PasswordPreference.cryptValue(defaultValue));
    }

    @Override
    public void setValue(String value) {
        this.setStringValue(value);
    }

    @Override
    public void setStringValue(String value) {
        super.setStringValue(PasswordPreference.cryptValue(value));
    }

    @Override
    public String getValue() {
        String encoded = super.getValue();
        String result = null;
        if (encoded != null) {
            byte[] decoded = Base64.decode(encoded);
            SimpleCrypt crypt = new SimpleCrypt(KEY, true);
            try {
                result = new String(crypt.crypt(decoded), CHARSET_NAME);
            }
            catch (UnsupportedEncodingException e) {
                Log.logSevere(e);
            }
        }
        return result;
    }

    private static String cryptValue(String value) {
        if (value == null) {
            return null;
        }
        try {
            SimpleCrypt crypt = new SimpleCrypt(KEY, true);
            return Base64.encode(crypt.crypt(value.getBytes(CHARSET_NAME)));
        }
        catch (UnsupportedEncodingException e) {
            Log.logSevere(e);
            return null;
        }
    }
}

