/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs;

import fuego.prefs.CategoryPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.StringPrefValidator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.bpm.resources.Msg;

public class LocalhostPreference
extends StringPreference {
    public static final String LOCALHOST = "$LOCALHOST$";
    protected static final String LOCALHOST_REGEX = "\\$LOCALHOST\\$";

    public LocalhostPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, String defaultValue) {
        super(id, parent, label, help, hint, defaultValue);
    }

    public LocalhostPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, StringPrefValidator validator, String defaultValue) {
        super(id, parent, label, help, hint, validator, defaultValue);
    }

    public static String getLocalhost() {
        String localHostName = "localhost";
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHostName;
    }

    @Override
    public String getStringDefaultValue() {
        String value = super.getStringDefaultValue();
        if (value.indexOf(LOCALHOST) != -1) {
            String localHostName = LocalhostPreference.getLocalhost();
            value = value.replaceAll(LOCALHOST_REGEX, localHostName);
        }
        return value;
    }

    @Override
    public void setStringValue(String value) {
        String localHostName = LocalhostPreference.getLocalhost();
        if (value.indexOf(localHostName) != -1) {
            value = value.replaceAll(localHostName, LOCALHOST_REGEX);
        }
        super.setStringValue(value);
    }

    @Override
    public String getStringValue() {
        String value = super.getStringValue();
        if (value.indexOf(LOCALHOST) != -1) {
            String localHostName = LocalhostPreference.getLocalhost();
            value = value.replaceAll(LOCALHOST_REGEX, localHostName);
        }
        return value;
    }

    @Override
    public void setValue(String value) {
        this.setStringValue(value);
    }

    @Override
    public String getValue() {
        return this.getStringValue();
    }

    @Override
    public String toString() {
        return this.getStringValue();
    }

    protected void setStringValueInternal(String value) {
        super.setStringValue(value);
    }
}

