/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.util;

import fuego.directory.msg.DirectoryMsg;
import fuego.directory.util.ParsingCompletedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class SchemaIdParser
extends DefaultHandler {
    private String currentSchemaId;
    private String currentSchemaVersion;

    private SchemaIdParser() {
    }

    public static String getSchemaId(File exportFile) {
        assert (exportFile != null && exportFile.exists()) : "The export file must exist! " + exportFile;
        SchemaIdParser parser = new SchemaIdParser();
        try {
            FileInputStream source = new FileInputStream(exportFile);
            parser.parseExportFile(source);
        }
        catch (FileNotFoundException e) {
            Log.logWarning(DirectoryMsg.DII_00003);
            Log.logInfo(e);
        }
        return parser.currentSchemaId;
    }

    public static String getSchemaId(InputStream stream) {
        assert (stream != null);
        SchemaIdParser parser = new SchemaIdParser();
        parser.parseExportFile(stream);
        return parser.currentSchemaId;
    }

    public static String getSchemaVersion(InputStream stream) {
        assert (stream != null);
        SchemaIdParser parser = new SchemaIdParser();
        parser.parseExportFile(stream);
        return parser.currentSchemaVersion;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        super.error(e);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equalsIgnoreCase("FDIObject")) {
            this.currentSchemaId = attrs.getValue("Organization");
            this.currentSchemaVersion = attrs.getValue("SchemaVersion");
            throw new ParsingCompletedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseExportFile(InputStream source) {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(source);
            saxParser.parse(inputSource, (DefaultHandler)this);
            return;
        }
        catch (ParserConfigurationException e) {
            Log.logWarning(DirectoryMsg.DII_00003);
            Log.logInfo(e);
            return;
        }
        catch (SAXException e) {
            if (e.getException() == null) return;
            if (!(e.getException() instanceof RuntimeException)) return;
            if (e.getException() instanceof ParsingCompletedException) {
                return;
            }
            Log.logWarning(DirectoryMsg.DII_00003);
            Log.logInfo(e);
            return;
        }
        catch (IOException e) {
            Log.logWarning(DirectoryMsg.DII_00003);
            Log.logInfo(e);
            return;
        }
        catch (ParsingCompletedException e) {
            if (source == null) return;
            try {
                source.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

