/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.util;

import fuego.directory.DirectoryException;
import fuego.directory.msg.DirectoryMsg;
import java.io.IOException;
import oracle.bpm.resources.Msg;
import org.xml.sax.SAXParseException;

public class DirectoryImportException
extends DirectoryException {
    String fileName;
    String id;
    static final long serialVersionUID = 2075355028058710607L;
    static final long serialCheck = 4847916008485863626L;

    protected DirectoryImportException(Msg msg, String id, String fileName) {
        super(msg);
        this.fileName = fileName;
        this.id = id;
    }

    public static DirectoryImportException conversionFrom41Exception(String fileName, Throwable cause) {
        DirectoryImportException result = new DirectoryImportException(DirectoryMsg.DII_00044(fileName), null, fileName);
        result.initCause(cause);
        return result;
    }

    public static DirectoryImportException ioExceptionOnGeneratePasswords(String id, String fileName, IOException cause) {
        DirectoryImportException result = new DirectoryImportException(DirectoryMsg.DII_00042(id, fileName), id, fileName);
        result.initCause(cause);
        return result;
    }

    public static DirectoryImportException notAnFDIExportFile(String fileName) {
        DirectoryImportException result = new DirectoryImportException(DirectoryMsg.DII_00045(fileName), null, fileName);
        return result;
    }

    public static DirectoryImportException parserException(String fileName, SAXParseException cause) {
        DirectoryImportException result = new DirectoryImportException(DirectoryMsg.DII_00043(fileName, cause.getLineNumber(), cause.getMessage()), null, fileName);
        result.initCause(cause.getException() != null ? cause.getException() : cause);
        return result;
    }

    public static DirectoryImportException roleDoesNotExistInAssignment(String role) {
        DirectoryImportException result = new DirectoryImportException(DirectoryMsg.DII_00046(role), null, null);
        return result;
    }

    public static DirectoryImportException roleExistsAndParametricDiffers(String role, boolean isParametric) {
        DirectoryImportException result = new DirectoryImportException(DirectoryMsg.DII_00047(role, isParametric), null, null);
        return result;
    }

    public static DirectoryImportException xmlParseException(String fileName, Throwable cause) {
        DirectoryImportException result = new DirectoryImportException(DirectoryMsg.DII_00041(fileName), null, fileName);
        result.initCause(cause);
        return result;
    }

    public static DirectoryImportException participantDoesNotExistInAssignment(String participant) {
        return new DirectoryImportException(DirectoryMsg.DII_00048(participant), null, null);
    }

    public String getFileName() {
        return this.fileName;
    }
}

